<?php

    class cashbookAccount extends Object {
    	var $account_srl             = null;    // 일련번호
    	var $site_srl                = null;    // 사이트일련번호, site.site_srl
    	var $module_srl              = null;    // 모듈일련번호, modules.module_srl
		var $member_srl              = null;    // 회원일련번호, member.member_srl
		var $kind                    = null;    // 계정종류: 현금(CASH), 통장(BANK), 자산(ASSET), 카드(CARD), 부채(DEBT)
		var $category_srl            = null;
		var $title                   = null;
		var $day                     = null;
		var $amount                  = null;
		var $total_asset_yn          = null;    // 총자산포함
		
		var $pay_day                 = null;
		var $installment_start_month = null;
		var $installment_start_day   = null;
		var $installment_end_month   = null;
		var $installment_end_day     = null;
		var $card_start_month        = null;
		var $card_start_day          = null;
		var $card_end_month          = null;
		var $card_end_day            = null;
		var $memo                    = null;
    	var $input_date              = null;
		var $amount_total            = null;		// 계정에 속산 거래의 합
		var $deal_count_yesterday    = null;    // 어제거래수
		var $deal_count_today        = null;    // 오늘거래수
    	var $deal_amount             = null;
    	
    	
    	/**
		 * 생성자
		 * 
		 * @param $cashbook_srl
		 * @return unknown_type
		 */
        function cashbookAccount($account_srl = 0) { 
            if(!$account_srl) return;
            $this->setCashbookAccount($account_srl);
        }
        
    	/**
         * 
         * 
         * @param $config_srl
         * @return unknown_type
         */
        function setCashbookAccount($account_srl) { 
            $this->account_srl = $account_srl;
            $this->_loadFromDB();
        }
        
    	/**
         * DB에 저장된 설정 가져오기
         * @return unknown_type
         */
    	function _loadFromDB() {
            if(!$this->account_srl) return;

            $args->account_srl = $this->account_srl;
            $output = executeQuery('cashbook.getAccount', $args);
            if(!$output->toBool()||!$output->data) return;

            $this->setAttribute($output->data);
        }
        
    	/**
         * 객체를 받아서 값을 세팅한다.
         * 
         * @param $attribute
         * @return unknown_type
         */
        function setAttribute($attribute) {
        	$this->account_srl = $attribute->account_srl;
            $this->module_srl =  $attribute->module_srl;
            $this->member_srl = $attribute->member_srl;
            $this->kind = $attribute->kind;
            $this->title = $attribute->title;
            $this->amount = $attribute->amount;
            $this->amount_total = $attribute->amount_total;
            $this->deal_count_yesterday = $attribute->deal_count_yesterday;
			$this->deal_count_today = $attribute->deal_count_today;
			$this->deal_amount = $attribute->deal_amount;
			$this->total_asset_yn = $attribute->total_asset_yn;
            $this->adds($attribute);
        }
        
    	/**
         * 존재여부
         * 
         * @return unknown_type
         */
    	function isExists() {
            return $this->account_srl?true:false;
        }
        
        /**
         * getter
         * @return unknown_type
         */
    	function getAccountSrl(){
			if(!$this->isExists()) return;
            return $this->get('account_srl'); 
        }
        
        function getKind(){
        	if(!$this->isExists()) return;

        	$tempKind = $this->kind;        	
        	if($tempKind=='CASH'){
        		$kind = "현금";
        	} elseif($tempKind=='BANK'){
        		$kind = "은행";
        	} elseif($tempKind=='ASSET'){
        		$kind = "자산";
        	} elseif($tempKind=='CARD'){
        		$kind = "카드";
        	} elseif($tempKind=='DEBT'){
        		$kind = "부채";
        	}
        	
        	return $kind;
        }
        
    	function getTitle(){
			if(!$this->isExists()) return;
            return $this->get('title'); 
        }
        
    	function getAmount(){
			if(!$this->isExists()) return;
            return $this->get('amount'); 
        }
		
    	function getDay(){
			if(!$this->isExists()) return;
            return $this->get('day'); 
        }
        
    	function getAmountTotal(){
        	if(!$this->isExists()) return;
            return $this->get('amount_total');
        }
        
    	function getDealAmount(){
        	if(!$this->isExists()) return;
            return $this->get('deal_amount');
        }
        
    	function getCategorySrl(){
        	if(!$this->isExists()) return;
            return $this->get('category_srl');
        }
    	
        function getMemo(){
        	if(!$this->isExists()) return;
            return $this->get('memo');
        }
        
    	function getTotalAssetYn(){
        	if(!$this->isExists()) return;
            return $this->get('total_asset_yn');
        }
    }
    
?>