jQuery(function($){
    
    //삭제용 히든폼 생성
    var del_form = $('<form action="./" method="post" id="fo_delAddr" style="display:none;">');
    del_form.appendTo('body');
    
    //전화번호 형식 설정
    $('table.addr_table').find('td.addr_phonenum').each( function(){
       var pNum = toPhoneNumber($(this).text(), '-');
       $(this).text(pNum);       
    });
            
    //신규등록폼 보기
    $('button#btn_addAddr').click( function(){
        $('button#btn_addAddr_cancel').show();
        $('tr#tr_addAddr').show();
        $(this).hide();
        $('tr#tr_addAddr').find('input[name=addr_name]').focus();
    });

    //신규등록 취소
    $('button#btn_addAddr_cancel').click( function(){
        $('button#btn_addAddr').show();
        $('tr#tr_addAddr').find('input').val('');
        $('tr#tr_addAddr').hide();
        $(this).hide();
    });
    
    //수정하기
    $('button[name=btn_modify_addr]').click( function(){
        
        var tr = $(this).parents('tr');
        
        var addr_srl = tr.find('td.addr_srl > input[name=addr_list]').val();
        
        var td = tr.find('td.group_title');
        var select_group = $('select#group_select').clone();
        select_group.removeAttr('id').attr('name','addr_group_srl');
        
        select_group.find('option:contains('+td.text()+')').attr('selected','selected');
        td.text('');
        select_group.appendTo(td);
        
        var input_name = $('<input type="text" name="addr_name" class="inputText w100">');
        td = tr.find('td.addr_name');
        input_name.val(td.text());
        td.text('').append(input_name);
        
        var input_phonenum = $('<input type="text" name="addr_phonenum" class="inputText w100">');
        td = tr.find('td.addr_phonenum');
        input_phonenum.val(td.text());
        td.text('').append(input_phonenum);
        
        var input_memo = $('<input type="text" name="addr_memo" class="inputText w300">');
        td = tr.find('td.addr_memo');
        input_memo.val(td.text());
        td.text('').append(input_memo);
        
        $(this).hide();
        tr.find('button[name=btn_modify_addr_submit]').show();
        
        
    });
    
    //수정완료
    $('button[name=btn_modify_addr_submit]').click( function(){
        var self = $(this);
        
        var tr = $(this).parents('tr');
        
        var addr_srl = tr.find('td.addr_srl > input[name=addr_list]').val();
        var addr_group_srl = tr.find('td.group_title > select[name=addr_group_srl]').val();
        if(addr_group_srl=="") addr_group_srl = 0;
        var addr_name = tr.find('input[name=addr_name]').val();
        var addr_phonenum = tr.find('input[name=addr_phonenum]').val();
        if(!checkPhoneFormat(addr_phonenum)) {
            alert("전화번호 형식이 맞지 않습니다.\n휴대폰전화번호만 가능하며 문자 '-'만 사용가능합니다.");
            return;
        }
        var addr_memo = tr.find('input[name=addr_memo]').val();
        
        
        
        function callback(data) {
            if(data.updated == true) {
            
            
            // 수정완료시 테이블 복구
            var txt = tr.find('td.group_title > select > option:selected').text();
            if(txt == '그룹미지정') txt=" ";
            tr.find('td.group_title').text(txt);
            
            tr.find('td.addr_name').text(data.addr_name);
            
            tr.find('td.addr_phonenum').text(toPhoneNumber(data.addr_phonenum,'-'));
            
            tr.find('td.addr_memo').text(data.addr_memo);
            
            self.hide();
            tr.find('button[name=btn_modify_addr]').show();
            
            } else alert('수정작업중 오류가 발생하였습니다.');
                
        }
        
        $.exec_json('smsontextyle.procSmsontextyleUpdateAddr', {addr_srl:addr_srl,addr_group_srl:addr_group_srl,addr_name:addr_name,addr_phonenum:addr_phonenum,addr_memo:addr_memo}, callback);
        
    });
    
    
    // 단일 주소록 삭제
    $('button[name=btn_delete_addr]').click( function(){

        var tr = $(this).parents('tr');
        var addr_srl = tr.find('td.addr_srl > input[name=addr_list]').val();
        del_form.children().remove();
        del_form.append('<input type="hidden" name="addr_srl_list" value="'+addr_srl+'">');
        
        del_form.unbind('submit');
        del_form.bind('submit', function(){
            return procFilter(this, delete_addr);
        });
        
        del_form.submit();
    });
    
    // 다중 주소록 삭제
    $('button[name=btn_delete_addrs]').click( function(){
        
        del_form.children().remove();
        $('table.addr_table').find('input[name=addr_list]:checked').each(function(){
            del_form.append('<input type="checkbox" name="addr_srl_list" value="'+$(this).val()+'" checked>');
        });
        
        del_form.unbind('submit');
        del_form.bind('submit', function(){
            return procFilter(this, delete_addr);
        });
        
        del_form.submit();
    });
    
    // 주소록 그룹 변경하기
    $('button[name=btn_move_group]').click( function(){
        del_form.children().remove();
        $('table.addr_table').find('input[name=addr_list]:checked').each(function(){
            del_form.append('<input type="checkbox" name="addr_srl_list" value="'+$(this).val()+'" checked>');
        });
        
        del_form.append('<input type="hidden" name="target_addr_group_srl" value="'+$(this).attr('srl')+'">');

        del_form.unbind('submit');
        del_form.bind('submit', function(){
            return procFilter(this, move_addr);
        });
        
        del_form.submit();
    });
    
    // 그룹별로 주소록보기
    $('button[name=btn_sel_group]').click( function(){
            location.href = current_url.setQuery('addr_group_srl', $(this).attr('srl'));
    });
    
    
    //그룹관리-그룹선택
    $('button[name=btn_set_group]').click( function(){
        $(this).parents('ul').toggleClass('open');
        $('button[name=selected_group]').text($(this).text()).attr('srl',$(this).attr('srl'));
        
        // 변경, 삭제버튼 이벤트 활성화
        $('button[name=btn_modify_group]').unbind('click').bind('click', {title:$(this).text(), srl: $(this).attr('srl')}, group_modify);
        $('button[name=btn_delete_group]').unbind('click').bind('click', {srl: $(this).attr('srl')}, group_delete);
        
    });

    
    //그룹관리-그룹생성
    $('button[name=btn_insert_group]').click( function(){
        $('fieldset.group_modify').show();
        $('fieldset.group_setting').hide();
        
        $('input[name=group_title]').focus().val('').prev().text('새로 추가할 그룹명: ');
        $('input[name=group_title]').removeAttr('srl');
        $('button[name=btn_setting_group_submit]').text('추가');
    });
    
    //그룹관리-그룹명변경(생성)완료
	$('input[name=group_title]').keypress(function(e){ 
	  	if(e.keyCode == 13) { 
	  		$('button[name=btn_setting_group_submit]').click();
	  		return false;
	  	}
	});
    
    //그룹관리-그룹명변경(생성)완료
    $('button[name=btn_setting_group_submit]').click( function(){
        
        var addr_group_srl = $('button[name=selected_group]').attr('srl');
        var title = $('input[name=group_title]').val();
        if(title.length<1) {
            alert('그룹명을 입력하세요')
            return false;
        }
        if(addr_group_srl)
            $.exec_json('smsontextyle.procSmsontextyleRenameAddrGroup', {target_addr_group_srl:addr_group_srl,title:title}, function(data){alert('변경되었습니다');location.reload();});
        else
            $.exec_json('smsontextyle.procSmsontextyleAddAddrGroup', {title:title}, function(data){alert('추가되었습니다');location.reload();});
    });   
    
    //그룹관리-그룹명변경
    function group_modify(event) {
        $('fieldset.group_modify').show();
        $('fieldset.group_setting').hide();
        
        $('input[name=group_title]').val(event.data.title).prev('p').html('새로 변경할 그룹명: ');
        $('input[name=group_title]').attr('srl', event.data.srl);
        $('button[name=btn_setting_group_submit]').text('변경');
    }
    
    //그룹관리-그룹삭제
    function group_delete(event) {
        if(confirm("삭제할 그룹에 속하는 주소록은 '그룹미지정'으로 설정됩니다. 삭제하시겠습니까?"))
            $.exec_json('smsontextyle.procSmsontextyleDeleteAddrGroup', {addr_group_srl:event.data.srl}, function(data){alert('삭제되었습니다');location.reload();});
    }
    
});
