<?php
    class smsontextyleView extends smsontextyle {

        /**
         * @brief 초기화
         **/
        function init() {
            $this->setTemplatePath($this->module_path.'tpl');
        }

        /**
         * @berif 텍스타일에서의 API 설정
         **/
        function dispSmsontextyleConfigTextyle() {
            //디비에 정보가 있는지 검사
            $oSmsontextyleModel = &getModel('smsontextyle');
            $sms_siteInfo =$oSmsontextyleModel->getSmsontextyleSiteInfo();

            $mode = Context::get('mode');

            //디비에 정보가 있으면 기본설정페이지 보이기
            if($sms_siteInfo) {
                Context::set('sms_site_info', $sms_siteInfo);

                if($mode == 'addrbook')
                    $this->dispSmsontextyleAddrbook();
                else if($mode == 'sendsms')
                    return $this->dispSmsontextyleSmsSend();
                else
                    $this->setTemplateFile('textyle_api_config');
            }
            else {

                //디비에 정보가 없으면 로그인페이지 보이기
                if($mode == 'signup')
                    $this->setTemplateFile('sms_signup');
                else
                    $this->setTemplateFile('sms_login');
            }
        }


        /**
         * @brief sms전송창 보기
         **/
        function dispSmsontextyleSmsSend() {
            
            $logged_info = Context::get('logged_info');
    		$is_logged = Context::get('is_logged');
    		
    		//최대발신바이트, 최대받는사람수 디폴트값설정
    		if(!$args->max_byte) $sms_info->max_byte = 0;
    		else $sms_info->max_byte = $args->max_byte;
    		if(!$args->max_rnum) $sms_info->max_rnum = 0;
    		else $sms_info->max_rnum= $args->max_rnum;
    		$sms_info->initial_msg = $args->initial_msg;
    		$sms_info->notice_content = $args->notice_content;
    		
    		$sms_info->permit = false;	// 사용권한을 false로 초기화
    		
    		if($is_logged) {
    			
    			    
    			$oMemberModel = &getModel('member');
    			$oSmsontextyleModel = &getModel('smsontextyle');
    			
    			$sms_site_info = $oSmsontextyleModel->getSmsontextyleSiteInfo();
    			if($sms_site_info) {
    
    			    $sms_info->permit = true;
        			//회신번호를 지정한 경우
        			$sms_info->rec_pcs = $args->rec_pcs;
        
        			//회신번호를 지정하지 않은 경우
        			if(!$sms_info->rec_pcs) {
        				$sms_info->rec_pcs = $sms_site_info->cb_phone_num;;
        		    }
        		    
        			// 주소록목록 가져오기
        			$tmp_group_list = $oSmsontextyleModel->getAddrGroups();
        			
                    $group_count = count($tmp_group_list);
                    for($i=0;$i<$group_count;$i++) $addr_group_list[$tmp_group_list[$i]->addr_group_srl] = $tmp_group_list[$i];
                    Context::set('addr_group_list', $addr_group_list);
                    
                    //$obj->addr_group_srl = $addr_group_srl;	//필요없음
                    $obj->member_srl = $logged_info->member_srl;
                    //$obj->page = 1;								//필요없음
                    $obj->sort_index = 'addr_name';			//친구목록을 친구이름의 가나다 순으로 가져옴
                    $obj->list_count = 99999;						//모든 친구목록을 가져옴
                    $output = executeQuery('smsontextyle.getAddrs', $obj);
        	    	$addr_count = count($output->data);
        	    	
        	    	if($addr_count) 
        	    	{
                        foreach($output->data as $key => $val) 
                        {
                            $group_srl = $val->addr_group_srl;
                            $group_title = $addr_group_list[$group_srl]->title;
                            if(!$group_title) $group_title = '미지정';
                            $output->data[$key]->group_title = $group_title;
                        }
                    }
           		    Context::set('addr_list', $output->data);
        		}
        	}
    
    		$site_module_info = Context::get('site_module_info');
    		$site_moduel_srl = $site_module_info->module_srl;
    		if(!$site_moduel_srl) $site_moduel_srl = Context::get('module_srl');
    
    		Context::set('sms_info', $sms_info);
            
            $this->setTemplateFile('sms_send');   
        }

        /**
         * @brief 주소록 목록 보기
         **/
        function dispSmsontextyleAddrbook() {

            // 로그인이 되어 있지 않으면 오류 표시
            if(!Context::get('is_logged')) return $this->stop('msg_not_logged');
            
            $oSmsontextyleModel = &getModel('smsontextyle');
            $oSmsontextyleController = &getController('smsontextyle');

            // 그룹 목록을 가져옴
            $tmp_group_list = $oSmsontextyleModel->getAddrGroups();
            $group_count = count($tmp_group_list);

            for($i=0;$i<$group_count;$i++) $addr_group_list[$tmp_group_list[$i]->addr_group_srl] = $tmp_group_list[$i];
            Context::set('addr_group_list', $addr_group_list);

            // 주소록 목록을 가져옴
            $addr_group_srl = Context::get('addr_group_srl');

            $output = $oSmsontextyleModel->getAddrs($addr_group_srl);
            $addr_count = count($output->data);
            if($addr_count) {
                foreach($output->data as $key => $val) {
                    $group_srl = $val->addr_group_srl;
                    $group_title = $addr_group_list[$group_srl]->title;
                    if(!$group_title) $group_title = Context::get('default_addr_group');
                    $output->data[$key]->group_title = $group_title;
                }
            }

            // 템플릿에 쓰기 위해서 context::set
            if($addr_group_srl == null) Context::set('group_title', 'all');
            if($addr_group_srl != null) Context::set('group_title', $addr_group_list[$addr_group_srl]->title);

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('addr_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);

            $this->setTemplateFile('addr_list');
        }

        /**
         * @brief 문자전송후 결과창
         **/
        function dispSmsontextyleResultSend() {

            // 로그인이 되어 있지 않으면 오류 표시
            if(!Context::get('is_logged')) return $this->stop('msg_not_logged');
            
            $oSmsontextyleModel = &getModel('smsontextyle');
            $oSmsontextyleController = &getController('smsontextyle');

            // 그룹 목록을 가져옴
            $tmp_group_list = $oSmsontextyleModel->getAddrGroups();
            $group_count = count($tmp_group_list);

            for($i=0;$i<$group_count;$i++) $addr_group_list[$tmp_group_list[$i]->addr_group_srl] = $tmp_group_list[$i];
            Context::set('addr_group_list', $addr_group_list);

            $this->setTemplateFile('ResultSend');
        }

        function dispSmsontextyleAddrbookPopup() {
            $logged_info = Context::get('logged_info');
            $is_logged = Context::get('is_logged');

            //최대발신바이트, 최대받는사람수 디폴트값설정
            if(!$args->max_rnum) $sms_info->max_rnum = 20;
            else $sms_info->max_rnum= $args->max_rnum;

            $sms_info->permit = false;	// 사용권한을 false로 초기화

            if($is_logged) {
                if($logged_info->is_site_admin)
                    $sms_info->permit = true;

                $oMemberModel = &getModel('member');
                $oSmsontextyleModel = &getModel('smsontextyle');

                $sms_site_info = $oSmsontextyleModel->getSmsontextyleSiteInfo();

                //회신번호를 지정한 경우
                $sms_info->rec_pcs = $args->rec_pcs;

                //회신번호를 지정하지 않은 경우
                if(!$sms_info->rec_pcs) {
                    $sms_info->rec_pcs = $sms_site_info->cb_phone_num;;
                }

                // 주소록목록 가져오기
                $tmp_group_list = $oSmsontextyleModel->getAddrGroups();

                $group_count = count($tmp_group_list);
                for($i=0;$i<$group_count;$i++) $addr_group_list[$tmp_group_list[$i]->addr_group_srl] = $tmp_group_list[$i];
                Context::set('addr_group_list', $addr_group_list);

                //$obj->addr_group_srl = $addr_group_srl;	//필요없음
                $obj->member_srl = $logged_info->member_srl;
                //$obj->page = 1;								//필요없음
                $obj->sort_index = 'addr_name';			//친구목록을 친구이름의 가나다 순으로 가져옴
                $obj->list_count = 99999;						//모든 친구목록을 가져옴
                $output = executeQuery('smsontextyle.getAddrs', $obj);
                $addr_count = count($output->data);

                if($addr_count)
                {
                    foreach($output->data as $key => $val)
                    {
                        $group_srl = $val->addr_group_srl;
                        $group_title = $addr_group_list[$group_srl]->title;
                        if(!$group_title) $group_title = '미지정';
                        $output->data[$key]->group_title = $group_title;
                    }
                }
                Context::set('addr_list', $output->data);
            }

            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            // 템플릿 파일을 지정
            if(Context::get('mode') == 'addr_book') $tpl_file = 'sms_addrbook';
            else $tpl_file = 'sms_widget';


            $site_module_info = Context::get('site_module_info');
            $site_moduel_srl = $site_module_info->module_srl;
            if(!$site_moduel_srl) $site_moduel_srl = Context::get('module_srl');

            Context::set('sms_info', $sms_info);

            $this->setLayoutFile('popup_layout');
            $this->setTemplateFile('AddrbookPopup');
        }
    }



?>