
// 모두 숫자인지 검사
function checkNumberOnly(num){
	
	if ( num == null ) return false ;
	   
	for(var i=0;i<num.length;i++){		  
	   var c=num.charCodeAt(i);	   
	   if( !(  0x30 <= c && c <= 0x39 ) ) {		 
		return false ;	   
	   }
	 }	  
	return true ;
}

//전화번호 포멧 검사
function checkPhoneFormat(str) {
    var reg = new RegExp("^01(0|1|6|7|8|9)(-)?[0-9]{3,4}(-)?[0-9]{4}$")
    return reg.test(str)
}

//전화번호에서 '-'제거
function toOnlyNumber(str,s,d){
 var i=0;

 while(i > -1){
  i = str.indexOf(s);
  str = str.substr(0,i) + d + str.substr(i+1,str.length);
 }
 return str;
}


//주소록 추가 함수 (실제함수는 본 파일 아래에서 연결해준다)
var addAddr;
var addGroup;
var addNum;


/************** JQUERY FUNCTION ****************/
(function($) {
	
	/************************************
	 			받는사람창 
	 ************************************/
	
	// 받는사람수 업데이트
	function updateNumofPnumber()
	{
		var r_num = $('li', '.rnumlist_body ul').size();
	  	$('#reciever_num').text( r_num );
	  
	  	if(r_num > max_rnum) $('#reciever_num').css('color','red');
	  	else $('#reciever_num').css('color','#787878');
	  	
	  	//받는사람이 업데이트되면 받는사람에 추가된 주소체크
	  	addedAddrCheck();
		return r_num;
	}
	
	
	// 받은사람 목록에 존재하는 번호인지 조사
	function isExistNum(newNum)
	{
		var pureNum = toOnlyNumber(newNum, "-", "");
		var exist = false;
		var $listAll = $('li', '.rnumlist_body ul')
		
		$listAll.each(function(idx) {
				var eNum = toOnlyNumber($('.number',this).text(), "-", "");
				if(pureNum == eNum)
				{
					exist = true;
					return;
				}
		});
		
		return exist;
			
	}
	
	// 받는사람 추가
	addNum = function(newNum, rName) 
	{
		
		// 전화번호 포멧검사
		if(!checkPhoneFormat(newNum)) {
			alert("유효하지 않은 전화번호입니다 (" + newNum + ") \n추가목록에서 제외됩니다");
			return false;
		}
		
		// 이미 존재하는 번호인지 검사
		if(isExistNum(newNum))
		{
			alert("이미 추가되어 있는 전화번호입니다 (" + newNum + ")");
			return false
		}
		
		// 이상이 없을 경우 추가
		$('ul', '.rnumlist_body').append('<li><span class=\"label\"></span><span class=\"number\">'+ newNum +'</span><span class=\"name\">' + rName + '</span><button class=\"delete\" title=\"삭제\">삭제</button></li>');
		
		// 받는사람 전화번호 삭제버튼 클릭시 이벤트헨들러 연결
		$('button.delete', '.rnumlist_body ul li:last').click(function(){ 
			$(this).parent().remove();
			updateNumofPnumber();
		});
		// 받는사람 개별선택 이벤트헨들러 연결
		$('li:last', '.rnumlist_body ul').click(function (){
			$('span.label', $(this)).toggleClass("on");
		});
		

		updateNumofPnumber();
		
		return true;
		      
	}
	
	// 받는사람 직접추가
	function directAddNum() 
	{ 
				
			var new_num = $('#new_num').val();
			
			if(new_num == "")
			{ alert("전화번호를 입력하세요");
				return false;
			}

			addNum(new_num, " ");
			
			$('#new_num').focus().select();
			
			return false;
			
	}

	/************************************
	 			주소록창 
	 ************************************/
	
	// 선택된 주소록수 업데이트
	function updateNumofSaddr()
	{
		var r_num = $('.label.on', '.addrlist_body ul li').size();
	  	$('#selAddr_num').text( r_num );

	}
	
	// 받은사람목록에 추가된 주소록 검사&표시
	function addedAddrCheck()
	{
		var $listAll = $('li', '.addrlist_body ul');
		$listAll.each(function(idx){
			var Anum = $('.number',this).text();
			if(isExistNum(Anum))
			{
				$('.number',this).css('color','#dbdbdb');
				$('.name',this).css('color','#dbdbdb');
				$('.label',this).removeClass('on');
				
			}
			else
			{
				$('.number',this).css('color','#676767');
				$('.name',this).css('color','#676767');
			}				
		});
		updateNumofSaddr();
		
		return false;
	}
	
	// 주소록에 목록 추가
	addAddr = function(newNum, rGroup, rName) 
	{
		var illegal = false;
		// 전화번호 포멧검사
		if(!checkPhoneFormat(newNum)) {
			illegal = true;
		//	alert("ERROR:유효하지 않은 전화번호형식 (" + newNum + ")");
		//	return false;
		}
		
		// 이미 존재하는 번호인지 검사
		var pureNum = toOnlyNumber(newNum, "-", "");
		var isExist = false;
		var $listAll = $('li', '.addrlist_body ul');
		
		$listAll.each(function(idx) {
				var eNum = toOnlyNumber($('.number',this).text(), "-", "");
				if(pureNum == eNum)
				{
					//alert("ERROR:이미 추가되어 있는 전화번호 (" + newNum + ")");
					isExist = false;	// 주소록에서는 전화번호 중복 허용
				}
			});
		
		// 이상이 없을 경우 추가
		if(!isExist)
		{
			$('ul', '.addrlist_body').append('<li><span class=\"label\"></span><span class=\"group\">' + rGroup + '</span><span class=\"name\">' + rName + '</span><span class=\"number\">'+ newNum +'</span></li>');
			if(illegal) $('.number', '.addrlist_body ul li:last').css('text-decoration','line-through');
				
			
			// 주소록 개별선택 이벤트헨들러 등록
			$('li:last', '.addrlist_body ul').click(function (){
				$('span.label', $(this)).toggleClass("on");
				updateNumofSaddr();
			});
		}
			
		return true;
		      
	}
	
	// 그룹박스에 목록추가
	addGroup = function(gName)
	{
		$('ul', '.group_box').append('<li><span>' + gName + '</span></li>');
		
		// 그룹 개별선택 이벤트헨들러 추가
		$('li:last', '.group_box ul').click(function (){
			
			// 모든주소 체크해제
			$('span.label', '.addrlist_body ul li').removeClass("on");

			
			// 선택한 그룹을 갖는 주소만 보이게 하기
			var t = $('span', $(this)).text();
			
			if(t == '전체')
			{
				$('li', '.addrlist_body ul').show();
			}
			else
			{
				// 모든주소 숨기기
				$('li', '.addrlist_body ul').hide();
	
				
				// 선택된 그룹의 주소만 보이기
				var $listAll = $('li', '.addrlist_body ul');
				$listAll.each(function(idx) {
					var eName = $('.group', this).text();
					if( t == eName )
						$(this).show();
				});
			}
			
			// 선택한그룹명을 드롭박스에 보이게하기
			$('.selected_group_viewer').text(t);
			
			// 드롭박스사라지게 하기
			$('.group_box').removeClass('on');
			
			updateNumofSaddr();
			
		});
		
		return false;
	}

/* binding handlers to Events when DOM READY */
jQuery(function($) {
	
	//전송창에서 받는사람 목록을 가져옴
	var numList = opener.getNums();
	for(var i=0; i<numList.length; i++){
	    addNum(numList[i][0],numList[i][1]);   
	}
	
	
	
	/************************************
	 			받는사람창 
	 ************************************/
	
	// 받는사람 전화번호 직접추가 버튼 클릭시 
	$('#addNum').click(directAddNum);
	
	$('#new_num').keypress(function(e){ 
		  	if(e.keyCode == 13) { 
		  		directAddNum();
		  		return false;
		  	}
	});
	
	// 받는사람 선택전환
	$('#selRnum_toggle').click(function () { 
        $(this).toggleClass("on");
        $('span.label', '.rnumlist_body ul li').toggleClass("on");
        return false;
  	});
  
  // 받는사람 전체선택
	$('#sel_allNum').toggle(
		function () { 
        	$('#selRnum_toggle').addClass("on");
        	$('span.label', '.rnumlist_body ul li').addClass("on");
        	return false;
    	},
    	function () { 
        $('#selRnum_toggle').removeClass("on");
        $('span.label', '.rnumlist_body ul li').removeClass("on");
  	});

	// 선택된 받는사람 삭제
	$('#del_selNum').click(function () { 
		var $chkLi = $('span.label.on', '.rnumlist_body ul li').parent();
		$chkLi.remove();
		updateNumofPnumber();
		
		return false;
	});
	
	/************************************
	 			주소록창 
	 ************************************/
	
	// 주소록 선택전환
	$('#selAddr_toggle').click(function () { 
        $(this).toggleClass("on");
        $('span.label', '.addrlist_body ul li:visible').toggleClass("on");
        updateNumofSaddr();
        return false;
  });

  // 주소록 전체선택
	$('#sel_allAddr').toggle( function () { 
        $('#selAddr_toggle').addClass("on");
        $('span.label', '.addrlist_body ul li').addClass("on");
        updateNumofSaddr();
    }, function () { 
        $('#selAddr_toggle').removeClass("on");
        $('span.label', '.addrlist_body ul li').removeClass("on");
        updateNumofSaddr();
  	});	
	
	// 주소록 선택추가(받는사람목록으로추가)
	$('#add_selAddr').click(function () {
		
		var $listforAdd = $('.label.on', '.addrlist_body ul li').parent();
		
		$listforAdd.each(function(idx) {
				var new_num = $('.number', this).text();
				var new_name = $('.name', this).text();
				addNum(new_num, new_name);
		});
		
		return false;
		
	});
	
	$('#add_Addr').click(function () {
		
		var $listforAdd = $('.label.on', '.addrlist_body ul li').parent();
		
		$listforAdd.each(function(idx) {
				var new_num = $('.number', this).text();
				var new_name = $('.name', this).text();
				addNum(new_num, new_name);
		});
		
		return false;
	});
	
	$('#del_Addr').click(function () {
		$('#del_selNum').click();
		return false;
	});
	
	// 그룹박스 show/hide toggle
	$('#drop_groupBox').click( function () {
		$('.group_box').toggleClass('on');
		return false;
	});
	$('.selected_group_viewer').click( function () {
		$('.group_box').toggleClass('on');
		return false;
	});
	
		
	/************************************
	 			확인/취소
	 ************************************/
	$('button#btn_cancel').click( function(){window.close()});
    $('button#btn_submit').click( function(){
        var numList = new Array();
	    $('.rnumlist_body ul li').each( function(){
	        var list = new Array( $(this).find('span.number').text(), $(this).find('span.name').text());
	        numList.push(list);
	    });
        opener.setNums(numList);
        window.close();        
    });
});

}) (jQuery);
