<?php
class smsontextyleModel extends smsontextyle {

    /**
     * @brief 초기화
     **/
    function init() {
        
    }

    /**
    * @brief SMS회원정보 검색
    **/
    function getSmsontextyleSiteInfo() {
        
        $logged_info = Context::get('logged_info');
        $args->member_srl = $logged_info->member_srl;
        
        if(!$args->member_srl) return;
        
        $output = executeQuery('smsontextyle.getSmsonTextyleSiteInfo', $args);
        if(!$output->toBool() || !$output->data) return null;
        
        return $output->data;
        
    }
    
	/**
	 * @brief 포인트 업데이트
	 **/
	function updatePoint($point) {

        $logged_info = Context::get('logged_info');

        $obj->member_srl = $logged_info->member_srl;
		$obj->point = $point;

		$output = executeQuery('smsontextyle.updatePoint', $obj);
        if(!$output->toBool()) return false;

		$this->point = $point;
	}
	
	/**
	 * @brief 회신전화번호 변경
	 **/
	function updateCallbackNum($newNum) {

        $logged_info = Context::get('logged_info');

        $obj->member_srl = $logged_info->member_srl;
		$obj->cb_phone_num = $newNum;

		$output = executeQuery('smsontextyle.updateCallbackNum', $obj);
		debugPrint($output);
        if(!$output->toBool()) return false;
        
        return true;
	}
	

    /**
     * @brief 주소록 목록 가져오기
     **/
    function getAddrs($addr_group_srl = 0) {
        $logged_info = Context::get('logged_info');

        $args->addr_group_srl = $addr_group_srl;
        $args->member_srl = $logged_info->member_srl;

        // 기타 변수들 정리
        $args->page = Context::get('page');
        $args->sort_index = Context::get('sort_index');
        $args->list_count = Context::get('list_count');
        $output = executeQuery('smsontextyle.getAddrs', $args);
        return $output;
    }
	
    /**
     * @brief 특정 주소록 그룹 가져오기 
     **/
    function getAddrGroupInfo($addr_group_srl) {
        $logged_info = Context::get('logged_info');

        $args->member_srl = $logged_info->member_srl;
        $args->addr_group_srl = $addr_group_srl;

        $output = executeQuery('smsontextyle.getAddrGroup', $args);
        return $output->data;
    }
    
    /**
     * @brief 그룹 목록 가져오기
     **/
    function getAddrGroups() {
        $logged_info = Context::get('logged_info');
        $args->member_srl = $logged_info->member_srl;

        $output = executeQuery('smsontextyle.getAddrGroups', $args);
        $group_list = $output->data;
        
        if(!$group_list) return;

        if(!is_array($group_list)) $group_list = array($group_list);
        return $group_list;
    }

    /**
     * @brief 그룹 목록 가져오기
     **/
    function isAddedAddr($phone_num) {
        $logged_info = Context::get('logged_info');
        $args->member_srl = $logged_info->member_srl;
        $args->addr_phonenum = $phone_num;

        $output = executeQuery('smsontextyle.isAddedAddr', $args);
        $count = $output->data->count;
        
        if($count) return true;
        else return false;
    }    


    

}

?>