<?php

class smsontextyleController extends smsontextyle {

    /**
     * @brief 초기화
     **/
    function init() {
        
    }

    /**
     * @brief 로그인 처리
     **/
    function procSmsontextyleLogin($mode = '') {
        if(!Context::get('is_logged')) return new Object(-1, 'msg_not_logged');
        $logged_info = Context::get('logged_info');
        
        $site_info = Context::get('site_module_info');

		$user_id = Context::get('user_id');
		$user_pw = Context::get('password');
		$cb_num =  $this->parsePhonenum(Context::get('cb_num'));
		

		$target = 'user_id='.$this->sendEncode($user_id);
		$target.= '&user_pw='.$this->sendEncode($user_pw);
		$target.= '&mode='.$this->sendEncode('login');

		$result = $this->sendPerbiz($target);
		$returnVal = unserialize(trim($result));

		// 정상적인 경우
		if($returnVal['code'] == '777') {
			$obj->sms_srl           = getNextSequence();
			$obj->member_srl        = $logged_info->member_srl;
			$obj->site_srl          = $site_info->site_srl;
			$obj->cb_phone_num      = $cb_num;
			$obj->sms_id            = $user_id;
			$obj->authkey           = base64_decode($returnVal['auth_key']);
			$obj->user_phone_num    = $returnVal['phone'];
			
			$output = executeQuery("smsontextyle.insertSmsontextyleSiteInfo",$obj);
            if(!$output->toBool()) return new Object(-1, $output->message);

			// 잔여건수 싱크
			$this->auth_id = $obj->sms_id;
			$this->auth_key = $obj->authkey;
			$this->procSmsontextylePointSync();
			
			if($mode=='signup')
			    return new Object(0, 'msg_signup_result_success');
			else
			    return new Object(0, 'msg_login_result_success');
		}
		else
    		return new Object(-1, 'msg_login_result_'.$returnVal['code']);
    }

    
    /**
     * @brief 회원가입 처리
     **/
	function procSmsontextyleSignUp() {
	    
	    if(!Context::get('is_logged')) return new Object(-1, 'msg_not_logged');
		$obj = Context::getRequestVars();

		$site_domain= $this->sendEncode($obj->site_domain);
		$user_name  = $obj->user_name;
		$user_id	= $this->sendEncode($obj->user_id);
		$email		= $this->sendEncode($obj->email);
		$password	= $this->sendEncode($obj->password1);
		$memo	= $this->sendEncode($obj->memo);
		$remain_sms	= $this->sendEncode($obj->cb_num);
		$phone      = $this->sendEncode($obj->phone_num);

		$phoneVar   = $obj->phone1.'-'.$obj->phone2.'-'.$obj->phone3;


		$sendVar = '&user_name='.$user_name;
		$sendVar.= '&user_id='.$user_id;
		$sendVar.= '&email='.$email;
		$sendVar.= '&password='.$password;
		$sendVar.= '&memo='.$memo;
		$sendVar.= '&remain_sms='.$remain_sms;
		$sendVar.= '&phone='.$phone;
		$sendVar.= '&checkTime='.rand(0,mktime());

		$target = 'mode='.$this->sendEncode('userInsert').'&site='.$site_domain.$sendVar;
		$result = $this->sendPerbiz($target);
		$returnVal = unserialize($result);


		// 정상적인 경우
		if($returnVal['code'] == '7') {
    		
    		// 로그인 처리
    		Context::set('user_id',$obj->user_id);
    		Context::set('password',$obj->password1);
    		Context::set('cb_num',$obj->cb_num);
            return $this->procSmsontextyleLogin('signup');
            
		} 
		else {
			if($returnVal['code'] == '1') return new Object(-1, 'msg_signup_result_existID');
			else return new Object(-1, 'msg_signup_result_existEmail');
		}
	    
	}

    /**
     * @brief 회원가입시 중복ID 체크
     **/
	function procSmsontextyleCheckID() {
		$obj = Context::getRequestVars();

		$sendVar = '&user_id='.$this->sendEncode($obj->user_id);
		$sendVar.= '&checkTime='.rand(0,mktime());

		$target = 'mode='.$this->sendEncode('userId_check').$sendVar;
		$result = $this->sendPerbiz($target);

		$returnVal = unserialize($result);

		if($returnVal['code'] == '1') $this->add('usable', false);
        else $this->add('usable', true);
	}

    /**
     * @brief 문자 잔량 동기화
     **/
	function procSmsontextylePointSync() {

        $oSmsontextyleModel = &getModel('smsontextyle');
        $sms_siteInfo =$oSmsontextyleModel->getSmsontextyleSiteInfo();
		
		$target = 'site_id='.$this->sendEncode($sms_siteInfo->sms_id);
		$target.= '&authkey='.$this->sendEncode($sms_siteInfo->authkey);
		$target.= '&mode='.$this->sendEncode('sms_sync');
		$result = $this->sendPerbiz($target);
		$returnVal = unserialize(trim($result));

		if($returnVal['code'] == '210') {
			$oSmsontextyleModel->updatePoint($returnVal['remain_sms']);
			$this->add('point', $returnVal['remain_sms']);
		}

	}

    /**
     * @brief 회신전화번호 변경 처리
     **/
    function procSmsontextyleUpdateCallbackNum() {
        
        if(!Context::get('is_logged')) return new Object(-1, 'msg_not_logged');
        $oSmsontextyleModel = &getModel('smsontextyle');
        
        $new_num = Context::get('num');
        $new_num = $this->parsePhonenum($new_num);
        
        if($oSmsontextyleModel->updateCallbackNum($new_num)){
            $this->add('new_num', $new_num);
            $this->add('is_updated', true);
        }
        else
            $this->add('is_updated', false);
        
    }


    /**
     * @brief 트리거, 텍스타일메뉴 삽입
     **/
    function triggerGetTextyleCustomMenu(&$custom_menu) {
        // menu 5(설정) 메뉴에 추가
        $attache_menu5 = array(
            'dispSmsontextyleConfigTextyle' => 'SMS 연동 설정'
        );
        if(!$custom_menu->attached_menu[5]) $custom_menu->attached_menu[5] = array();
        $custom_menu->attached_menu[5] = array_merge($custom_menu->attached_menu[5], $attache_menu5);
    }
    
    
	/**
	 * @brief sms전송
	 **/
	function procSmsontextyleSendSMS() {
	    
	    $logged_info = Context::get('logged_info');
	    $site_module_info = Context::get('site_module_info');

	    $obj = Context::getRequestVars();
	    
		$target = 'mode='.$this->sendEncode('user_check');
		$target.= '&send_method='.$this->sendEncode('direct');//관리자직접전송시에

        //예약
		$target.= '&appoint='.$this->sendEncode($obj->appointment);
		if($obj->appointment=='yes') {
			$target.= '&app_time='.$this->sendEncode($obj->send_appointment_time);
		}
		$content = str_replace('&nbsp',' ',$obj->send_content);
		$content = strip_tags($content);

        //사용자 id, 인증키
        $oSmsontextyleModel = &getModel('smsontextyle');
        $sms_siteInfo =$oSmsontextyleModel->getSmsontextyleSiteInfo();
		
		$target.= '&site_id='.$this->sendEncode($sms_siteInfo->sms_id);
		$target.= '&site='.$this->sendEncode($site_module_info->domain);
		$target.= '&authkey='.$this->sendEncode($sms_siteInfo->authkey);
		$target.= '&rec_pcs='.$this->sendEncode($this->parsePhonenum($obj->rec_pcs));
		$target.= '&content='.$content;	    
	    
	    // 수신전화번호
	    $pcs_total = $obj->add_pcs_total;
		$flag = 0;
		
		$send_num_list = array('0');
		
		for($p = 1; $p <= $pcs_total; $p++) {
			$pcsvar = 'add_pcs_'.$p;
			if($obj->$pcsvar) {
				$target.= '&send_pcs[]='.$this->parsePhonenum($obj->$pcsvar);
				if(!( $oSmsontextyleModel->isAddedAddr($this->parsePhonenum($obj->$pcsvar))))
				    $send_num_list[] = $this->parsePhonenum($obj->$pcsvar);
				$flag++;
			}
		}

	    $result = $this->sendPerbiz($target);
		$returnVal = unserialize(trim($result));
        
        if($returnVal['code'] == '17')
		    $this->setMessage('msg_sendsms_result_success');
		else
	        $this->setMessage('msg_sendsms_result_failed');
	        
        $this->add('numlist',$send_num_list);
	    
	}    
    
	/**
	 * @brief 전화번호 parse
	 **/
	function parsePhonenum($num,$delimiter = '') {
		if(!$num) return false;

		$num= str_replace(array('\'', '"', ' ', '-', '.', ',', '/', ')'), '', $num);
		if($delimiter != '')
		    $num= preg_replace('/([0-9]{3})([0-9]{3,})([0-9]{4})/',"$1"+$delimiter+"$2"+$delimiter+"$3");
		return $num;
	}

    /**
     * @brief 주소록 추가
     **/
    function procSmsontextyleAddAddr() {
        // 로그인 정보 체크
        if(!Context::get('is_logged')) return new Object(-1, 'msg_not_logged');
        $logged_info = Context::get('logged_info');

        $addr_name = Context::get('addr_name');
        $addr_phonenum = $this->parsePhonenum(Context::get('addr_phonenum'));
        $addr_memo = Context::get('addr_memo');
        
        if(!$addr_name || !$addr_phonenum) return new Object(-1,'msg_invalid_request');

        // 변수 정리
        $args->addr_srl = getNextSequence();
        $args->list_order = $args->addr_srl * -1;
        $args->addr_group_srl = Context::get('addr_group_srl');
        $args->member_srl = $logged_info->member_srl;
        $args->addr_name = $addr_name;
        $args->addr_phonenum = $addr_phonenum;
        $args->addr_memo = $addr_memo;
        $output = executeQuery('smsontextyle.addAddr', $args);
        if(!$output->toBool()) return $output;
        
    }

    function procSmsontextyleAddAddrs() {
        
        $arg= Context::get('addedlist');
        $arg = explode('|@|',$arg);
        $addrlist;
        foreach($arg as $list) {
            $listarr = explode('|',$list);
            
            Context::set('addr_name', $listarr[2] );
            Context::set('addr_phonenum', $listarr[0] );
            Context::set('addr_memo', $listarr[3] );
            Context::set('addr_group_srl', $listarr[1]);
            $this->procSmsontextyleAddAddr();
        }

        $this->setMessage('success_saved');
        
        
    }

    /**
     * @brief 주소록 수정
     **/
    function procSmsontextyleUpdateAddr() {

        // 로그인 정보 체크
        if(!Context::get('is_logged')) return new Object(-1, 'msg_not_logged');
        $logged_info = Context::get('logged_info');

        $addr_srl = Context::get('addr_srl');
        $addr_name = Context::get('addr_name');
        $addr_phonenum = $this->parsePhonenum(Context::get('addr_phonenum'));
        $addr_memo = Context::get('addr_memo');
        
        
        if(!$addr_name || !$addr_phonenum) return new Object(-1,'msg_invalid_request');

        // 변수 정리
        $args->addr_srl = $addr_srl;
        $args->addr_group_srl = Context::get('addr_group_srl');
        $args->addr_name = $addr_name;
        $args->addr_phonenum = $addr_phonenum;
        $args->addr_memo = $addr_memo;
        $output = executeQuery('smsontextyle.updateAddr', $args);
        if(!$output->toBool()) {
            $this->add('updated', false);
            return $output;
        }

        $this->add('updated', true);
        $this->add('addr_srl', $addr_srl);
        $this->add('addr_name', $addr_name);
        $this->add('addr_phonenum', $addr_phonenum);
        $this->add('addr_memo', $addr_memo);
        
        $this->setMessage('success_registed');
    }    
    
    /**
     * @brief 주소록 삭제
     **/
    function procSmsontextyleDeleteAddr() {
        
        // 로그인 정보 체크
        if(!Context::get('is_logged')) return new Object(-1, 'msg_not_logged');
        $logged_info = Context::get('logged_info');
        $member_srl = $logged_info->member_srl;

        // 변수 체크
        $addr_srl_list = trim(Context::get('addr_srl_list'));

        if(!$addr_srl_list) return new Object(-1, 'msg_cart_is_null');

        $addr_srl_list = explode('|@|', $addr_srl_list);
        if(!count($addr_srl_list)) return new Object(-1, 'msg_cart_is_null');

        $addr_count = count($addr_srl_list);
        $target = array();
        for($i=0;$i<$addr_count;$i++) {
            $addr_srl = (int)trim($addr_srl_list[$i]);
            if(!$addr_srl) continue;
            $target[] = $addr_srl;
        }
        if(!count($target)) return new Object(-1,'msg_cart_is_null');

        // 삭제
        $args->addr_srls = implode(',',$target);
        
        
        
        $args->member_srl = $logged_info->member_srl;
        $output = executeQuery('smsontextyle.deleteAddr', $args);
        if(!$output->toBool()) return $output;

        $this->setMessage('success_deleted');
    }

    /**
     * @brief 등록된 주소록의 그룹 이동
     **/
    function procSmsontextyleMoveAddr() {

        // 로그인 정보 체크
        if(!Context::get('is_logged')) return new Object(-1, 'msg_not_logged');
        $logged_info = Context::get('logged_info');

        // 변수 체크
        $addr_srl_list = trim(Context::get('addr_srl_list'));
        if(!$addr_srl_list) return new Object(-1, 'msg_cart_is_null');

        $addr_srl_list = explode('|@|', $addr_srl_list);
        if(!count($addr_srl_list)) return new Object(-1, 'msg_cart_is_null');

        $addr_count = count($addr_srl_list);
        $target = array();
        for($i=0;$i<$addr_count;$i++) {
            $addr_srl = (int)trim($addr_srl_list[$i]);
            if(!$addr_srl) continue;
            $target[] = $addr_srl;
        }
        if(!count($target)) return new Object(-1,'msg_cart_is_null');

        // 변수 정리
        $args->addr_srls = implode(',',$target);
        $args->member_srl = $logged_info->member_srl;
        $args->addr_group_srl = Context::get('target_addr_group_srl');

        $output = executeQuery('smsontextyle.moveAddrbook', $args);
        if(!$output->toBool()) return $output;

        $this->setMessage('success_moved');
    }


    /**
     * @brief 주소록 그룹 추가
     **/
    function procSmsontextyleAddAddrGroup() {

        // 로그인 정보 체크
        if(!Context::get('is_logged')) return new Object(-1, 'msg_not_logged');
        $logged_info = Context::get('logged_info');

        // 변수 정리
        $args->addr_group_srl = trim(Context::get('target_addr_group_srl'));
        $args->member_srl = $logged_info->member_srl;
        $args->title = Context::get('title');
        if(!$args->title) return new Object(-1, 'msg_invalid_request');

        // addr_group_srl이 있으면 수정
        if($args->addr_group_srl) {
            $output = executeQuery('smsontextyle.renameAddrGroup', $args);
            $msg_code = 'success_updated';

        // 아니면 입력
        } else {
            $output = executeQuery('smsontextyle.addAddrGroup', $args);
            $msg_code = 'success_registed';
        }
        
        if(!$output->toBool()) return $output;

        $this->setMessage($msg_code);
    }

    /**
     * @brief 주소록 그룹 이름 변경
     **/
    function procSmsontextyleRenameAddrGroup() {
        // 로그인 정보 체크
        if(!Context::get('is_logged')) return new Object(-1, 'msg_not_logged');
        $logged_info = Context::get('logged_info');
        // 변수 정리
        $args->addr_group_srl= Context::get('addr_group_srl');
        $args->member_srl = $logged_info->member_srl;
        $args->title = Context::get('title');
        if(!$args->title) return new Object(-1, 'msg_invalid_request');

        $output = executeQuery('smsontextyle.renameAddrGroup', $args);
        if(!$output->toBool()) return $output;

        $this->setMessage('success_updated');
    }

    /**
     * @brief 주소록 그룹 삭제
     **/
    function procSmsontextyleDeleteAddrGroup() {
        // 로그인 정보 체크
        if(!Context::get('is_logged')) return new Object(-1, 'msg_not_logged');
        $logged_info = Context::get('logged_info');

        
        $oDB = &DB::getInstance();
        $oDB->begin();
        
        // 변수 정리
        $args->addr_group_srl = Context::get('addr_group_srl');
        $args->member_srl = $logged_info->member_srl;
        $args->new_addr_group_srl = 0;
        
        // 그룹 삭제전 해당주소록 그룹미지정 처리
        $output = executeQuery('smsontextyle.moveAddrGroup', $args);
        if(!$output->toBool()) {
            $oDB->rollback();
            return $output;
        }
        
        // 그룹 삭제
        $output = executeQuery('smsontextyle.deleteAddrGroup', $args);
        if(!$output->toBool()) {
            $oDB->rollback();
            return $output;
        }
        
        $oDB->commit();

        $this->setMessage('success_deleted');
    }
    
    
    
    

}

?>