<?php
class smsontextyle extends ModuleObject {
    
    var $perbiz_server = 'sms.perbiz.co.kr';
	var $perbiz_index  = '/requestServer/xe.php';
	var $auth_date;
	var $auth_id ;
	var $auth_key;
	var $point;
      
    var $action_forwards = array(
        array('smsontextyle', 'view', 'dispSmsontextyleConfigTextyle')
    );
    
    var $triggers = array(
        array('textyle.getTextyleCustomMenu', 'smsontextyle', 'controller', 'triggerGetTextyleCustomMenu', 'after')
    );

    function smsontextyle()
    {
        
    }
    
    
	/**
	 * @brief 퍼비즈 서버로 전송
	 * sendPerbizArray()의 코드로 대체 예정
	 **/
	function sendPerbiz($content) {
	    
		$fp = @fsockopen($this->perbiz_server, 80, $errno, $errstr, 30);
		if($fp) {
			@fputs($fp, "POST ".$this->perbiz_index." HTTP/1.0\r\n");
			@fputs($fp, "Host: ".$this->perbiz_server."\r\n");
			@fputs($fp, "User-Agent: PHP Script\r\n");
			@fputs($fp, "Content-Type: application/x-www-form-urlencoded\r\n");
			@fputs($fp, "Content-Length: ".strlen($content)."\r\n");
			@fputs($fp, "Connection: close\r\n\r\n");
			@fputs($fp, $content."\r\n\r\n");
			$flag = 0;
			$result = '';
			while(!feof($fp)) {
				$line = @fgets($fp, 128);
				if((strncasecmp($line, 'Content-Type:text/html', 10) == 0) || $flag == 1) {
					if($flag == 1) $result .= $line;
					$flag = 1;
				}
			}
			@fclose($fp);
		}
		$result = trim(str_replace("\r\n\r\n", '', $result));
		$result = str_replace("\r\n", '', $result);
		$result = str_replace(' ', '', $result);
		return $result;
	}
        

	/**
	 * @brief 서버간 통신시 인코딩
	 **/
	function sendEncode($val) {
		return base64_encode($val);
	}
        
        
        
    
    function moduleInstall() {
        $oModuleController = &getController('module');

        // aciton forward 일괄 추가
        foreach($this->action_forwards as $item) {
            $oModuleController->insertActionForward($item[0], $item[1], $item[2]);
        }
        // $this->triggers 트리거 일괄 추가
        foreach($this->triggers as $trigger) {
            $oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
        }
        return new Object();
    }

    function checkUpdate() {
        $oModuleModel = &getModel('module');

        // action forward 일괄 체크
        foreach($this->action_forwards as $item) {
            if(!$oModuleModel->getActionForward($item[2])) return true;
        }
        // $this->triggers 트리거 일괄 검사
        foreach($this->triggers as $trigger) {
            if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) return true;
        }

        return false;
    }

    function moduleUpdate() {
        $oModuleModel = &getModel('module');
        $oModuleController = &getController('module');

        // action forward 일괄 업데이트
        foreach($this->action_forwards as $item) {
            if(!$oModuleModel->getActionForward($item[2])) {
                $oModuleController->insertActionForward($item[0], $item[1], $item[2]);
            }
        }
        // $this->triggers 트리거 일괄 업데이트
        foreach($this->triggers as $trigger) {
            if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) {
                $oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
            }
        }
        return new Object(0, 'success_updated');
    }

}

?>