<?php
if(!defined('__ZBXE__') && !defined('__XE__'))
{
	exit();
}

/**
* @file	  adult_keyword.addon.php
* @author 퍼니엑스이 (contact@funnyxe.com)
* @brief  성인 검색어 차단
**/

// HTML이 아니면 실행 중지
if(Context::getResponseMethod()!='HTML')
{
	return;
}

// 로그인 정보를 구합니다
$logged_info = Context::get('logged_info');

// 관리자이면 실행 중지
if($logged_info->is_admin == 'Y')
{
	return;
}

// 가상 사이트 관리자면 실행 중지
if($logged_info->is_site_admin)
{
	return;
}

// 애드온 실행 시점이 after module proc일 때만 작동
if($called_position == 'after_module_proc')
{
	// 네이버 OpenAPI 등록키가 입력되지 않았으면 실행 중지
	$key = trim($addon_info->api_key);
	if(!$key) return;

	if($this->act == 'IS')
	{
		$query = Context::get('is_keyword');
	}
	else
	{
		if($addon_info->apply_board != 'Y') return;
		$query = Context::get('search_keyword');
	}

	if(!$query) return;

	// API 요청 URL
	define('ADULT_KEYWORD_ADDON_API_URL', 'http://openapi.naver.com/search?key=' . $key . '&query=' . urlencode($query). '&target=adult');

	// XmlParser 객체 생성
	$oXmlParser = new XmlParser();

	// CacheHandler 객체 생성
	$oCacheHandler = CacheHandler::getInstance('object');

	// Object 캐시를 지원한다면
	if($oCacheHandler->isSupport())
	{
		$key = 'adult_keyword:' .md5($query);
		// 캐시에서 가져온다
		$xml_doc = $oCacheHandler->get($key);
		// 캐시에 없다면
		if(!$xml_doc)
		{
			// API 요청을 보낸다
			$buff = FileHandler::getRemoteResource(ADULT_KEYWORD_ADDON_API_URL);
			// API 서버에서 응답을 했다면
			if($buff)
			{
				// Xml 파일을 해석한다
				$xml_doc = $oXmlParser->parse($buff);
			}
		}
	}
	// Object 캐시를 지원하지 않는다면
	else
	{
		$cache_file = sprintf('%sfiles/cache/addons/adult_keyword/%s.cache.php', _XE_PATH_,  md5($query));

		// 파일 캐시를 읽는다
		$cache = FileHandler::readFile($cache_file);

		// 캐시 파일이 있다면
		if($cache)
		{
			// 캐시 파일을 해석한다
			$buff = unserialize(str_replace('<?php exit(); ?>', '', $cache));
		}
		// 캐시 파일이 없다면
		else
		{
			// API 요청을 보낸다
			$buff = FileHandler::getRemoteResource(ADULT_KEYWORD_ADDON_API_URL);

			// Xml 파일을 해석한다
			$xml_doc = $oXmlParser->parse($buff);

			// 캐시 파일 내용
			$content = '<?php exit(); ?>' . serialize($xml_doc);

			FileHandler::writeFile($cache_file, $content);
		}
	}

	// xml parsing 결과가 없다면 오류가 있는 것으로 판단하고 실행 중지
	if(!$xml_doc)
	{
		return;
	}

	$is_adult = $xml_doc->result->item->adult->body;

	// 성인 검색어가 맞다면
	if($is_adult)
	{
		Context::loadLang(_XE_PATH_.'addons/adult_keyword/lang');
		Context::set('is_adult_keyword', TRUE);

		// 에러 표시
		$this->stop('msg_adult_keyword');
	}
}