<?php
    if(!defined("__ZBXE__")) exit();

    /**
    * @file   adult_keyword.addon.php
    * @author SMaker (dowon2308@paran.com)
    * @brief  성인 검색어 차단
    **/

    // HTML가 아니면 실행 중지
    if(Context::getResponseMethod()!='HTML') return;

    // 관리자이면 실행 중지
    $logged_info = Context::get('logged_info');
    if($logged_info->is_admin == 'Y') return;
    if($logged_info->is_site_admin) return;

    // 애드온 실행 시점이 after module proc일 때만 작동
    if($called_position == 'after_module_proc') {
        if($this->act == 'procKeywordstatisticsExecute') return;

        // 네이버 OpenAPI 등록키가 입력되지 않았으면 실행 중지
        $key = trim($addon_info->api_key);
        if(!$key) return;

        if($this->act == 'IS') {
            $query = Context::get('is_keyword');
        } else {
            if($addon_info->apply_board != 'Y') return;
            $query = Context::get('search_keyword');
        }

        if(!$query) return;

        $cache_path = sprintf('%sfiles/cache/addons/adult_keyword/%s/', _XE_PATH_,  base64_encode($query));
        $cache_file = $cache_path.'cache.php';
        $cache = FileHandler::readFile($cache_file);

        $oXmlParser = new XmlParser();

        // OpenAPI 요청
        if($cache) {
            $xml_doc = unserialize(str_replace('<?php exit(); ?>', '', $cache));
        } else {
            $url = sprintf('http://openapi.naver.com/search?key=%s&query=%s&target=adult',$key,urlencode($query));
            $buff = FileHandler::getRemoteResource($url);
            $xml_doc = $oXmlParser->parse($buff);

            // 에러가 있으면 캐시 파일을 기록하지 않도록 함
            if($xml_doc->error_code) return;

            $content = '<?php exit(); ?>'.serialize($xml_doc);

            FileHandler::writeFile($cache_file, $content);
        }

        // 만약 받아온 내용이 없다면 문제가 있는 것으로 간주하고 실행 중지
        if(!$buff) return;

        $is_adult = $xml_doc->result->item->adult->body;
        if($is_adult) {
            Context::loadLang(_XE_PATH_.'addons/adult_keyword/lang');
            Context::set('is_adult_keyword', true);

            // 에러 표시
            $this->stop('msg_adult_keyword');
        }
    } else {
        return;
    }
?>