<?php
    if(!defined("__ZBXE__")) exit();

    /**
    * @file adult_keyword.addon.php
    * @author SMaker (dowon2308@paran.com)
    * @brief 성인 검색어 차단
    **/

	// 통합 검색도 게시판 검색도 아니면 실행 중지
	if(Context::get('act') != 'IS' && !Context::get('search_keyword')) return;

	// 관리자이면 실행 중지
	$logged_info = Context::get('logged_info');
	if($logged_info->is_admin == 'Y') return;
	if($logged_info->is_site_admin) return;

	// 애드온 실행 시점이 아닌 경우 중지
	if(Context::getResponseMethod()!='HTML') return;
	if($called_position != 'after_module_proc') return;

	// 검색어가 없으면 실행 중지
	if(Context::get('act') == 'IS') $query = trim(Context::get('is_keyword'));
	else $query = trim(Context::get('search_keyword'));
	if(!$query) return;

	// 네이버 OpenAPI 등록키가 입력되지 않았으면 실행 중지
	$key = trim($addon_info->api_key);
	if(!$key) return;

	$url = 'http://openapi.naver.com/search?key='.$key.'&query='.urlencode($query).'&target=adult';
	$buff = FileHandler::getRemoteResource($url);

    $oXmlParser = new XmlParser();
    $xml_doc = $oXmlParser->parse($buff);

	$is_adult = $xml_doc->result->item->adult->body;
	if($is_adult) {
		Context::loadLang(_XE_PATH_.'addons/adult_keyword/lang');
		
		// message 모듈의 에러 표시
		$oMessageView = &getView('message');
		$oMessageView->setError(-1);
		$oMessageView->setMessage('msg_adult_keyword');
		$oMessageView->dispMessage();

		$this->setTemplatePath($oMessageView->getTemplatePath());
		$this->setTemplateFile($oMessageView->getTemplateFile());
	}
?>