<?php
    /**
     * @class  pointsendModel
     * @author SMaker (dowon2308@paran.com)
     * @brief pointsend 모듈의 Model class
     **/

    class pointsendModel extends pointsend {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 포인트 선물 모듈 설정 구함
         **/
        function getConfig($with_fee_but_group = true) {
            static $config = null;
            if(is_null($config)) {
                // pointsend module의 module_info의 값을 구함
                $oModuleModel = &getModel('module');
                $config = $oModuleModel->getModuleConfig('pointsend');
                $config->skin = !$config->skin?'default':$config->skin;
                $config->use_fee = $config->use_fee == 'Y'?'Y':'N';
                $config->fee = $config->fee <1?0:$config->fee;
                $config->fee = $config->fee >99?99:$config->fee;
                $config->fee_but_group = $config->fee_but_group?explode('|@|',$config->fee_but_group):array();
                $config->grants = $config->grants?explode('|@|',$config->grants):array();

                // 최고 관리자이거나 수수료 제외 그룹에 해당하면 수수료 기능 비활성화
                if($with_fee_but_group) {
                    $logged_info = Context::get('logged_info');
                    if($logged_info->is_admin == 'Y') $config->use_fee = 'N';
                    if(count($config->fee_but_group)) {
                        foreach($logged_info->group_list as $key => $val) {
                            if(in_array($val,$config->fee_but_group)) {
                                $config->use_fee = 'N';
                                break;
                            }
                        }
                    }
                }
            }
            return $config;
        }

		/**
		 * @brief 포인트 선물 권한 확인
		 */
		function isGranted() {
			$config = $this->getConfig();
			$logged_info = Context::get('logged_info');
			if(!$logged_info) return false;
			$granted = true;
			if($config->grants) {
				$granted = false;
				foreach($logged_info->group_list as $key => $val) {
					if(in_array($val,$config->grants)) {
						$granted = true;
						break;
					}
				}
			}
			if(!$granted) return false;
			return true;
		}

        function getLogInfoByLogSrl($log_srl) {
            $args->log_srl = $log_srl;
            $output = executeQuery('pointsend.getPointsendLogInfo',$args);
            return $output->data;
        }

        /**
         * @brief 포인트 선물 내역 목록
         **/
        function getLogList($obj) {
            $args->sort_index = $obj->sort_index?$obj->sort_index:'regdate';
            $args->list_count = $obj->list_count?$obj->list_count:20;
            $args->page_count = $obj->page_count?$obj->page_count:10;
            $args->page = $obj->page?$obj->page:1;
			return executeQuery('pointsend.getPointsendLogList',$args);
        }
    }
?>