<?php
    /**
     * @class  pointsendAdminController
     * @author SMaker (dowon2308@paran.com)
     * @brief  pointsend 모듈의 Admin Controller class
     **/

    class pointsendAdminController extends pointsend {

        /**
        * @brief 초기화
        **/
        function init() {
        }

        function procPointsendAdminInsertConfig() {
            $config = Context::getRequestVars();
            if(!$config->skin) $config->skin = 'default';
            if(!$config->use_fee) $config->use_fee = 'N';

            $oModuleController = &getController('module');
            $oModuleController->insertModuleConfig('pointsend', $config);

            $this->setMessage('success_saved');
        }

        /**
         * @brief 포인트 선물 취소 (취소라기 보다는.... 압수가 맞는건가;;)
         */
        function procPointsendAdminRollback() {
            $log_srl = (int)Context::get('log_srl');
            if(!$log_srl) return new Object(-1, 'msg_invalid_request');

            $oPointsendModel = &getModel('pointsend');
            $log_info = $oPointsendModel->getLogInfoByLogSrl($log_srl);

            $sender_srl = (int)$log_info->sender_srl;
            $receiver_srl = (int)$log_info->receiver_srl;

            if(!$sender_srl || !$receiver_srl) return new Object(-1, 'msg_invalid_request');

            $oMemberModel = &getModel('member');
            $config = $oPointsendModel->getConfig();

            $point = $log_info->point;
            $sender_point = $point;
            $receiver_point = $point;

            $sender_info = $oMemberModel->getMemberInfoByMemberSrl($sender_srl);
            $receiver_info = $oMemberModel->getMemberInfoByMemberSrl($receiver_srl);

            // 수수료에 따른 포인트 계산
            $fee_per = (int)$config->fee;
            $fee_apply_point = (int)$config->fee_apply_point;
            $fee = 0;
            if($config->use_fee == 'Y' && $fee_per && $point>=$fee_apply_point) $fee = $point * ($config->fee/100);

            $receiver_point -= $fee;

            $oPointController = &getController('point');
            $oPointController->setPoint($sender_srl, $sender_point, 'minus');
            $oPointController->setPoint($receiver_srl, $receiver_point, 'add');

            // 쪽지 보내기
            $title = Context::getLang('pointsendc_title');
            $content = sprintf(Context::getLang('pointsendc_content'), $sender_info->nick_name, $sender_info->user_id, $receiver_point);
            $content2 = sprintf(Context::getLang('pointsendc_content2'), $receiver_info->nick_name, $receiver_info->user_id, $sender_point);

            $oCommunicationController = &getController('communication');
            $oCommunicationController->sendMessage($sender_srl, $receiver_srl, $title, $content, false);
            $oCommunicationController->sendMessage($receiver_srl, $sender_srl, $title, $content2, false);

            $args->log_srl = $log_srl;
            executeQuery('pointsend.deletePointsendLog',$args);
        }
    }
?>
