<?php
    /**
     * @class  pointsendController
     * @author SMaker (dowon2308@paran.com)
     * @brief  pointsend 모듈의 Controller class
     **/

    class pointsendController extends pointsend {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 포인트 선물
         **/
		function procPointsend() {
			$oMemberModel = &getModel('member');
			$oPointModel = &getModel('point');
			$oPointController = &getController('point');
			$oPointsendModel = &getModel('pointsend');

			// 로그인 상태인지 확인
			$logged_info = Context::get('logged_info');
			if(!$logged_info) return new Object(-1, 'msg_need_login');

			// 입력 받은 데이터 검사
			$obj = Context::getRequestVars();
			$obj->send_point = (int)$obj->send_point;
			$obj->content = $logged_info->is_admin!='Y'?removeHackTag(trim($obj->content)):trim($obj->content); //< XSS 공격 방지

			$sender_srl = (int)$obj->sender_srl;
			$receiver_srl = (int)$obj->receiver_srl;
			$point = (int)$obj->send_point;
			$real_point = (int)$obj->send_point;
			unset($obj->sender_srl);
			unset($obj->receiver_srl);
			unset($oSender);
			unset($oReceiver);

			// 보내는 이와 받는 이가 없으면 에러
			if(!$sender_srl || !$receiver_srl) return new Object(-1, 'msg_invalid_request');

			// 보낼 포인트가 없거나(잘못되었거나) 0보다 작을 경우 에러
			if(!$obj->send_point || $obj->send_point<0) return new Object(-1, 'msg_invalid_send_point');

			// 로그인 한 회원과 보내는 이가 다르면 에러
			if($logged_info->member_srl != $sender_srl) return new Object(-1, 'msg_invalid_request');

			// 받는 이가 존재 하지 않으면 에러
			$oReceiver = $oMemberModel->getMemberInfoByMemberSrl($receiver_srl);
			if(!$oReceiver) return new Object(-1, 'msg_not_exists_receiver');

			$oSender->point = $oPointModel->getPoint($sender_srl);

			// 보내는 이의 포인트가 보낼 포인트보다 작으면 에러
			if($oSender->point<$point) return new Object(-1, 'msg_not_enough_send_point');

			// 설정을 구함
			$config = $oPointsendModel->getConfig();

			// 수수료에 따른 포인트 계산
			$fee_per = (int)$config->fee;
			$fee_apply_point = (int)$config->fee_apply_point;
			$fee = 0;
			if($config->use_fee == 'Y' && $fee_per && $point>=$fee_apply_point) $fee = $point * ($config->fee/100);

			// 포인트에 수수료 빼기
			$point -= $fee;

			// 보내는 이는 포인트 (-), 받는 이는 포인트 (+)
			$oSender->point -= $real_point;
			$oReceiver->point = $oPointModel->getPoint($receiver_srl) + $point;

			// 수수료 적용 시 포인트가 소수점이 될 수 있으므로 정수로 만듬
			$oSender->point = (int)$oSender->point;
			$oReceiver->point = (int)$oReceiver->point;

			// 포인트 선물
			$oPointController->setPoint($sender_srl, $oSender->point);
			$oPointController->setPoint($receiver_srl, $oReceiver->point);

			// 쪽지 보내기
			$title = sprintf(Context::getLang('pointsend_title'), $logged_info->nick_name);
			$content = sprintf(Context::getLang('pointsend_content'), $logged_info->nick_name, $logged_info->user_id, $point, $obj->content);
			$oCommunicationController = &getController('communication');
			$oCommunicationController->sendMessage($sender_srl, $receiver_srl, $title, $content, false);

			// 포인트 선물 내역 남기기
			$this->insertLog($sender_srl, $receiver_srl, $real_point, $obj->content);

			$this->setMessage('success_pointsend');
		}

		/**
		 * @brief 포인트 선물 내역 추가
		 */
		function insertLog($sender_srl, $receiver_srl, $point, $comment) {
			if(!$sender_srl || !$receiver_srl || !$point) return;

			$args->log_srl = getNextSequence();
			$args->sender_srl = $sender_srl;
			$args->receiver_srl = $receiver_srl;
			$args->point = $point;
			$args->comment = $comment;
			return executeQuery('pointsend.insertPointsendLog',$args);
		}
    }
?>
