<?php
    /**
     * @class  pointsendAdminView
     * @author SMaker (dowon2308@paran.com)
     * @brief  pointsend 모듈의 admin view 클래스
     **/

    class pointsendAdminView extends pointsend {

        /**
         * @brief 초기화
         **/
        function init() {
            // 템플릿 경로 지정 (pointsend의 경우 tpl에 관리자용 템플릿 모아놓음)
            $template_path = sprintf('%stpl/',$this->module_path);
            $this->setTemplatePath($template_path);

			// 관리자 페이지에서 공통으로 사용하는 js 파일 로드
			Context::addJsFile($this->module_path.'tpl/js/pointsend_admin.js');
        }

		function dispPointsendAdminIndex() {
            // 스킨 목록을 구해옴
            $oModuleModel = &getModel('module');
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);

			// 설정 구함
			$oPointSendModel = &getModel('pointsend');
			$config = $oPointSendModel->getConfig();
			Context::set('config', $config);

			// 생성된 그룹 목록 구함
			$oMemberModel = &getModel('member');
			$group_list = $oMemberModel->getGroups();
			Context::set('group_list', $group_list);

			// Javascript Filter 적용
			Context::addJsFilter($this->module_path.'tpl/filter/','insert_config.xml');

			// 템플릿 파일 지정
			$this->setTemplateFile('config');
		}

		function dispPointsendAdminLogList() {
			// 포인트 선물 내역 목록 구함
			$oPointsendModel = &getModel('pointsend');
			$output = $oPointsendModel->getLogList($args);
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('log_list', $output->data);
			Context::set('page_navigation', $output->page_navigation);

			// 템플릿 파일 지정
			$this->setTemplateFile('log_list');
		}
    }
?>
