<?php
    /**
     * @class  pointsendModel
     * @author SMaker (dowon2308@paran.com)
     * @brief pointsend 모듈의 Model class
     **/

    class pointsendModel extends pointsend {

        /**
         * @brief 초기화
		 * @brief init
         **/
        function init() {
        }

        /**
         * @brief 포인트 선물 모듈 설정
         **/
        function getConfig() {
            static $module_info = null;
            if(is_null($module_info)) {
                // pointsend module의 module_info의 값을 구함
                $oModuleModel = &getModel('module');
                $module_info = $oModuleModel->getModuleConfig('pointsend');
				$module_info->skin = !$module_info->skin?'default':$module_info->skin;
				if($module_info->use_fee != 'Y') $module_info->use_fee = 'N';
				$module_info->fee  =$module_info->fee <1?0:$module_info->fee;
				$module_info->fee = $module_info->fee >99?99:$module_info->fee;
				$module_info->fee_but_group = $module_info->fee_but_group?explode('|@|',$module_info->fee_but_group):array();
				$module_info->grants = $module_info->grants?explode('|@|',$module_info->grants):array();
            }
            return $module_info;
        }

		/**
		 * @brief 포인트 선물 권한 확인
		 */
		function isGranted() {
			$config = $this->getConfig();
			$logged_info = Context::get('logged_info');
			if(!$logged_info) return false;
			$granted = true;
			if($config->grants) {
				$granted = false;
				foreach($logged_info->group_list as $key => $val) {
					if(in_array($val,$config->grants)) {
						$granted = true;
						break;
					}
				}
			}
			if(!$granted) return false;
			return true;
		}

        /**
         * @brief 포인트 선물 내역 목록
         **/
        function getLogList() {
        }
    }
?>
