<?php
    /**
     * @class  pointsendController
     * @author SMaker (dowon2308@paran.com)
     * @brief  pointsend 모듈의 Controller class
     **/

    class pointsendController extends pointsend {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 포인트 선물
         **/
		function procPointsend() {
			// 입력 받은 데이터 검사
			$obj = Context::getRequestVars();
			$obj->send_point = (int)$obj->send_point;

			// 보내는 이와 받는 이가 없으면 에러
			if(!$obj->sender_srl || !$obj->receiver_srl) return new Object(-1, 'msg_invalid_request');

			// 보낼 포인트가 올바르지 않으면 에러
			if(!$obj->send_point || $obj->send_point<0) return new Object(-1, 'msg_invalid_send_point');

			// 로그인 한 회원과 보내는 이가 다르면 에러
			$logged_info = Context::get('logged_info');
			if($logged_info->member_srl != $obj->sender_srl) return new Object(-1, 'msg_invalid_request');

			// 받는 이가 존재 하지 않으면 에러
			$oMemberModel = &getModel('member');
			if(!$oMemberModel->getMemberInfoByMemberSrl($obj->receiver_srl)) return new Object(-1, 'msg_not_exists_receiver');

			$oPointModel = &getModel('point');
			$oPointController = &getController('point');

			$SenderPoint = $oPointModel->getPoint($obj->sender_srl);

			// 보내는 이의 포인트가 보낼 포인트보다 작으면 에러
			if($SenderPoint<$obj->send_point) return new Object(-1, 'msg_not_enough_send_point');

			// 보내는 이와 받는 이의 포인트 계산
			$send_point = $obj->send_point;
			$SenderPoint -= $obj->send_point;
			$ReceiverPoint = $oPointModel->getPoint($obj->receiver_srl) + $obj->send_point;

			// 설정을 구함
			$oPointsendModel = &getModel('pointsend');
			$config = $oPointsendModel->getConfig();

			// 수수료 적용
			if($config->use_fee == 'Y' && $config->fee) {
				$send_point *= $config->fee / 100;
				$SenderPoint -= $SenderPoint * ($config->fee / 100);
				$ReceiverPoint += $ReceiverPoint * ($config->fee / 100);
			}

			// 수수료 적용 시 포인트가 소수점이 될 경우를 대비해 정수로 만듬
			$SenderPoint = (int)$SenderPoint;
			$ReceiverPoint = (int)$ReceiverPoint;

			// 포인트 선물
			$oPointController->setPoint($obj->sender_srl, $SenderPoint);
			$oPointController->setPoint($obj->receiver_srl, $ReceiverPoint);

			// 쪽지 보내기
			$title = sprintf(Context::getLang('pointsend_title'), $logged_info->nick_name);
			$content = sprintf(Context::getLang('pointsend_content'), $logged_info->nick_name, $logged_info->user_id, $send_point);
			$oCommunicationController = &getController('communication');
			$oCommunicationController->sendMessage($obj->sender_srl, $obj->receiver_srl, $title, $content, false);

			// 포인트 선물 내역 남기기
			$this->insertLog($obj->sender_srl, $obj->receiver_srl, $send_point);

			$this->setMessage('success_pointsend');
		}

		/**
		 * @brief 포인트 선물 내역 추가
		 */
		function insertLog($sender_srl, $receiver_srl, $point) {
		}
    }
?>
