<?php
    /**
     * @class  pointsendView
     * @author SMaker (dowon2308@paran.com)
     * @brief  pointsend 모듈의 view 클래스
     **/

    class pointsendView extends pointsend {

        /**
         * @brief 초기화
         **/
        function init() {
			// 로그인 상태가 아니면 에러
			$logged_info = Context::get('logged_info');
			if(!$logged_info) $this->stop('msg_need_login');

			// 설정을 구해서 set
			$oPointsendModel = &getModel('pointsend');
			$config = $oPointsendModel->getConfig();
			if($logged_info->is_admin == 'Y' || in_array($logged_info->group_list, $config->fee_but_group)) $config->use_fee = 'N';

			// 권한 체크
			$grant->pointsend = true;
			if($config->grants) {
				$grant->pointsend = false;
				foreach($logged_info->group_list as $key => $val) {
					if(in_array($val,$config->grants)) {
						$grant->pointsend = true;
						break;
					}
				}
			}
			// 최고 관리자의 경우 무조건 권한 부여
			if($logged_info->is_admin == 'Y') $grant->pointsend = true;

			// 권한이 없으면 에러 출력
			if(!$grant->pointsend) $this->stop('msg_not_permitted_pointsend');

			Context::set('pointsend_config', $config);

            /**
             * 스킨 경로를 미리 template_path 라는 변수로 설정함
             * 스킨이 존재하지 않는다면 xe_default로 변경
             **/
            $template_path = sprintf('%sskins/%s/',$this->module_path, $config->skin);
            if(!is_dir($template_path)) {
                $config->skin = 'default';
                $template_path = sprintf('%sskins/%s/',$this->module_path, $config->skin);
            }
            $this->setTemplatePath($template_path);

			// pointsend module에서 공통으로 쓰이는 js 파일 로드
			Context::addJsFile($this->module_path.'tpl/js/pointsend.js');
        }

        /**
         * @brief 포인트 선물 화면 출력
         **/
        function dispPointsend() {
			// 받는이가 없으면 에러
			$member_srl = Context::get('receiver_srl');
			if(!$member_srl) return new Object(-1, 'msg_invalid_request');

			// 존재 하지 않는 회원이면 에러
			$oMemberModel = &getModel('member');
			$member_info = $oMemberModel->getMemberInfoByMemberSrl($member_srl);
			if(!$member_info) return new Object(-1, 'msg_not_exists_member');

			$logged_info = Context::get('logged_info');
			Context::set('logged_info', $logged_info);
			Context::set('member_info', $member_info);

			//현재 포인트
			$oPointModel = &getModel('point');
			$current_point = $oPointModel->getPoint($logged_info->member_srl);
			Context::set('current_point', $current_point);

			// Javascript Filter 적용
			Context::addJsFilter($this->module_path.'tpl/filter/','pointsend.xml');

			$this->setLayoutFile("popup_layout");
            $this->setTemplateFile('PointSend');
        }

        /**
         * @brief 회원 찾기 팝업
         **/
        function dispPointsendFindMember() {
            $this->setTemplateFile('FindMember');
        }
    }
?>
