<?php
    if(!defined("__ZBXE__")) exit();

    /**
     * @file bekmeProhibite.addon.php
     * @author Baik_Sungchan (baikstar@paran.com)
     * @brief 게시물과 댓글의 수정 삭제 금지 애드온
     **/

    if($called_position != 'before_module_proc' && $called_position != 'after_module_proc') return;
    if($this->module == 'admin' || $this->module != 'board' || $this->grant->is_admin) return;

	if(!$addon_info->permit_time)
		$addon_info->permit_time == '0';
		$permit_time = date('YmdHis', (mktime()-(intval($addon_info->permit_time) * 60)));  // 분단위

	Context::loadLang(_XE_PATH_.'addons/bekmeProhibite/lang');

    switch(Context::get('act')) {
        case 'dispBoardWrite' :
        case 'procBoardInsertDocument' :
			if($addon_info->content_modify != 'Y') return;
			$document_srl = Context::get('document_srl');
			if(!$document_srl) return;
		    $oDocumentModel = &getModel('document');
		    $oDocument = $oDocumentModel->getDocument($document_srl);
			if(!$oDocument->isExists()) return;
			elseif($permit_time && $oDocument->get('regdate') < $permit_time)
				$this->alertMessage(Context::getLang('content_modify_prohibite'));
			else return;
            if($called_position == 'after_module_proc') $this->act = Context::get('act');
            else $this->act = null;
			return;
        case 'dispBoardDelete' :
        case 'procBoardDeleteDocument' :
			if($addon_info->content_delete != 'Y') return;
			$document_srl = Context::get('document_srl');
			if(!$document_srl) return;
		    $oDocumentModel = &getModel('document');
		    $oDocument = $oDocumentModel->getDocument($document_srl);
			if(!$oDocument->isExists()) return;
			elseif($permit_time && $oDocument->get('regdate') < $permit_time)
				$this->alertMessage(Context::getLang('content_delete_prohibite'));
			else return;
            if($called_position == 'after_module_proc') $this->act = Context::get('act');
            else $this->act = null;
			return;
        case 'dispBoardModifyComment' :
        case 'procBoardInsertComment' :
			if($addon_info->reply_modify != 'Y') return;
			$comment_srl = Context::get('comment_srl');
			if(!$comment_srl) return;
		    $oCommentModel = &getModel('comment');
		    $oComment = $oCommentModel->getComment($comment_srl);
			if(!$oComment->isExists())
				return;
			elseif($permit_time && $oComment->get('regdate') < $permit_time)
				$this->alertMessage(Context::getLang('reply_modify_prohibite'));
			else return;
            if($called_position == 'after_module_proc') $this->act = Context::get('act');
            else $this->act = null;
			return;
        case 'dispBoardDeleteComment' :
        case 'procBoardDeleteComment' :
			if($addon_info->reply_delete != 'Y') return;
			$comment_srl = Context::get('comment_srl');
			if(!$comment_srl) return;
		    $oCommentModel = &getModel('comment');
		    $oComment = $oCommentModel->getComment($comment_srl);
			if(!$oComment->isExists())
				return;
			elseif($permit_time && $oComment->get('regdate') < $permit_time)
				$this->alertMessage(Context::getLang('reply_delete_prohibite'));
			else return;
            if($called_position == 'after_module_proc') $this->act = Context::get('act');
            else $this->act = null;
			return;
    }

?>
