<?php
    /**
     * @file  index.php
     * @author zero <zero@zeroboard.com>
     * @brief 시작 페이지
     *
     * zeroboard XE의 시작 페이지
     *
     * Request Argument에서 mid, act로 module 객체를 찾아서 생성하고 \n
     * 모듈 정보를 세팅함
     *
     * @mainpage 첫페이지
     * @section intro 소개
     * zeroboard XE 는 오픈 프로젝트로 개발되는 오픈 소스입니다.\n
     * 자세한 내용은 아래 링크를 참조하세요.
     * - 공식홈페이지        : http://www.zeroboard.com
     * - zbXE 포럼           : http://www.zeroboard.com/forum_main
     * - 이슈트래킹          : http://trac.zeroboard.com
     * - SVN Repository      : http://svn.zeroboard.com/zeroboard_xe/trunk
     * - document            : http://doc.zeroboard.com
     * - pdf 문서            : http://doc.zeroboard.com/zeroboard_xe.pdf
     * \n
     * "Zeroboard™ XE"는 자유 소프트웨어입니다. \n
     * 소프트웨어의 피양도자는 자유 소프트웨어 재단이 공표한 GNU 일반 공중 사용 허가서 2판 또는 \n
     * 그 이후 판을 임의로 선택해서, 그 규정에 따라 프로그램을 개작하거나 재배포할 수 있습니다. \n
     * \n
     * 이 프로그램은 유용하게 사용될 수 있으리라는 희망에서 배포되고 있지만, 특정한 목적에 맞는 적합성 \n
     * 여부나 판매용으로 사용할 수 있으리라는 묵시적인 보증을 포함한 어떠한 형태의 보증도 제공하지 않습니다. \n
     * 보다 자세한 사항에 대해서는 GNU 일반 공중 사용 허가서를 참고하시기 바랍니다. \n
     * \n
     * GNU 일반 공중 사용 허가서는 이 프로그램과 함께 제공됩니다. 만약, 이 문서가 누락되어 있다면 자유 소프트웨어\n
     * 재단으로 문의하시기 바랍니다. \n
     * (자유 소프트웨어 재단: Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA) 
     **/

    /**
     * @brief 기본적인 상수 선언,  웹에서 직접 호출되는 것을 막기 위해 체크하는 상수 선언
     **/
    define('__ZBXE__', true);

    /**
     * @brief 필요한 설정 파일들을 include
     **/
    require_once('./config/config.inc.php');

    /**
     * @brief Context 객체를 생성하여 초기화
     * 모든 Request Argument/ 환경변수등을 세팅
     **/
    $oContext = &Context::getInstance();
    $oContext->init();

		function iconv_to_euc_kr($get_data) {
		  $work_unit = 50;
		  $init_size = strlen($get_data);
		  $result_data = "";
		  $count = 0;

		  for($i = 0; $i < $init_size; $i++) {
		    $cur_char = substr($get_data,$i,1);
		    $t = ord($cur_char);
		    if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
		      $tn = 1;
		    } else if(194 <= $t && $t <= 223) {
		      $tn = 2;
		    } else if(224 <= $t && $t < 239) {
		      $tn = 3;
		    } else if(240 <= $t && $t <= 247) {
		      $tn = 4;
		    } else if(248 <= $t && $t <= 251) {
		      $tn = 5;
		    } else if($t == 252 || $t == 253) {
		      $tn = 6;
		    } else {
		      $tn = 1;
		    }

		    if($work_unit < $tn) {
		      break;
		    }

		    if($count + $tn > $work_unit) {
		      $temp_data = iconv("utf-8","euc-kr",$work_string);
		      $result_data .= $temp_data;
		      $work_string = "";
		      $i--;
		      $count = 0;

		    } else {
		      for($j = 0; $j < $tn; $j++) {
		        $work_string .= $cur_char;
		        $i++;
		        $count++;
		        $cur_char = substr($get_data,$i,1);
		      }
		      $i--;
		    }
		  }

		  if($work_string) {
		    $temp_data = iconv("utf-8","euc-kr",$work_string);
		    $result_data .= $temp_data;
		  }

		  return $result_data;
		}

		extract($_GET);
		extract($_POST);

		$oDocumentModel = &getModel('document');
		$oDocument = $oDocumentModel->getDocument(0);
		$oDocument->setDocument($document_srl);


		$base_path = "";
		$str_arr = explode("/", getURL());
		for($i=0; $i < count($str_arr) - 1; $i++) $base_path .= $str_arr[$i] . "/";
		$base_path = $base_path . "?mid=" . $mid . "&amp;document_srl=" . $document_srl;

		$title = iconv_to_euc_kr($oDocument->getTitleText());
		$author = iconv_to_euc_kr($oDocument->getNickName());
		$reg_date = $oDocument->getRegdate('Y.m.d H:i:s');
		$hits = $oDocument->get('readed_count');
		$board_url = $base_path;
		$hit_url = $board_url;

		$file_base = "http://" . $_SERVER[SERVER_NAME] . '/uccup/file.php?f=';
		$img_url = $file_base . $oDocument->getExtraValue(1) . ".jpg";
		$flv_url = $file_base . $oDocument->getExtraValue(1) . ".flv";

		header("Content-Type: text/xml; charset=euc-kr");
		echo("<?xml version=\"1.0\" encoding=\"euc-kr\"?>\n");
?>

<player-config>
  <title><![CDATA[<?=$title?>]]></title>
  <author><![CDATA[<?=$author?>]]></author>
  <reg_date><?=$reg_date?></reg_date>
  <hits><?=$hits?></hits>
  <img_url><?=$img_url?></img_url>
  <flv_url><?=$flv_url?></flv_url>
  <ad_url>http://uccup.kr/player/ad.swf</ad_url>
  <board_url><?=$board_url?></board_url>
  <hit_url><?=$board_url?></hit_url>
  <full_size>yes</full_size>
  <control_type>2</control_type>
  <able_embed>yes</able_embed>
  <able_ad>yes</able_ad>
	<autoplay>no</autoplay>
	<play_bt_alpha>50</play_bt_alpha>
</player-config>
