var $ = jQuery.noConflict();
var snmp_sheet = {
    interval : false,
    preview : false,
    colorset : 'white',
    group_name : new Array(),
    threshold : 0,
    timestamp : false,
    z_index : 1,
    unit : 'Bps',
    element : new Array(),
    open : function(element, group_name) {
    if(snmp_sheet.group_name[group_name]) return;
    snmp_sheet.group_name[group_name] = group_name;
    snmp_sheet.timestamp = new Date().getTime();

        $('img', element).animate({opacity: 0.2}, 'fast');
        $('.loading', element).fadeIn('Fast');

        var url = request_uri.setQuery('act','dispNmsGraph').
        setQuery('mid',current_mid).
        setQuery('graph','line').
        setQuery('group_name',group_name).
        setQuery('mode','normal').
        setQuery('skin',snmp_sheet.colorset).
        setQuery('unit',snmp_sheet.unit).
        setQuery('timestamp',snmp_sheet.timestamp);

        $('.snmp_sheet').append('<div class="graph graph_open" value="0">'+
                         '<div class="graph_option"><span class="close" title="'+group_name+'">&nbsp;</span></div>'+
                         '<div class="loading"></div>'+
                         '<img src='+url+' alt="graph" />'+
                         '</div>');

        $('.graph_open img').load(function() {
            if($(this).parent().attr('value')==1) return;
            else $(this).parent().attr('value',1);

            var graph_open = $(this).parent();
            $(graph_open).css({top:$(element).offset().top,left:$(element).offset().left,width:0});
            $(graph_open).draggable({
                start : function (event,ui) {
                    $(this).css('z-index',snmp_sheet.z_index);
                    snmp_sheet.z_index = snmp_sheet.z_index+1;
                }
            });

            $(graph_open).mouseenter(function() {
                var element_option = this;
                if(!element_option.N) {
                    element_option.N = true;
                    $('.graph_option', this).show('fast', function() { element_option.N = false; });
                }
            }).mouseleave(function() {
                $('.graph_option', this).hide('fast');
            });

            $('.loading', element).fadeOut('fast');
            $('img', element).animate({opacity: 1}, 'slow');

            var graph_close = $('.graph_option',graph_open);
            $('.close',graph_close).click(function () {
                var group_name = $(this).attr('title');
                var element = $(this).parent().parent();
                $(element).hide('slow', function() { $(element).remove(); });

                snmp_sheet.group_name[group_name] = false;
                event.stopPropagation();
            });

            $(this).css('display','block');
            $(this).parent().css('zIndex',snmp_sheet.z_index);
            snmp_sheet.z_index = snmp_sheet.z_index+1;

            if(($(element).offset().top-200) < $(window).scrollTop()) var top = $(window).scrollTop()+10;
            else var top = $(element).offset().top-200;

            $(this).parent().animate({
                top:top+'px',
                left:10+'px',
                width:700,
                opacity:1
            }, 500);
        });
    },
    customer : function() {
        var mode = false;
        var regdate = false;
        var reghour = false;
        var group_name = false;
        var colorset = false;
        var data = $('#fo_nms_customer').serializeArray();
        $.each(data, function(i, field){
            switch(field.name) {
                case 'mode': mode = field.value; break;
                case 'group_name': group_name = field.value; break;
                case 'colorset': colorset = field.value; break;
                case 'regdate': regdate = field.value; break;
                case 'reghour': reghour = field.value; break;
                default: break;
            }
        });
        if(regdate&&reghour) {
            regdate = regdate+reghour;
            regdate = regdate.replace(/-/g, '')+59;
        }

        // %가 넘어오면 문제가 생김
        if(snmp_sheet.unit == '%') snmp_sheet.unit = '%25';
        var url = request_uri.setQuery('act','dispNmsGraph').
        setQuery('mid',current_mid).
        setQuery('graph','line').
        setQuery('group_name',group_name).
        setQuery('mode',mode).
        setQuery('skin',colorset).
        setQuery('unit',snmp_sheet.unit).
        setQuery('date',regdate);

        $('.customer .graph').remove();
        $('.customer').append('<div class="graph normal"><p>'+url+'</p></div>');
        $('.graph').each(function() {
            if(snmp_sheet.abovethetop(this) ||  snmp_sheet.leftofbegin(this)) {
            } else if(!snmp_sheet.belowthefold(this) && !snmp_sheet.rightoffold(this)) snmp_sheet.graph(this);
        });
    },
    search : function() {
        var list_count = false;
        var regdate = false;
        var reghour = false;
        var data = $('#fo_nms_search').serializeArray();
        $.each(data, function(i, field){
            switch(field.name) {
                case 'list_count': list_count = field.value; break;
                case 'regdate': regdate = field.value; break;
                case 'reghour': reghour = field.value; break;
                default: break;
            }
        });

        if(regdate&&reghour) regdate = regdate+reghour;
        regdate = regdate.replace(/-/g, '');

        var url = current_url;
        if(list_count) url = url.setQuery('list_count',list_count);
        if(regdate) url = url.setQuery('regdate',regdate);

        location.href=url;
    },
    select : function() {
        var display = 0;
        var element = false;
        var value = false;
        $('.select').after('<div class="to_select"><span class="to_select_value">select</span><ul class="abc"></ul></div>');
        $('.select').each(function(index) {
            value = $('option:selected',this).text();
            element = $(this).next();
            $('.to_select_value',element).text(value);

            $('option',this).each(function(index) {
                $('ul', element).append('<li title="'+$(this).val()+'">'+$(this).text()+'</li>');
            });
        });

        $('.to_select span').click(function() {
            element = $(this).parent();
            if(($(this).offset().top+$('ul',element).height()+20) > ($(window).height()+$(window).scrollTop())) $('ul',element).css('top','-'+($('ul',element).height()-14)+'px');
            else $('ul',element).css('top','0px');
            $('ul',element).toggle('fast');
        });

        $('body').click(function(event) {
            if(event.target.className != 'to_select_value') $('.to_select ul').hide('fast');
        });

        $('.to_select ul li').mouseenter(function() {
        if(snmp_sheet.colorset == 'white') $(this).css('background','#eaeaea');
        else $(this).css('background','#151515');
        }).mouseleave(function() {
            $(this).css('background','transparent');
        });

        $('.to_select ul li').click(function(){
            element = $(this).parent().parent();
            $('span',element).text($(this).text());
            element = $(element).prev();
            $('option[value="'+$(this).attr('title')+'"]',element).attr('selected','selected');
        });
    },
    graph : function(element) {
        if(element.loaded) return;
        if($('img', element).is('img')) snmp_sheet.reGraph(element);
        else {
            var src = $('em', element).text();
            $('em', element).remove();
            $(element).append('<div class="loading"></div>');
            $('.loading', element).fadeIn('Fast');
            if($('a', element).is('a')) $('a', element).append('<img src='+src+' alt="graph" />');
            else $(element).append('<img src='+src+' alt="graph" />');

            $('img', element).load(function() {
                $('.loading', element).fadeOut('fast');
                $(this).fadeIn('slow');
            });
        }
        element.loaded = true;
    },
    reGraph : function(element) {
        if(element.loaded) return;
        snmp_sheet.timestamp = new Date().getTime();
        var src = $('img', element).attr('src');
        src = src.replace(/\&timestamp\=[0-9]+/g, '');
        $('img', element).animate({opacity: 0.2}, 'fast');
        $('.loading', element).fadeIn('Fast');
        $('img', element).attr('src', src+"&timestamp="+snmp_sheet.timestamp);

        $('img', element).load(function(event) {
            $('.loading', element).fadeOut('fast');
            $('img', element).animate({opacity: 1}, 'slow');

            event.stopPropagation();
        });

        element.loaded = true;
    },
    insertvalGraph : function() {
        $('.graph').each(function(index) {
            this.loaded = false;
            if(snmp_sheet.abovethetop(this) || snmp_sheet.leftofbegin(this)) {
            } else if(!snmp_sheet.belowthefold(this) && !snmp_sheet.rightoffold(this)) snmp_sheet.reGraph(this);
        });
    },
    clearGraph : function() {
        clearInterval(graphTime); //vTimer를 중지시킴
    },
    belowthefold : function(element) {
        var fold = $(window).height() + $(window).scrollTop();
        return fold <= $(element).offset().top - snmp_sheet.threshold;
    },
    rightoffold : function(element) {
        var fold = $(window).width() + $(window).scrollLeft();
        return fold <= $(element).offset().left - snmp_sheet.threshold;
    },
    abovethetop : function(element) {
        var fold = $(window).scrollTop();
        return fold >= $(element).offset().top + snmp_sheet.threshold + $(element).height();
    },
    leftofbegin : function(element) {
        var fold = $(window).scrollLeft();
        return fold >= $(element).offset().left + snmp_sheet.threshold + $(element).width();
    },
    // 스크립트 로드
    ready : function() {
        $('body').ready(function() {
            $('.graph').each(function() {
                if(snmp_sheet.abovethetop(this) ||  snmp_sheet.leftofbegin(this)) {
                } else if(!snmp_sheet.belowthefold(this) && !snmp_sheet.rightoffold(this)) snmp_sheet.graph(this);
            });

            $(window).bind('scroll', function(event) {
                $('.graph').each(function() {
                    if($(this).attr('value')!=1) {
                        if(snmp_sheet.abovethetop(this) || snmp_sheet.leftofbegin(this)) {
                        } else if(!snmp_sheet.belowthefold(this) && !snmp_sheet.rightoffold(this)) snmp_sheet.graph(this);
                    }
                });
            });

            if(snmp_sheet.preview == 'Y') {
                $('.graph').mouseenter(function() {
                    var element_option = this;
                    if(!element_option.N) {
                        element_option.N = true;
                        $('.graph_option', this).show('fast', function() { element_option.N = false; });
                    }
                }).mouseleave(function() {
                    $('.graph_option', this).hide('fast');
                });
            }

            $('.graph .graph_option .open').click(function () {
                var element = $(this).parent().parent();
                element.loaded = true;
                snmp_sheet.open(element, $(this).attr('title'));
            });

            if(snmp_sheet.interval) graphTime = setInterval(snmp_sheet.insertvalGraph, snmp_sheet.interval*1000);

            if($('.inputDate').attr('class')) $('.inputDate').datepicker();

            if($.browser.msie) {
                if($.browser.version > 9) {
                    if($('.select').is('select')) snmp_sheet.select();
                 }
            } else {
                    if($('.select').is('select')) snmp_sheet.select();
            }
        });
    }
};

//$.fn.extend(nms);
snmp_sheet.ready();