<?php
    /**
     * @class  nms
     * @author largeden (developer@nmsxe.com)
     * @brief  nmsXE Class
     **/

    class nms extends ModuleObject {
        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
            $oModuleController = &getController('module');

            $oModuleController->insertTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsHostList', 'before');
            $oModuleController->insertTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsServiceList', 'before');
            $oModuleController->insertTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsSettingWizard', 'after');
            $oModuleController->insertTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsSmtpConfig', 'after');
            $oModuleController->insertTrigger('nms.dispNmsHostInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after');
            $oModuleController->insertTrigger('nms.dispNmsSeverityList', 'nms', 'view', 'triggerDispNmsSeverityRestore', 'after');
            $oModuleController->insertTrigger('nms.deleteNmsHost', 'nms', 'controller', 'triggerDeleteNmsMib', 'after');
            $oModuleController->insertTrigger('nms.deleteNmsMib', 'nms', 'controller', 'triggerDeleteNmsSeverity', 'after');
            $oModuleController->insertTrigger('nms.dispNmsServiceInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after');
            $oModuleController->insertTrigger('nms.dispNmsServiceInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after');
            $oModuleController->insertTrigger('display', 'nms', 'view', 'triggerDispNmsMemberDisplay', 'before');
            $oModuleController->insertTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberBefore', 'before');
            $oModuleController->insertTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberAfter', 'after');
            $oModuleController->insertTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsTwitterConfig', 'after');
            $oModuleController->insertTrigger('nms.logNmsAct', 'nms', 'controller', 'triggerLogNmsAct', 'check');
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
            $oDB = &DB::getInstance();

            // 2009.11.10 : 각 테이블에 extra_vars 컬럼 추가 진행 업데이트
            $table_list = array(
                'nms',
                'nms_group',
                'nms_mib',
                'nms_snmp_log',
                'nms_syslog_log',
                'nms_snmptrap_log'
            );

            foreach($table_list as $key)
                if(!$oDB->isColumnExists($key, 'extra_vars')) return true;

            // 2009.11.11 : 불필요한 테이블 삭제
            if($oDB->isTableExists('nms_snmp_severity')) return true;

            // 2009.11.11 : nms_snmp_log mib컬럼 삭제
            if($oDB->isColumnExists('nms_snmp_log', 'mib')) return true;

            // 2009.11.19 : nms_severity type컬럼 Type 변경 (+2009.12.24 DB구조 변경으로 해당 내용 취소)

            // 2009.11.19 : nms_severity act컬럼 Type 변경 (+2009.12.24 DB구조 변경으로 해당 내용 취소)

            // 2009.11.24 : Severity act 정보로 보낼 메시지 형식을 등록할 트리거 추가 (+2010.01.08 변경으로 해당 내용 취소)

            // 2009.12.02 : 기본 설정 정보에 사용할 트리거 추가
            if(!$oModuleModel->getTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsSmtpConfig', 'after')) return true;

            // 2009.12.07 : Severity act 기본 설정을 Host 정보에서도 나오도록 트리거 추가
            if(!$oModuleModel->getTrigger('nms.dispNmsHostInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after')) return true;

            // 2009.12.21 : 기본 설정에 syslog, snmptrap의 고유번호를 부여시키기 (+2010.06.16 DB구조 변경으로 해당 내용 취소)

            // 2009.12.23 : nms_severity 테이블 구조를 변경
            if($oDB->isTableExists('nms_severity')) return true;

            // 2009.12.29 : Severity Level 설정을 개선시키기 위해 Severity Log 메뉴에 트리거 추가 (+2010.01.08 변경으로 해당 내용 취소)

            // 2009.12.30 : 기존 Severity Level 설정 화면의 트리거를 제거
            if($oModuleModel->getTrigger('nms.dispNmsInsertMib', 'nms', 'view', 'triggerDispNmsSeveritySetup', 'after')) return true;
            if($oModuleModel->getTrigger('nms.dispNmsSyslogList', 'nms', 'view', 'triggerDispNmsSeveritySetup', 'after')) return true;
            if($oModuleModel->getTrigger('nms.dispNmsSnmpTrapList', 'nms', 'view', 'triggerDispNmsSeveritySetup', 'after')) return true;

            // 2010.01.04 : Host가 삭제될때 Severity를 삭제하는 트리거 제거
            if($oModuleModel->getTrigger('nms.deleteNmsHost', 'nms', 'controller', 'triggerDeleteNmsSeverity', 'after')) return true;

            // 2010.01.08 : SYSLOG, SNMPTRAP의 act 이름을 변경 (+2010.06.16 트리거 변경으로 해당 내용 취소)

            // 2010.01.08 : MIB 등록화면에서의 트리거 제거
            if($oModuleModel->getTrigger('nms.dispNmsInsertMib', 'nms', 'view', 'triggerDispNmsMibInsert', 'before')) return true;

            // 2010.01.13 : Severity 오류가 복구 시 수행시킬 정보를 기록하기 위한 트리거 추가
            if(!$oModuleModel->getTrigger('nms.dispNmsSeverityList', 'nms', 'view', 'triggerDispNmsSeverityRestore', 'after')) return true;

            // 2010.01.13 : Syslog, SnmpTrap에 Severity 등록 트리거 추가 트리거 추가 (+2010.06.16 트리거 변경으로 해당 내용 취소)

            // 2010.01.13 : 불필요한 트리거 제거
            if($oModuleModel->getTrigger('nms.dispNmsHostInfo', 'nms', 'view', 'triggerDispNmsHostGraph', 'before')) return true;

            // 2010.01.27 : nms_snmptrap_log, nms_syslog_log의 일부 bigint 타입을 char 타입으로 변경
            $result = $oDB->_query(sprintf("show fields from %s%s", $oDB->prefix, 'nms_snmptrap_log'));
            if($oDB->isError()) return false;
            $output = $oDB->_fetch($result);
            foreach($output as $key => $val) {
                if(in_array($val->Field, array('trap','ip_port')))
                    if(preg_match("/bigint/", $val->Type)) return true;
            }

            $result = $oDB->_query(sprintf("show fields from %s%s", $oDB->prefix, 'nms_syslog_log'));
            if($oDB->isError()) return false;
            $output = $oDB->_fetch($result);
            foreach($output as $key => $val) {
                if(in_array($val->Field, array('priority','facility','severity','ip_port')))
                    if(preg_match("/bigint/", $val->Type)) return true;
            }

            // 2010.03.10 : nms_mib - group_name, description | nms_snmp_log - session 컬럼 추가
            if(!$oDB->isColumnExists('nms_mib', 'group_name')) return true;
            if(!$oDB->isColumnExists('nms_mib', 'description')) return true;
            if(!$oDB->isColumnExists('nms_snmp_log', 'session')) return true;

            // 2010.06.16 : 메인화면을 트리거로 출력하도록 변경
            if(!$oModuleModel->getTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsHostList', 'before')) return true;
            if(!$oModuleModel->getTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsServiceList', 'before')) return true;
            if(!$oModuleModel->getTrigger('nms.dispNmsServiceInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after')) return true;

            // 2010.09.12 : 설치 마법사 트리거 출력 추가
            if(!$oModuleModel->getTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsSettingWizard', 'after')) return true;
            if(!$oModuleModel->getTrigger('display', 'nms', 'view', 'triggerDispNmsMemberDisplay', 'before')) return true;

            if(!$oModuleModel->getTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberBefore', 'before')) return true;
            if(!$oModuleModel->getTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberAfter', 'after')) return true;

            if(!$oModuleModel->getTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsTwitterConfig', 'after')) return true;
            if(!$oModuleModel->getTrigger('nms.logNmsAct', 'nms', 'controller', 'triggerLogNmsAct', 'check')) return true;

            return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
            $oDB = &DB::getInstance();

            // 2009.11.10 : 각 테이블에 extra_vars 컬럼 추가 진행 업데이트
            $table_list = array(
                'nms',
                'nms_group',
                'nms_mib',
                'nms_snmp_log',
                'nms_syslog_log',
                'nms_snmptrap_log'
            );

            foreach($table_list as $key) {
                if(!$oDB->isColumnExists($key, 'extra_vars'))
                    $oDB->addColumn($key,'extra_vars', 'text');
            }

            // 2009.11.11 : 불필요한 테이블 삭제
            if($oDB->isTableExists('nms_snmp_severity'))
                $oDB->_query(sprintf("drop table %s%s", $oDB->prefix, $oDB->addQuotes('nms_snmp_severity')));

            // 2009.11.11 : nms_snmp_log mib컬럼 삭제
            if($oDB->isColumnExists('nms_snmp_log', 'mib'))
                $oDB->dropColumn('nms_snmp_log', 'mib');

            // 2009.11.19 : nms_severity type컬럼 Type 변경 (+2009.12.24 DB구조 변경으로 해당 내용 취소)

            // 2009.11.19 : nms_severity act컬럼 Type 변경 (+2009.12.24 DB구조 변경으로 해당 내용 취소)

            // 2009.11.24 : Severity act 정보로 보낼 메시지 형식을 등록할 트리거 추가 (+2010.01.08 변경으로 해당 내용 취소)

            // 2009.12.02 : 기본 설정 정보에 사용할 트리거 추가
            if(!$oModuleModel->getTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsSmtpConfig', 'after'))
                $oModuleController->insertTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsSmtpConfig', 'after');

            // 2009.12.07 : Serverity act 기본 설정을 Host 정보에서도 나오도록 트리거 추가
            if(!$oModuleModel->getTrigger('nms.dispNmsHostInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after'))
                $oModuleController->insertTrigger('nms.dispNmsHostInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after');

            // 2009.12.21 : 기본 설정에 syslog, snmptrap의 고유번호를 부여시키기 (+2010.06.16 DB구조 변경으로 해당 내용 취소)

            // 2009.12.23 : nms_severity 테이블 구조를 변경
            if($oDB->isTableExists('nms_severity'))
                $oDB->_query(sprintf("drop table %s%s", $oDB->prefix, $oDB->addQuotes('nms_severity')));

            // 2009.12.29 : Severity Level 설정을 개선시키기 위해 Severity Log 메뉴에 트리거 추가 (+2010.01.08 변경으로 해당 내용 취소)

            // 2009.12.30 : 기존 Severity Level 설정 화면의 트리거를 제거
            if($oModuleModel->getTrigger('nms.dispNmsInsertMib', 'nms', 'view', 'triggerDispNmsSeveritySetup', 'after'))
                $oModuleController->deleteTrigger('nms.dispNmsInsertMib', 'nms', 'view', 'triggerDispNmsSeveritySetup', 'after');
            if($oModuleModel->getTrigger('nms.dispNmsSyslogList', 'nms', 'view', 'triggerDispNmsSeveritySetup', 'after'))
                $oModuleController->deleteTrigger('nms.dispNmsSyslogList', 'nms', 'view', 'triggerDispNmsSeveritySetup', 'after');
            if($oModuleModel->getTrigger('nms.dispNmsSnmpTrapList', 'nms', 'view', 'triggerDispNmsSeveritySetup', 'after'))
                $oModuleController->deleteTrigger('nms.dispNmsSnmpTrapList', 'nms', 'view', 'triggerDispNmsSeveritySetup', 'after');

            // 2010.01.04 : Host가 삭제될때 Severity를 삭제하는 트리거 제거
            if($oModuleModel->getTrigger('nms.deleteNmsHost', 'nms', 'controller', 'triggerDeleteNmsSeverity', 'after'))
                $oModuleController->deleteTrigger('nms.deleteNmsHost', 'nms', 'controller', 'triggerDeleteNmsSeverity', 'after');

            // 2010.01.08 : SYSLOG, SNMPTRAP의 act 이름을 변경  (+2010.06.16 트리거 변경으로 해당 내용 취소)

            // 2010.01.08 : MIB 등록화면에서의 트리거 제거
            if($oModuleModel->getTrigger('nms.dispNmsInsertMib', 'nms', 'view', 'triggerDispNmsMibInsert', 'before'))
                $oModuleController->deleteTrigger('nms.dispNmsInsertMib', 'nms', 'view', 'triggerDispNmsMibInsert', 'before');

            // 2010.01.13 : Severity 오류가 복구 시 수행시킬 정보를 기록하기 위한 트리거 추가
            if(!$oModuleModel->getTrigger('nms.dispNmsSeverityList', 'nms', 'view', 'triggerDispNmsSeverityRestore', 'after'))
                $oModuleController->insertTrigger('nms.dispNmsSeverityList', 'nms', 'view', 'triggerDispNmsSeverityRestore', 'after');

            // 2010.01.13 : Syslog, SnmpTrap에 Severity 등록 트리거 추가 트리거 추가 (+2010.06.16 트리거 변경으로 해당 내용 취소)

            // 2010.01.13 : 불필요한 트리거 제거
            if($oModuleModel->getTrigger('nms.dispNmsHostInfo', 'nms', 'view', 'triggerDispNmsHostGraph', 'before'))
                $oModuleController->deleteTrigger('nms.dispNmsHostInfo', 'nms', 'view', 'triggerDispNmsHostGraph', 'before');

            // 2010.01.27 : nms_snmptrap_log, nms_syslog_log의 일부 bigint 타입을 char 타입으로 변경
            $result = $oDB->_query(sprintf("show fields from %s%s", $oDB->prefix, 'nms_snmptrap_log'));
            if($oDB->isError()) return false;
            $output = $oDB->_fetch($result);
            foreach($output as $key => $val) {
                if(in_array($val->Field, array('trap','ip_port'))) {
                    if(preg_match("/bigint/", $val->Type)) {
                        switch($val->Field) {
                            case 'trap': $val->number = 1; break;
                            case 'ip_port': $val->number = 5; break;
                        }

                        $oDB->_query(sprintf("alter table %s%s change %s %s %s(%s)",$oDB->prefix,
                        $oDB->addQuotes('nms_snmptrap_log'),$val->Field,$val->Field,'char',$val->number));
                    }
                }
            }

            $result = $oDB->_query(sprintf("show fields from %s%s", $oDB->prefix, 'nms_syslog_log'));
            if($oDB->isError()) return false;
            $output = $oDB->_fetch($result);
            foreach($output as $key => $val) {
                if(in_array($val->Field, array('priority','facility','severity','ip_port'))) {
                    if(preg_match("/bigint/", $val->Type)) {
                        switch($val->Field) {
                            case 'priority': $val->number = 3; break;
                            case 'facility': $val->number = 2; break;
                            case 'severity': $val->number = 1; break;
                            case 'ip_port': $val->number = 5; break;
                        }

                        $oDB->_query(sprintf("alter table %s%s change %s %s %s(%s)",$oDB->prefix,
                        $oDB->addQuotes('nms_syslog_log'),$val->Field,$val->Field,'char',$val->number));
                    }
                }
            }

            // 2010.03.10 : nms_mib - group_name, description | nms_snmp_log - session 컬럼 추가
            if(!$oDB->isColumnExists('nms_mib', 'group_name')) $oDB->addColumn('nms_mib', 'group_name', 'text');
            if(!$oDB->isColumnExists('nms_mib', 'description')) $oDB->addColumn('nms_mib', 'description', 'text');
            if(!$oDB->isColumnExists('nms_snmp_log', 'session')) $oDB->addColumn('nms_snmp_log', 'session', 'char', 1, '', true);

            // 2010.06.16 : 메인화면을 트리거로 출력하도록 변경
            if(!$oModuleModel->getTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsHostList', 'before'))
                $oModuleController->insertTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsHostList', 'before');
            if(!$oModuleModel->getTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsServiceList', 'before'))
                $oModuleController->insertTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsServiceList', 'before');
            if(!$oModuleModel->getTrigger('nms.dispNmsServiceInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after'))
                $oModuleController->insertTrigger('nms.dispNmsServiceInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after');

            // 2010.09.12 : 설치 마법사 트리거 출력 추가
            if(!$oModuleModel->getTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsSettingWizard', 'after'))
                $oModuleController->insertTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsSettingWizard', 'after');

            if(!$oModuleModel->getTrigger('display', 'nms', 'view', 'triggerDispNmsMemberDisplay', 'before'))
                $oModuleController->insertTrigger('display', 'nms', 'view', 'triggerDispNmsMemberDisplay', 'before');

            if(!$oModuleModel->getTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberBefore', 'before'))
                $oModuleController->insertTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberBefore', 'before');
            if(!$oModuleModel->getTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberAfter', 'after'))
                $oModuleController->insertTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberAfter', 'after');

            if(!$oModuleModel->getTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsTwitterConfig', 'after'))
                $oModuleController->insertTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsTwitterConfig', 'after');

            if(!$oModuleModel->getTrigger('nms.logNmsAct', 'nms', 'controller', 'triggerLogNmsAct', 'check'))
                $oModuleController->insertTrigger('nms.logNmsAct', 'nms', 'controller', 'triggerLogNmsAct', 'check');

            return new Object(0, 'success_updated');
        }

        /**
         * @brief 모듈 제거
         **/
        function moduleUninstall() {
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
            $oDB = &DB::getInstance();

            // Module Config Delete
            $args->module = 'nms';
            $output = executeQuery('module.deleteModuleConfig', $args);
            if(!$output->toBool()) {
                $oDB->rollback();
                return;
            }

            // Trigger Delete
            if($oModuleModel->getTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsHostList', 'before'))
                $oModuleController->deleteTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsHostList', 'before');
            if($oModuleModel->getTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsServiceList', 'before'))
                $oModuleController->deleteTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsServiceList', 'before');
            if($oModuleModel->getTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsSettingWizard', 'after'))
                $oModuleController->deleteTrigger('nms.dispNmsAdminIndex', 'nms', 'view', 'triggerDispNmsSettingWizard', 'after');
            if($oModuleModel->getTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsSmtpConfig', 'after'))
                $oModuleController->deleteTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsSmtpConfig', 'after');
            if($oModuleModel->getTrigger('nms.dispNmsHostInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after'))
                $oModuleController->deleteTrigger('nms.dispNmsHostInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after');
            if($oModuleModel->getTrigger('nms.dispNmsSeverityList', 'nms', 'view', 'triggerDispNmsSeverityRestore', 'after'))
                $oModuleController->deleteTrigger('nms.dispNmsSeverityList', 'nms', 'view', 'triggerDispNmsSeverityRestore', 'after');
            if($oModuleModel->getTrigger('nms.deleteNmsHost', 'nms', 'view', 'triggerDeleteNmsMib', 'after'))
                $oModuleController->deleteTrigger('nms.deleteNmsHost', 'nms', 'view', 'triggerDeleteNmsMib', 'after');
            if($oModuleModel->getTrigger('nms.deleteNmsMib', 'nms', 'view', 'triggerDeleteNmsSeverity', 'after'))
                $oModuleController->deleteTrigger('nms.deleteNmsMib', 'nms', 'view', 'triggerDeleteNmsSeverity', 'after');
            if($oModuleModel->getTrigger('nms.dispNmsServiceInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after'))
                $oModuleController->deleteTrigger('nms.dispNmsServiceInfo', 'nms', 'view', 'triggerDispNmsSeverityConfig', 'after');
            if(!$oModuleModel->getTrigger('display', 'nms', 'view', 'triggerDispNmsMemberDisplay', 'before'))
                $oModuleController->deleteTrigger('display', 'nms', 'view', 'triggerDispNmsMemberDisplay', 'before');
            if(!$oModuleModel->getTrigger('display', 'nms', 'view', 'triggerDispNmsMemberDisplay', 'before'))
                $oModuleController->deleteTrigger('display', 'nms', 'view', 'triggerDispNmsMemberDisplay', 'before');
            if(!$oModuleModel->getTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberBefore', 'before'))
                $oModuleController->deleteTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberBefore', 'before');
            if(!$oModuleModel->getTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberAfter', 'after'))
                $oModuleController->deleteTrigger('member.updateMember', 'nms', 'controller', 'triggerUpdateMemberAfter', 'after');
            if(!$oModuleModel->getTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsTwitterConfig', 'after'))
                $oModuleController->deleteTrigger('nms.dispNmsConfig', 'nms', 'view', 'triggerDispNmsTwitterConfig', 'after');
            if(!$oModuleModel->getTrigger('nms.logNmsAct', 'nms', 'controller', 'triggerLogNmsAct', 'check'))
                $oModuleController->deleteTrigger('nms.logNmsAct', 'nms', 'controller', 'triggerLogNmsAct', 'check');

            $output = executeQueryArray('nms.getNmsHost');
            if($output->toBool()) {
                foreach($output->data as $nms) $module_srl[] = $nms->module_srl;
                $module_srl = implode(',',$module_srl);

                $oDB->begin();
                $result = $oDB->_query(sprintf("delete from %s%s where module_srl in(%s)", $oDB->prefix, 'document_extra_vars', $module_srl));
                if($oDB->isError()) $oDB->rollback();
                $result = $oDB->_query(sprintf("delete from %s%s where module_srl in(%s)", $oDB->prefix, 'modules', $module_srl));
                if($oDB->isError()) $oDB->rollback();
            }

            // Table Delete
            $table_list = array(
                'nms_group',
                'nms_mib',
                'nms_severity_log',
                'nms_snmp_log',
                'nms_snmptrap_log',
                'nms_syslog_log',
                'nms'
            );

            foreach($table_list as $table_name) {
                if($oDB->isTableExists($table_name)) {
                    $oDB->begin();
                    $result = $oDB->_query(sprintf("drop table %s%s", $oDB->prefix, $table_name));
                    if($oDB->isError()) $oDB->rollback();
                }
            }

            // commit
            $oDB->commit();

            return new Object();
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
            // NMS Wizard, SMI, Snmpwalkoid 캐쉬 삭제
            FileHandler::removeFilesInDir('./files/cache/nms');
        }
    }

    require_once(_XE_PATH_.'modules/nms/nms.item.php');
?>