<?php
    /**
     * @class  nmsAPI
     * @author largeden (developer@nmsxe.com)
     * @brief  nmsXE API class
     **/

    class nmsAPI extends nms {

        /**
         * @brief Snmp 수집을 api로 처리
         **/
        function procNmsSnmp(&$oModule) {
             $oNmsController = &getController('nms');
             $oNmsController->_procNmsSnmp();
        }

        /**
         * @brief Syslog 수집을 api로 처리
         **/
        function procNmsSyslog(&$oModule) {
             $oNmsController = &getController('nms');
             $oNmsController->_procNmsSyslog();
        }

        /**
         * @brief SnmpTrap 수집을 api로 처리
         **/
        function procNmsSnmpTrap(&$oModule) {
             $oNmsController = &getController('nms');
             $oNmsController->_procNmsSnmpTrap();
        }

        /**
         * @brief SnmpTrap 수집을 api로 처리
         **/
        function procNmsCompress(&$oModule) {
            $oNmsModel = &getModel('nms');
            $oNmsController = &getController('nms');

            if(Context::get('group_srl')) $oNmsController->procNmsCompress(Context::get('group_srl'));
            else {
                $output = $oNmsModel->getNmsGroup();
                if($output) {
                    foreach($output as $group) {
                        if($group->cronstate=='Y') $group_info[] = $group;
                    }

                    $oModule->add('group_info',$group_info);
                }
            }
        }
    }
?>