<?php

    class nmsSocket {

        var $socketClass;
        var $socketType;
        var $socketTime;

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 소켓 실행 명령어 함수
         **/
        function procSocket() {

            $this->socketClass = $_SERVER["argv"][1];
            $this->socketType = $_SERVER["argv"][2];
            $this->socketTime = date("YmdHis");

            switch($this->socketClass) {
                case "cron":
                    if($this->socketType=="stop") $this->procSocketStop();
                    else $this->procCron();
                    break;
                case "syslog":
                    if($this->socketType=="start") $this->procSyslog();
                    elseif($this->socketType=="stop") $this->procSocketStop();
                    break;
                case "snmptrap":
                    if($this->socketType=="start") $this->procSnmpTrap();
                    elseif($this->socketType=="stop") $this->procSocketStop();
                    break;
                default: 
                    break;
            }

        }

        /**
         * @brief cron 실행 함수 (초 단위의 명령대로 반복 실행)
         **/
        function procCron() {
            if(!$this->socketType) return;
            $this->procCronStart();

            do
            {
                if(!$this->getCronStatus()) return;

                $this->proc_msg(date("s")."초에 기록됨 ".$this->socketType);
                
                $this->procCronCall($this->socketType);

                sleep($this->socketType);
            }
            while($this->getCronStatus());

            return false;
        }

        /**
         * @brief Syslog Listen
         **/
        function procSyslog() {
            if(!$this->socketType) return;
            $this->procSocketStart();
            set_time_limit(0);

            $socket = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
            socket_bind($socket, "0.0.0.0", 514) or die ($this->proc_msg("error UDP port(514)"));
            $this->proc_msg("start syslog");
            $this->procSyslogCall("[127.0.0.1:$port]<191>start syslog");
            
            do
            {
                $from = "";
                $port = 0;
                $buf = "";

                socket_recvfrom($socket, $buf, 65535, 0, $from, $port);
                $this->proc_msg("$from $buf");
                $this->procSyslogCall("[$from:$port]$buf");
            }
            while($this->getSocketStatus());

            socket_close($socket);

            return false;
        }

        /**
         * @brief Snmp Trap Listen
         **/
        function procSnmpTrap() {
            if(!$this->socketType) return;
            $this->procSocketStart();
            set_time_limit(0);

            $socket = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
            socket_bind($socket, "0.0.0.0", 162) or die ($this->proc_msg("error UDP port(162)"));
            $this->proc_msg("start snmp trap");
            $this->procSnmpTrapCall("[127.0.0.1:$port]<191>start snmp trap");

            do
            {
                $from = "";
                $port = 0;
                $buf = "";

                socket_recvfrom($socket, $buf, 65535, 0, $from, $port);
                $this->proc_msg("$from $buf");
                $this->procSnmpTrapCall("[$from:$port]$buf");
            }
            while($this->getSocketStatus());

            // 주 소켓을 닫는다
            socket_close($socket);

            return false;
        }

        /**
         * @brief 특정주기로 지정된 폴더안에 있는 파일을 검색하여 웹처리 시도
         **/
        function procCronCall($crontype) {
            if(!$crontype) return;

            $path = dirname(__FILE__)."/socket/crontab/".$crontype."/";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
            }

            $pathOpen = opendir($path);
            while($list = readdir($pathOpen)) {
                if($list != "." && $list != "..") {
                    $fp = @fopen($path.$list, "r");
                    $siteUrl = @fgets($fp);
                    $siteOpen = @fopen($siteUrl, 'r');
                    @fclose($fp);
                }
            }

            closedir($pathOpen);
        }

        /**
         * @brief Syslog로 요청이 들어오면 해당 경로의 파일안의 내용주소로 웹처리 시도
         **/
        function procSyslogCall($msg) {
            if(!$msg) return;
            $msg = urlencode($msg);

            $path = dirname(__FILE__)."/socket/crontab/syslog/syslog";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
            }
            
            $fp = @fopen($path, "r");
            $siteUrl = @fgets($fp);
            $siteOpen = fopen($siteUrl."&msg=".$msg, 'r');
            @fclose($fp);
        }

        /**
         * @brief Snmp Trap 요청이 들어오면 해당 경로의 파일안의 내용주소로 웹처리 시도
         **/
        function procSnmpTrapCall($msg) {
            if(!$msg) return;
            $msg = urlencode($msg);

            $path = dirname(__FILE__)."/socket/crontab/snmptrap/snmptrap";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
            }
            
            $fp = @fopen($path, "r");
            $siteUrl = @fgets($fp);
            $siteOpen = fopen($siteUrl."&msg=".$msg, 'r');
            @fclose($fp);
        }

        /**
         * @brief Cron 시작
         **/
        function procCronStart(){

            $path = dirname(__FILE__)."/socket/cron";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
            }

            $fp = fopen($path, "a");
            fwrite($fp, $this->socketTime.":1\n");
            fclose($fp);

            return false;
        }
        /**
         * @brief Cron을 초 단위로 반복할때마다 해당 파일내용 값을 검색
         **/
        function getCronStatus(){

			$path = dirname(__FILE__)."/socket/cron";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
            }

            $fp = @fopen($path, "r");
            while (!feof($fp)) {
              $crontime = explode(":",fgets($fp));
              $status[$crontime[0]] = $crontime[1];
            }
            @fclose($fp);

            return $status[$this->socketTime];
        }

        /**
         * @brief 소켓을 실행할 때 실행용 파일을 생성
         **/
        function procSocketStart(){

			$path = dirname(__FILE__)."/socket/";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
            }

            $fp = fopen($path.$this->socketClass, "w");
            fwrite($fp, true);
            fclose($fp);

            return false;
        }

        /**
         * @brief 생성된 소켓파일을 소켓수행 후 한번씩 체크
         **/
        function getSocketStatus(){

			$path = dirname(__FILE__)."/socket/";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
            }

            $fp = @fopen($path.$this->socketClass, "r");
            $status = @fgets($fp);
            @fclose($fp);

            return $status;
        }

        /**
         * @brief 실행된 소켓으로 Stop 메시지를 보내 While문을 종료 시킴
         **/
        function procSocketStop(){

			$path = dirname(__FILE__)."/socket/";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
            }

            $fp = fopen($path.$this->socketClass, "w");
            fwrite($fp, false);
            fclose($fp);

            if($this->socketClass=="syslog") {
                $socket=socket_create(AF_INET,SOCK_DGRAM,SOL_UDP);
                $ssock=socket_connect($socket,"127.0.0.1",514);
                socket_send($socket, "<191>stop syslog", strlen("<191>stop syslog"), 0);
                socket_close($socket);
            }elseif($this->socketClass=="snmptrap") {
                $socket=socket_create(AF_INET,SOCK_DGRAM,SOL_UDP);
                $ssock=socket_connect($socket,"127.0.0.1",162);
                socket_send($socket, "<191>stop snmp trap", strlen("<191>stop snmp trap"), 0);
                socket_close($socket);
            }

        }

        /**
         * @brief 모든 결과치를 Text 파일로 덤프를 실행함 (필요할 경우 주석제거)
         **/
        function proc_msg($msg){
			//$path = dirname(__FILE__)."/socket/temp.txt";
            //if(substr(php_uname(), 0, 7) == "Windows") {
            //    $path = ereg_replace("/","\\",$path);
            //}

            //$fp = fopen(dirname(__FILE__)."\\socket\\temp.txt", "a");
            //fwrite($fp, date("YmdHis")." $msg\n");
            //fclose($fp);

            return false;
        }

    }

    $nmsSocket = new nmsSocket();
    $nmsSocket->procSocket();

?>