<?php
    /**
     * @class  nmsAdminView
     * @author largeden (largeden@animeclub.net)
     * @brief  nmsXE 모듈의 admin view class
     **/

    class nmsAdminView extends nms {

        /**
         * @brief 초기화
         **/
        function init() {
            // module model 객체 생성
            $oModuleModel = &getModel("module");
            $oNmsModel = &getModel("nms");

            $module_srl = Context::get("module_srl");
            if(!$module_srl && $this->module_srl) {
                $module_srl = $this->module_srl;
                Context::set("module_srl", $module_srl);
            }

            // module_srl이 넘어오면 해당 모듈의 정보를 미리 구해 놓음
            if($module_srl) {
                $module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
                if(!$module_info) Context::set("module_srl","");
                else {
                    $host_info = $oNmsModel->getNmsHostInfo($module_srl);
                    if(!$host_info) return $this->stop("msg_invalid_request");
                    foreach($host_info as $key => $val) {
                        $module_info->{$key} = $val;
                    }
                    Context::set("module_info",$module_info);
                }
            }

            if($module_info && $module_info->module != "nms") return $this->stop("msg_invalid_request");

            $group_srl = Context::get("group_srl");
            if(!$group_srl && $this->group_srl) {
                $group_srl = $this->group_srl;
                Context::set("group_srl", $group_srl);
            }

            if($group_srl) {
                $group_info = $oNmsModel->getNmsGroupInfo($group_srl);
                if(!$group_info) Context::set("group_srl","");
                else Context::set("group_info",$group_info);
            }

            $oNms = $oModuleModel->getModuleConfig("nms", $args);
            $oNms->schedule = explode("|@|",$oNms->schedule);
            foreach($oNms->schedule as $key => $val) {
                $oNms->scheduleclass[$val] = $val;
            }
            unset($oNms->schedule);
            Context::set("schedule",$oNms->scheduleclass);

            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
        }

        function dispNmsAdminIndex() {
            $oNmsModel = &getModel("nms");

            // 등록된 nms 모듈을 불러와 세팅
            $args->sort_index = "module_srl";
            $args->page = Context::get("page");
            $args->list_count = 20;
            $args->page_count = 10;
            $output = $oNmsModel->getNmsHostList($args);
            if(!$output->toBool()) return $this->stop("msg_invalid_request");

            if($output->data) {
                foreach($output->data as $key => $attribute) {
                    $module_srl = $attribute->module_srl;
                    if(!$GLOBALS["XE_DOCUMENT_LIST"][$module_srl]) {
                        $oDocument = null;
                        $oDocument = new nmsItem();
                        $oDocument->setAttributeModuleSrl($attribute);

                        $GLOBALS["XE_DOCUMENT_LIST"][$module_srl] = $oDocument;
                    }
                }

                foreach($output->data as $key => $val) {
                    $output->data[$key] = $GLOBALS["XE_DOCUMENT_LIST"][$val->module_srl];
                }
            }

            // 템플릿에 쓰기 위해서 context::set
            Context::set("total_count", $output->total_count);
            Context::set("total_page", $output->total_page);
            Context::set("host_list", $output->data);
            Context::set("page", $output->page);
            Context::set("page_navigation", $output->page_navigation);

            // 템플릿 파일 지정
            $this->setTemplateFile("list");
        }

        function dispNmsAdminSetup() {
            $oModuleModel = &getModel("module");
            $oNms = $oModuleModel->getModuleConfig("nms", $args);

            Context::set("module_info", $oNms);

            $this->setTemplateFile("setup");
        }

        function dispNmsAdminHostInfo() {
            $this->dispNmsAdminInsertHost();
        }

        function dispNmsAdminInsertHost() {
            if(!in_array($this->module_info->module, array("admin","nms"))) {
                return $this->alertMessage("msg_invalid_request");
            }

            /* 스킨 목록 구하기  */
            $oModuleModel = &getModel("module");
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set("skin_list",$skin_list);

            if(!$this->group_srl) {
                $oNmsModel = &getModel("nms");
                $group_info = $oNmsModel->getNmsGroup();
                if(!$group_info->data) Context::set("group_srl","");
                else Context::set("group_info",$group_info->data);
            }

            // 추가 설정을 위한 트리거 호출 
            if(Context::get("module_srl")) {
                $output = ModuleHandler::triggerCall("nms.dispNmsHostInfo", "before", $befor_content);
                $output = ModuleHandler::triggerCall("nms.dispNmsHostInfo", "after", $after_content);
            }

            Context::set("befor_content", $befor_content);
            Context::set("after_content", $after_content);

            $this->setTemplateFile("host_insert");
        }

        function dispNmsAdminGroupList(){

            // 등록된 nms 모듈을 불러와 세팅
            $args->sort_index = "group_srl";
            $args->page = Context::get("page");
            $args->list_count = 20;
            $args->page_count = 10;
            $output = executeQueryArray("nms.getNmsGroupList", $args);

            // 템플릿에 쓰기 위해서 context::set
            Context::set("total_count", $output->total_count);
            Context::set("total_page", $output->total_page);
            Context::set("page", $output->page);
            Context::set("group_list", $output->data);
            Context::set("page_navigation", $output->page_navigation);

            // 템플릿 파일 지정
            $this->setTemplateFile("group_list");

        }

        function dispNmsAdminGroupInfo() {
            $this->dispNmsAdminInsertGroup();
        }

        function dispNmsAdminInsertGroup() {
            if(!in_array($this->module_info->module, array("admin","nms"))) {
                return $this->alertMessage("msg_invalid_request");
            }

            $this->setTemplateFile("group_insert");
        }

        function dispNmsAdminDeleteHost() {
            $this->setTemplateFile("host_delete");
        }

        function dispNmsAdminDeleteGroup() {
            $this->setTemplateFile("group_delete");
        }

        function dispNmsAdminMibList() {
            $oNmsModel = &getModel("nms");

            $args = Context::getRequestVars();

            // 등록된 nms 모듈을 불러와 세팅
            $args->sort_index = "mib_srl";
            $args->page = Context::get("page");
            $args->list_count = 20;
            $args->page_count = 10;

            $output = $oNmsModel->getNmsMibList($args);

            // 템플릿에 쓰기 위해서 context::set
            Context::set("total_count", $output->total_count);
            Context::set("total_page", $output->total_page);
            Context::set("page", $output->page);
            Context::set("mib_list", $output->data);
            Context::set("page_navigation", $output->page_navigation);

            $this->setTemplateFile("mib_list");
        }

        function dispNmsAdminMibInfo() {
            $this->dispNmsAdminInsertMib();
        }

		/** 
	     * @brief MIB 입력 정보는 트리거 함수를 받아서 처리하도록 함
		 **/
        function dispNmsAdminInsertMib() {
            // content는 다른 모듈에서 call by reference로 받아오기에 미리 변수 선언만 해 놓음
            $content = "";

            // 추가 설정을 위한 트리거 호출 
            $output = ModuleHandler::triggerCall("nms.dispNmsInsertMib", "before", $content);
            if(Context::get("mib_srl")) {
                $output = ModuleHandler::triggerCall("nms.dispNmsInsertMib", "after", $content);
            }

            Context::set("setup_content", $content);

            // 템플릿 파일 지정
            $this->setTemplateFile("mib_insert");
        }

        function dispNmsAdminDeleteMib() {
            $oNmsModel = &getModel("nms");
            
            $args = Context::getRequestVars();

            $output = $oNmsModel->getNmsMibInfo($args);
            if(!$output->toBool()) return $this->stop("msg_invalid_request");

            // 템플릿에 쓰기 위해서 context::set
            Context::set("mib_info", $output->data);

            $this->setTemplateFile("mib_delete");
        }

        function dispNmsAdminSyslogList() {
            $oNmsModel = &getModel("nms");

            $args = Context::getRequestVars();

            // 등록된 nms 모듈을 불러와 세팅
            $args->sort_index = "syslog_srl";
            $args->page = Context::get("page");
            $args->list_count = 20;
            $args->page_count = 10;

            $output = $oNmsModel->getNmsSyslogList($args);

            // 템플릿에 쓰기 위해서 context::set
            Context::set("total_count", $output->total_count);
            Context::set("total_page", $output->total_page);
            Context::set("page", $output->page);
            Context::set("syslog_info", $output->data);
            Context::set("page_navigation", $output->page_navigation);

            // 추가 설정을 위한 트리거 호출 
            $output = ModuleHandler::triggerCall("nms.dispNmsSyslogList", "before", $befor_content);
            $output = ModuleHandler::triggerCall("nms.dispNmsSyslogList", "after", $after_content);

            Context::set("befor_content", $befor_content);
            Context::set("after_content", $after_content);

            $this->setTemplateFile("syslog_list");
        }

        function dispNmsAdminSnmpTrapList() {
            $oNmsModel = &getModel("nms");

            $args = Context::getRequestVars();

            // 등록된 nms 모듈을 불러와 세팅
            $args->sort_index = "snmptrap_srl";
            $args->page = Context::get("page");
            $args->list_count = 20;
            $args->page_count = 10;

            $output = $oNmsModel->getNmsSnmpTrapList($args);

            // 템플릿에 쓰기 위해서 context::set
            Context::set("total_count", $output->total_count);
            Context::set("total_page", $output->total_page);
            Context::set("page", $output->page);
            Context::set("snmptrap_info", $output->data);
            Context::set("page_navigation", $output->page_navigation);

            // 추가 설정을 위한 트리거 호출 
            $output = ModuleHandler::triggerCall("nms.dispNmsSyslogList", "before", $befor_content);
            $output = ModuleHandler::triggerCall("nms.dispNmsSyslogList", "after", $after_content);

            Context::set("befor_content", $befor_content);
            Context::set("after_content", $after_content);

            $this->setTemplateFile("snmptrap_list");
        }

        function dispNmsAdminPageIndex() {
            $this->setTemplateFile("adminpage");
        }

        function dispNmsAdminMigrationIndex() {
            $this->setTemplateFile("migration");
        }

        /**
         * @brief 권한 목록 출력
         **/
        function dispNmsAdminGrantInfo() {

            $args = Context::getRequestVars();

            // 공통 모듈 권한 설정 페이지 호출
            $oModuleAdminModel = &getAdminModel("module");
            $grant_content = $oModuleAdminModel->getModuleGrantHTML($args->module_srl, $this->xml_info->grant);
            Context::set("grant_content", $grant_content);

            $this->setTemplateFile("grant_list");
        }

        /**
         * @brief 스킨 목록 출력
         **/
        function dispNmsAdminSkinInfo() {

            $args = Context::getRequestVars();

            // 공통 모듈 스킨 설정 페이지 호출
            $oModuleAdminModel = &getAdminModel("module");
            $skin_content = $oModuleAdminModel->getModuleSkinHTML($args->module_srl);
            Context::set("skin_content", $skin_content);

            $this->setTemplateFile("skin_info");
        }

    }
?>
