<?php
    /**
     * @class  nmsModel
     * @author largeden (webmaster@animeclub.net)
     * @brief  nmsXE 모듈의 Model class
     **/

    class nmsModel extends nms {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 모듈과 등록되는 Host Ip에 대한 정보를 리스트 출력
         **/
        function getNmsHostList($args) {
            $output = executeQuery("nms.getNmsHostList", $args);
            if(!$output->toBool()) return $output;

            return $output;
        }

        /**
         * @brief 모듈번호로 Host 정보를 출력
         **/
        function getNmsHostInfo($module_srl = "") {
            $args->module_srl = $module_srl;
            $output = executeQuery("nms.getNmsHostInfo", $args);
            if(!$output->toBool()) return $output;

            return $output->data;
        }

        /**
         * @brief 그룹 번호로 그룹 정보를 출력
         **/
        function getNmsGroupInfo($group_srl = "") {
            $args->group_srl = $group_srl;
            $output = executeQuery("nms.getNmsGroupInfo", $args);
            if(!$output->toBool()) return $output;

            return $output->data;
        }
        
        /**
         * @brief 그룹번호에 해당하는 그룹아이디를 출력
         **/
        function getNmsGroupSrlByGid($group_srl = "") {
            $args->group_srl = $group_srl;
            $output = executeQuery("nms.getNmsGroupInfo", $args);
            if(!$output->toBool()) return $output;

            return $output->data;
        }

        /**
         * @brief 그룹 정보의 gid를 HOST 등록 과정에서 출력
         **/
        function getNmsGroup() {
            $output = executeQuery("nms.getNmsGroupInfo", $args);
            if(!$output->toBool()) return $output;
            if(!$output->data) return;
            if(!is_array($output->data)) $output->data = array($output->data);

            return $output;

        }

        /**
         * @brief MIB 정보를 출력
         **/
        function getNmsMibList($args) {
            $output = executeQuery("nms.getNmsMibList", $args);
            if(!$output->toBool()) return $output;
            if(!$output->data) return;
            if(!is_array($output->data)) $output->data = array($output->data);

            return $output;
        }

        /**
         * @brief MIB 번호 모듈번호로 MIB 정보를 출력
         **/
        function getNmsMibInfo($args) {
            $output = executeQuery("nms.getNmsMibInfo", $args);
            if(!$output->toBool()) return $output;

            return $output;
        }

        /**
         * @brief Syslog List 출력
         **/
        function getNmsSyslogList($args) {
            $output = executeQuery("nms.getNmsSyslogList", $args);
            if(!$output->toBool()) return $output;

            return $output;
        }

        /**
         * @brief Snmp Trap List 출력
         **/
        function getNmsSnmpTrapList($args) {
            $output = executeQuery("nms.getNmsSnmpTrapList", $args);
            if(!$output->toBool()) return $output;
    
            return $output;
        }

        /**
         * @brief Host안에 등록된 MIB의 정보를 출력
         **/
        function getNmsHostByMib($args = "") {
            $output = $this->getNmsMibInfo($args);
            if(!$output->toBool()) return $output;

            if(!is_array($output->data)) $output->data = array($output->data);

            return $output;
        }

        /**
         * @brief SNMP로 수집된 내용을 출력
         **/
        function getNmsSnmpLog($args) {
            $output = executeQuery("nms.getNmsSnmpLog", $args);

            if(!$output->toBool()) return $output;

            if(!is_array($output->data)) $output->data = array($output->data);

            return $output;
        }

        /**
         * @brief MIB의 ID인 mmid 이름으로 SNMP의 정보를 출력
         **/
        function getNmsMmidSnmp($mmid = "", $list_count = "") {
            $args->mmid = $mmid;
            $oMib = $this->getNmsMibInfo($args);
            $args->mib_srl = $oMib->data->mib_srl;

            $args->sort_index = "snmp_srl";
            $args->page = Context::get("page");
            $args->list_count = $list_count;
            $args->page_count = 10;

            $output = $this->getNmsSnmpLog($args);

            return $output->data;
        }

        /**
         * @brief 모듈에 해당하는 정보를 MIB 정보까지 출력
         **/
        function getNmsModuleInfo($args) {
            $output = executeQuery("nms.getNmsModuleInfo", $args);
            if(!$output->toBool()) return $output;

            $oNms = $output->data;

            $output = $this->getNmsMibList($args);
            if($output->data) {
                foreach($output->data as $key => $attribute) {
                    $mib_srl = $attribute->mib_srl;
                    if(!$GLOBALS["XE_DOCUMENT_LIST"][$mib_srl]) {
                        $oModule = null;
                        $oModule = new nmsItem();
                        $oModule->setAttributeModuleSrl($attribute);

                        $GLOBALS["XE_DOCUMENT_LIST"][$mib_srl] = $oModule;
                    }
                }

                foreach($output->data as $key => $val) {
                    $oMib[$key] = $GLOBALS["XE_DOCUMENT_LIST"][$val->mib_srl];
                }
            }
            $oNms->oMib = $oMib;

            return $oNms;
        }

        /**
         * @brief 수집된 SNMP LOG를 분석하여 통계로 만듬
         **/
        function getNmsSnmpSummary($type="",$mib_srl="",$date="") {
            if(!$type || !$mib_srl) return;

            switch($type)
            {
                case "5minutely":
                    $query = "getNmsSnmp5minutely";
                    $yesterday = date("Ymd",strtotime("-1 day",mktime(0,0,0,date("m"),date("d"),date("Y"))));
                break;
                case "hourly": 
                    $query = "getNmsSnmpHourly";
                    $yesterday = date("Ymd",strtotime("-1 day",mktime(0,0,0,date("m"),date("d"),date("Y"))));
                break;
                case "daily": $query = "getNmsSnmpDaily"; $date = substr($date,0,6);
                break;
                case "weekly": $query = "getNmsSnmpWeekly"; $date = substr($date,0,6);
                break;
                case "monthly": $query = "getNmsSnmpMonthly"; $date = substr($date,0,4);
                break;
                case "yearly": $query = "getNmsSnmpYearly"; $date = substr($date,0,4);
                break;
                
            }

            $args->mib_srl = $mib_srl;

            if($date) $args->regdate = $date;
            elseif(!$date||$yesterday) $args->yesterday = $yesterday;
            else $args->regdate = date("Ymd");

            $output = executeQuery("nms.".$query, $args);
            if(!$output->toBool()) return $output;

            if(!is_array($output->data)) $output->data = array($output->data);

            return $output->data;
        }

        /**
         * @brief 수집된 SNMP LOG를 분석 조건 중 최고 값과 최소 값을 출력
         **/
        function getNmsSnmpMax($type="",$mib_srl="",$date="") {
            if(!$type || !$mib_srl) return;

            switch($type)
            {
                case "5minutely":
                    $query = "getNmsSnmp5minutelyMax";
                    $yesterday = date("Ymd",strtotime("-1 day",mktime(0,0,0,date("m"),date("d"),date("Y"))));
                break;
                case "hourly": 
                    $query = "getNmsSnmpHourlyMax";
                    $yesterday = date("Ymd",strtotime("-1 day",mktime(0,0,0,date("m"),date("d"),date("Y"))));
                break;
                case "daily": $query = "getNmsSnmpDailyMax"; $date = substr($date,0,6);
                break;
                case "weekly": $query = "getNmsSnmpWeeklyMax"; $date = substr($date,0,6);
                break;
                case "monthly": $query = "getNmsSnmpMonthlyMax"; $date = substr($date,0,4);
                break;
                case "yearly": $query = "getNmsSnmpYearlyMax"; $date = substr($date,0,4);
                break;
                
            }

            $args->mib_srl = $mib_srl;

            if($date) $args->regdate = $date;
            elseif(!$date||$yesterday) $args->yesterday = $yesterday;
            else $args->regdate = date("Ymd");

			$output = executeQuery("nms.".$query, $args);
            if(!$output->toBool()) return $output;

            return $output->data;
        }

    }
?>
