<?php
    /**
     * @class  nmsView
     * @author largeden (webmaster@animeclub.net)
     * @brief  nmsXE 모듈의 View class
     **/

    class nmsView extends nms {

        /**
         * @brief 초기화
         **/
        function init() {

            /**
             * 기본 모듈 정보들 설정 (list_count, page_count는 게시판 모듈 전용 정보이고 기본 값에 대한 처리를 함)
             **/
            if($this->module_info->list_count) $this->list_count = $this->module_info->list_count;
            if($this->module_info->search_list_count) $this->search_list_count = $this->module_info->search_list_count;
            if($this->module_info->page_count) $this->page_count = $this->module_info->page_count;
            $this->except_notice = $this->module_info->except_notice == "N" ? false : true;

            /**
             * 상담 기능 체크. 현재 게시판의 관리자이면 상담기능을 off시킴
             * 현재 사용자가 비로그인 사용자라면 글쓰기/댓글쓰기/목록보기/글보기 권한을 제거함
             **/
            if($this->module_info->consultation == "Y" && !$this->grant->manager) {
                $this->consultation = true; 
                if(!Context::get("is_logged")) $this->grant->list = $this->grant->write_document = $this->grant->write_comment = $this->grant->view = false;
            } else {
                $this->consultation = false;
            }

            /** 
             * 게시판 전반적으로 사용되는 javascript, JS 필터 추가
             **/
            Context::addJsFilter($this->module_path."tpl/filter", "input_password.xml");
            Context::addJsFile($this->module_path."tpl/js/board.js");

            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
        }

        /** 
         * @brief MIB 등록 화면에 표시될 Mib 트리거 함수
         **/
        function triggerDispNmsMibInsert(&$obj) {
            $oNmsModel = &getModel("nms");
            
            $args = Context::getRequestVars();
            if($args->mib_srl) {
                $output = $oNmsModel->getNmsMibInfo($args);
                if(!$output->toBool()) return $this->stop("msg_invalid_request");
            }

            // 템플릿에 쓰기 위해서 context::set
            Context::set("mib_info", $output->data);

            // 템플릿 파일 지정
            $oTemplate = &TemplateHandler::getInstance();
            $tpl = $oTemplate->compile($this->module_path."tpl", "trigger_mib_insert");
            $obj .= $tpl;

            return new Object();
        }
        
        /** 
         * @brief MIB 등록 화면에 표시될 Severity 트리거 함수
         **/
        function triggerDispNmsSeveritySetup(&$obj) {
            $oNmsModel = &getModel("nms");
            
            $args = Context::getRequestVars();

            $output = $oNmsModel->getNmsMibInfo($args);
            if(!$output->toBool()) return $this->stop("msg_invalid_request");

            // 템플릿에 쓰기 위해서 context::set
            Context::set("mib_info", $output->data);

            // 템플릿 파일 지정
            $oTemplate = &TemplateHandler::getInstance();
            $tpl = $oTemplate->compile($this->module_path."tpl", "trigger_severity_insert");
            $obj .= $tpl;

            return new Object();
        }

        /** 
         * @brief Host 정보 출력시 그래프 화면 트리거 함수
         **/
        function triggerDispNmsHostGraph(&$obj) {

            // 템플릿 파일 지정
            $oTemplate = &TemplateHandler::getInstance();
            $tpl = $oTemplate->compile($this->module_path."tpl", "trigger_host_graph");
            $obj .= $tpl;

            return new Object();
        }

        /** 
         * @brief 모듈 출력
         **/
        function dispNmsContent() {
            /**
             * 목록보기 권한 체크 (모든 권한은 ModuleObject에서 xml 정보와 module_info의 grant 값을 비교하여 미리 설정하여 놓음)
             **/
            if(!$this->grant->access) return $this->dispNmsMessage("msg_not_permitted");

            $oNmsModel = &getModel("nms");

            if(!$this->module_info->statistics) $this->module_info->statistics = "5minutely";
            if(!$this->module_info->width) $this->module_info->width = 600;
            if(!$this->module_info->height) $this->module_info->height = 300;
			if(!$this->module_info->datepattern) $this->module_info->datepattern = 1;
			if(!$this->module_info->datetype) $this->module_info->datetype = "H:i";

            $args = Context::getRequestVars();
            $args->module_srl = $this->module_info->module_srl;

            // 모듈이 출력 될 때 관련 SNMP 로그의 정보를 구하기 위한 처리 (자세한 수행 설명은 Controller에 적어놓음 -_-)
            $host_info = $oNmsModel->getNmsModuleInfo($args);

            foreach($host_info->oMib as $oMib) {
                $mmid = $oMib->get("mmid");
                $output = $oMib->getNmsSnmpSummary($this->module_info->statistics,$mmid,$this->module_info->date);

                if(!is_array($output)) $output = array($output);

                foreach($output as $key => $val) {
                    if($val->value > $oSize->value_max) $oSize->value_max = $val->value;
                }
                if($oSize->value_max > $oSize->total_max) $oSize->total_max = $oSize->value_max;
            }
            $host_info->size = $oMib->getSizeFormat($oSize->total_max);
			if($oMib->get("max")<101) $host_info->size = "%";

            $color = explode(",",$this->module_info->color); $i = 1; $z = 0;
            foreach($host_info->oMib as $oMib) {
                $mmid = $oMib->get("mmid");
                /*
                해당 모듈에 등록된 MIB 정보를 선언 
                (하루 기준)
                5minutely : 5분 평균 값
                hourly : 1시간 평균 값
                (한달 기준)
                daily : 1일 평균 값
                weekly : 1주 평균 값
                (년 기준)
                monthly : 월 평균 값
                yearly : 년 평균 값(특정 년도를 선언하면 그 해 부터 현재 년도까지를 집계)
                */
                $output = $oMib->getNmsSnmpSummary($this->module_info->statistics,$mmid,$this->module_info->date);

                if($i>1) $chart->num[] = "_".$i;
                $chart->color[] = $color[$i-1];
                $chart->title[] = $oMib->get("mib_title");

                foreach($output as $key => $val) {
                    $traffic[$i] .= $oMib->getSizeBytes($val->value,$host_info->size).","; 
                    if($i==1) {
                        if(!($z%$this->module_info->datepattern)) {
                            $snmpDate .= zdate($val->regdate,$this->module_info->datetype).",";
                        }else{
                            $snmpDate .= ",";
                        }
                    }
                    if($oMib->getSizeBytes($val->value,$host_info->size) > $value_max) {
                     $value_max = $oMib->getSizeBytes($val->value,$host_info->size);
                    }
                    $z++;
                }
                if($i==1) $chart->snmpdate = trim($snmpDate,",");
                $chart->traffic[] = trim($traffic[$i],",");
                $i++;
            }
            $chart->value_max = $value_max;

            Context::set("host_info",$host_info);
            Context::set("chart",$chart);

            /**
             * 스킨 경로를 미리 template_path 라는 변수로 설정함
             * 스킨이 존재하지 않는다면 xe_board로 변경
             **/
            $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            if(!is_dir($template_path)||!$this->module_info->skin) {
                $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            }
            $this->setTemplatePath($template_path);

            // template_file을 list.html로 지정
            $this->setTemplateFile("list");
        }

        /**
         * @brief 메세지 출력
         **/
        function dispNmsMessage($msg_code) {
            $msg = Context::getLang($msg_code);
            if(!$msg) $msg = $msg_code;
            Context::set("message", $msg);
            $this->setTemplateFile("message");
        }

    }
?>
