<?php

    /**
     * @class  nmsItem
     * @author largeden (webmaster@animeclub.net)
     * @brief  nmsXE 모듈의 Item class
     **/

    // 향후 연동을 위해 선언함
    require_once(_XE_PATH_."modules/document/document.item.php");

    class nmsItem extends documentItem {

        function setAttributeModuleSrl($attribute) {
            if(!$attribute->module_srl) {
                $this->module_srl = null;
                return;
            }

            $this->module_srl = $attribute->module_srl;
            $this->adds($attribute);
        }

        function getGroupSrl() {
            return $this->get("group_srl");
        }

        function getGid() {
            $oNmsModel = &getModel("nms");
            $output = $oNmsModel->getNmsGroupSrlByGid($this->get("group_srl"));
            return $output->gid;
        }

        function getMid() {
            return $this->get("mid");
        }

        function getBrowser_title() {
            return $this->get("browser_title");
        }

        function getHost() {
            return $this->get("host");
        }

        function getRegdate() {
            return zdate($this->get("regdate"),"Y-m-d");
        }

        /**
         * @brief Mib 값으로 SNMP LOG 값을 출력
         **/        
        function getMib($mmid = "", $list_count = "") {
            $oNmsModel = &getModel("nms");
            $args->mmid = $mmid;
            $output = $oNmsModel->getNmsMibInfo($args);
            $args->mib_srl = $output->data->mib_srl;

            $args->sort_index = "snmp_srl";
            $args->page = Context::get("page");
            $args->list_count = $list_count;
            $args->page_count = 10;

            $output = $oNmsModel->getNmsSnmpLog($args);

            return $output->data;
        }
        
        function getMax() {
            return $this->get("max");
        }

        /**
         * @brief Model class에 있는 통계 처리정보를 추출하기 위한 함수
         **/
        function getNmsSnmpSummary($type="",$mmid="",$date="") {
            if(!$type || !$mmid) return;
            $oNmsModel = &getModel("nms");

			$args->module_srl = $this->module_srl;
			$args->mmid = $mmid;

			$oMib = $oNmsModel->getNmsMibInfo($args);
            $mib_srl = $oMib->data->mib_srl;

            return $oNmsModel->getNmsSnmpSummary($type,$mib_srl,$date);
        }

        /**
         * @brief Model class에 있는 MAX,MIN 통계 처리정보를 추출하기 위한 함수
         **/
        function getNmsSnmpMax($type="",$mmid="",$date="") {
            if(!$type || !$mmid) return;
            $oNmsModel = &getModel("nms");

			$args->module_srl = $this->module_srl;
			$args->mmid = $mmid;

			$oMib = $oNmsModel->getNmsMibInfo($args);
            $mib_srl = $oMib->data->mib_srl;

            return $oNmsModel->getNmsSnmpMax($type,$mib_srl,$date);
        }

        /**
         * @brief 입력 값을 가지고 단위 계산
         **/
        function getSizeFormat($bytes, $type = false, $persent = "") {

			if($persent == "%") return round($bytes, 2).$persent;
            
            $units = array("Byte", "KB", "MB", "GB", "TB");
          
            $bytes = max($bytes, 0);
            $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
            $pow = min($pow, count($units) - 1);
          
            $bytes /= pow(1024, $pow);

            if($type) return round($bytes, 2).$units[$pow];

            return $units[$pow];
        }

        /**
         * @brief 입력 값을 가지고 단위 계산
         **/
        function getSizeBytes($bytes,$type) {
            
            if($type == "KB") $bytes = $bytes/1024;
            elseif($type == "MB") $bytes = $bytes/1024/1024;
            elseif($type == "GB") $bytes = $bytes/1024/1024/1024;
            elseif($type == "TB") $bytes = $bytes/1024/1024/1024/1024;

            return round($bytes, 2);
        }

    }
?>
