<?php
    /**
     * @class  nmsController
     * @author largeden (largeden@animeclub.net)
     * @brief  nmsXE 모듈의 Controller class
     **/
    
    // pChart 처리를 위한 함수를 호출
    include_once(_XE_PATH_."/modules/nms/tpl/chart/pChart/pChart/pData.class");
    include_once(_XE_PATH_."/modules/nms/tpl/chart/pChart/pChart/pChart.class");   

    class nmsController extends nms {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        function insertNmsHost($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            $output = executeQuery("nms.insertNmsHost", $args);
            
            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // commit
            $oDB->commit();
            
            $output->add("module_srl",$args->module_srl);

            return $output;
        }

        function updateNmsHost($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            $output = executeQuery("nms.updateNmsHost", $args);

            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // commit
            $oDB->commit();

            return $output;

        }

        function deleteNmsHost($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            // trigger 호출 (before) : 모듈이 삭제되면 자식격인 MIB도 삭제되도록 함
            $output = ModuleHandler::triggerCall("nms.deleteNmsHost", "before", $args);
            if(!$output->toBool()) return $output;

            $output = executeQuery("nms.deleteNmsHost", $args);

            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // trigger 호출 (after) : 차후 연동을 위해 준비함
            if($output->toBool()) {
                $trigger_output = ModuleHandler::triggerCall("nms.deleteNmsHost", "after", $args);
                if(!$trigger_output->toBool()) {
                    $oDB->rollback();
                    return $trigger_output;
                }
            }

            // commit
            $oDB->commit();

            return $output;
        }

        function insertNmsGroup($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            // 이미 존재하는 그룹 이름인지 체크
            $output = executeQuery("nms.isExistsNmsGroup", $args);
            if(!$output->toBool() || $output->data->count) {
                return new Object(-1, "msg_group_name_exists");
            }

             // group_srl 생성
            if(!$args->group_srl) $args->group_srl = getNextSequence();

            // 그룹 등록
            $output = executeQuery("nms.insertNmsGroup", $args);
            
            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // commit
            $oDB->commit();
            
            $output->add("group_srl",$args->group_srl);

            return $output;
        }

        function updateNmsGroup($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            $output = executeQuery("nms.updateNmsGroup", $args);

            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }
            
            // commit
            $oDB->commit();

            return $output;

        }

        function deleteNmsGroup($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            // trigger 호출 (before) : 그룹이 삭제될때 연동될 내용을 위해 선언해 둠
            $output = ModuleHandler::triggerCall("nms.deleteNmsGroup", "before", $args);
            if(!$output->toBool()) return $output;

            $output = executeQuery("nms.deleteNmsGroup", $args);

            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // trigger 호출 (after) : 그룹이 삭제될때 연동될 내용을 위해 선언해 둠
            if($output->toBool()) {
                $trigger_output = ModuleHandler::triggerCall("nms.deleteNmsGroup", "after", $args);
                if(!$trigger_output->toBool()) {
                    $oDB->rollback();
                    return $trigger_output;
                }
            }

            // commit
            $oDB->commit();

            return $output;
        }

        function insertNmsMib($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();


            // 이미 존재하는 MIB 이름인지 체크
            $output = executeQuery("nms.isExistsNmsMmid", $args);
            if(!$output->toBool() || $output->data->count) {
                return new Object(-1, "msg_mmid_name_exists");
            }

            // 이미 존재하는 MIB 명인지 체크
            $output = executeQuery("nms.isExistsNmsMib", $args);
            if(!$output->toBool() || $output->data->count) {
                return new Object(-1, "msg_mib_name_exists");
            }

            // mib_srl 번호 생성 (생성은 XE의 번호로 부여한다)
            if(!$args->mib_srl) $args->mib_srl = getNextSequence();

            // MIB 등록
            $output = executeQuery("nms.insertNmsMib", $args);
            
            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // commit
            $oDB->commit();
            
            $output->add("module_srl",$args->module_srl);
            $output->add("mib_srl",$args->mib_srl);

            return $output;
        }

        function updateNmsMib($args ){
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            $output = executeQuery("nms.updateNmsMib", $args);
            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // commit
            $oDB->commit();

            return $output;

        }

        function deleteNmsMib($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            // trigger 호출 (before) : MIB가 삭제될때 연동될 내용을 위해 선언해 둠
            $output = ModuleHandler::triggerCall("nms.deleteNmsMib", "before", $args);
            if(!$output->toBool()) return $output;

            $output = executeQuery("nms.deleteNmsMib", $args);

            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // trigger 호출 (after) : MIB가 삭제될때 연동될 내용을 위해 선언해 둠
            if($output->toBool()) {
                $trigger_output = ModuleHandler::triggerCall("nms.deleteNmsMib", "after", $args);
                if(!$trigger_output->toBool()) {
                    $oDB->rollback();
                    return $trigger_output;
                }
            }

            // commit
            $oDB->commit();

            return $output;
        }

        /**
         * @brief 수집된 SNMP를 저장
         **/
        function insertNmsSnmpLog($args = "") {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            // trigger 호출 (before) : SNMP가 수집될떄 연동될 내용을 위해 선언해 둠
            $output = ModuleHandler::triggerCall("nms.insertNmsSnmpLog", "before", $args);
            if(!$output->toBool()) return $output;

            $output = executeQuery("nms.insertNmsSnmpLog", $args);

            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // trigger 호출 (after) : SNMP가 수집될떄 연동될 내용을 위해 선언해 둠
            if($output->toBool()) {
                $trigger_output = ModuleHandler::triggerCall("nms.insertNmsSnmpLog", "after", $args);
                if(!$trigger_output->toBool()) {
                    $oDB->rollback();
                    return $trigger_output;
                }
            }

            // commit
            $oDB->commit();
            
            return $output;
        }

        /**
         * @brief SNMP 수집 처리
         **/
        function procNmsSnmp() {
            Context::setResponseMethod("XMLRPC");
            $oNmsModel = &getModel("nms");
            $args = Context::getRequestVars();
            if($args->act != "procNmsSnmp" || !$args->group_srl) return;

            // MIB 번호로 정보를 요청하면 몇가지의 경우는 아래의 값도 나오기에 아래 값을 제거
            $isStr = array(
                "Gauge32: ",
                "Timeticks: ",
                "Counter32: ",
                "OID: ",
                "IpAddress: ",
                "Hex: "
            );
            
            // 요청되어 들어온 group_srl 번호에 해당하는 모든 HOST MIB 정보를 구해서 기록
            $host_info = $oNmsModel->getNmsHostList($args);

           foreach($host_info->data as $oHost) {
                $mib_info = $oNmsModel->getNmsMibList($oHost);
                if($mib_info->data) {
                    foreach($mib_info->data as $oMib) {

                            $snmp = snmpget($oHost->host, $oHost->community, $oMib->mib, 1);
                            if(!$snmp) $snmp = 0;
                            // snmp log 번호 부여(LOG가 많아지기에 XE번호가 아닌 자체 번호 부여)
                            $obj->snmp_srl = $this->getNextSequence();
                            $obj->module_srl = $oHost->module_srl;
                            $obj->mib_srl = $oMib->mib_srl;
                            $obj->mib = $oMib->mib;
                            $obj->value = str_replace($isStr,"",$snmp);

                            $this->insertNmsSnmpLog($obj);
                            $this->procNmsSeverity($obj, "snmp");
                    }
                }
                // 모듈 스킨에서 pChart로 설정했을 경우 기록과 동시에 차트 생성 함수를 호출
                $this->procPChart($oHost);
            }
            
        }

        /**
         * @brief pChart 생성
         **/        
        function procPChart($args) {
            $oNmsModel = &getModel("nms");
            $oModuleModel = &getModel("module");

            $host_info = $oNmsModel->getNmsModuleInfo($args);

            $skin_vars = $oModuleModel->getModuleSkinVars($args->module_srl);

            if(!$skin_vars["statistics"]->value) $skin_vars["statistics"]->value = "5minutely";
            if(!$skin_vars["width"]->value) $skin_vars["width"]->value = 600;
            if(!$skin_vars["height"]->value) $skin_vars["height"]->value = 300;
            if(!$skin_vars["datepattern"]->value) $skin_vars["datepattern"]->value = 1;
            if(!$skin_vars["datetype"]->value) $skin_vars["datetype"]->value = "H:i";

            // 모듈에 등록된 MIB들을 모듈 스킨 설정에 따라 그 범위안의 최대치를 구함
            foreach($host_info->oMib as $oMib) {
                $mmid = $oMib->get("mmid");
                $output = $oMib->getNmsSnmpSummary($skin_vars["statistics"]->value,$mmid,$skin_vars["date"]->value);

                if(!is_array($output)) $output = array($output);

                foreach($output as $key => $val) {
                    if($val->value > $oSize->value_max) $oSize->value_max = $val->value;
                }
                if($oSize->value_max > $oSize->total_max) $oSize->total_max = $oSize->value_max;

            }
            // 최대치의 결과 단위를 구함
            $host_info->size = $oMib->getSizeFormat($oSize->total_max);
			if($oMib->get("max")<101) $host_info->size = "%";

            // 모듈 스킨에 설정된 컬러 정보를 가져옴
            $color = explode(",",$skin_vars["color"]->value); 
            $i = 1; 
            $z = 0;
            foreach($host_info->oMib as $oMib) {
                $mmid = $oMib->get("mmid");
                /*
                해당 모듈에 등록된 MIB 정보를 선언 
                (하루 기준)
                5minutely : 5분 평균 값
                hourly : 1시간 평균 값
                (한달 기준)
                daily : 1일 평균 값
                weekly : 1주 평균 값
                (년 기준)
                monthly : 월 평균 값
                yearly : 년 평균 값(특정 년도를 선언하면 그 해 부터 현재 년도까지를 집계)
                */
                $output = $oMib->getNmsSnmpSummary($skin_vars["statistics"]->value,$mmid,$skin_vars["date"]->value);

                if($i>1) $chart->num[] = "_".$i;
                $chart->color[] = $color[$i-1];
                $chart->title[] = $oMib->get("mib_title");
                $ptraffic = "";
                foreach($output as $key => $val) {
                    $traffic[$i] .= $oMib->getSizeBytes($val->value,$host_info->size).",";
                    $ptraffic[] = $oMib->getSizeBytes($val->value,$host_info->size);
                    if($i==1) {
                        if(!($z%$skin_vars["datepattern"]->value)) {
                            $snmpDate .= zdate($val->regdate,$skin_vars["datetype"]->value).",";
                            $psnmpDate[] = zdate($val->regdate,$skin_vars["datetype"]->value);
                        }else{
                            $snmpDate .= ",";
                            $psnmpDate[] = "";
                        }

                    }
                    if($oMib->getSizeBytes($val->value,$host_info->size) > $value_max) {
                     $value_max = $oMib->getSizeBytes($val->value,$host_info->size);
                    }
                    $z++;
                }
                if($i==1) {
                    $chart->snmpdate = trim($snmpDate,",");
                    $chart->psnmpdate = $psnmpDate;
                }
                $chart->traffic[] = trim($traffic[$i],",");
                $chart->ptraffic[] = $ptraffic;
                $i++;
            }
            $chart->value_max = $value_max;

            // 위 처리로 결과 값이 나오면 pChart 종류에 따른 라이브러리를 호출
            if($host_info->oMib) {
                if(in_array($skin_vars["chart_type"]->value, array("Pdata_line","Pbar_chart","Ppie_chart"))) {
                    include(_XE_PATH_."/modules/nms/tpl/chart/pChart/format/".$skin_vars["chart_type"]->value.".php");
                }
            }
        }

        /**
         * @brief Syslog 등록
         **/
        function insertNmsSyslog($args = "") {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            // trigger 호출 (before)
            $output = ModuleHandler::triggerCall("nms.insertNmsSyslog", "before", $args);
            if(!$output->toBool()) return $output;

            $output = executeQuery("nms.insertNmsSyslog", $args);

            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // trigger 호출 (after)
            if($output->toBool()) {
                $trigger_output = ModuleHandler::triggerCall("nms.insertNmsSyslog", "after", $args);
                if(!$trigger_output->toBool()) {
                    $oDB->rollback();
                    return $trigger_output;
                }
            }

            // commit
            $oDB->commit();

            return $output;

        }

        /**
         * @brief Syslog 처리
         **/
        function procNmsSyslog() {
            Context::setResponseMethod("XMLRPC");
            $args = Context::getRequestVars();
            if($args->act != "procNmsSyslog") return;

            $args->msg = urldecode($args->msg);
            
            /* 메시지 포멧을 nms.socket.php에서 "[192.168.0.1:2323]<191>메시지" 로 형식하여 보낸걸 파싱 함 */
            // [192.168.0.1:2323] 안의 정보를 구해서 ip와 port로 나눔
            preg_match_all("!\[([^\>]*)\]!is", $args->msg, $ip);
            $ip = $ip[1][0];
            $ip = explode(":",$ip);

            // <191> 안의 정보를 구함
            preg_match_all("!<([^\>]*)\>!is", $args->msg, $priority);
            $priority = $priority[1][0];

            // []과 <>의 내용을 제거
            $value = preg_replace_callback("!\[([^\>]*)\]!i",array($this, "_code"), $args->msg);
            $obj->value = preg_replace_callback("!\<([^\>]*)\>!i",array($this, "_code"), $value);
            // syslog 번호 부여(LOG가 많아지기에 XE번호가 아닌 자체 번호 부여)
            $obj->syslog_srl = $this->getNextSequence();
            // RFC 규약의 priority 값을 facility과 severity으로 계산 처리
            $obj->priority = $priority;
            $obj->facility = floor($priority/8);
            $obj->severity = $priority%8; 
            $obj->ip_address = $ip[0];
            $obj->ip_port = $ip[1];
            // ip 버전을 구함 IPv4,IPv6
            if($obj->ip_address) $obj->ip_type = (count(explode(".", $obj->ip_address))==4)?4:6;
            // syslog 입력
            $this->insertNmsSyslog($obj);
            // severity 값의 필터 처리를 위한 호출
            $this->procNmsSeverity($obj, "syslog");
        }

        // []과 <> 내용 제거
        function _code($matches) {
            return $matches[2];
        }

        /**
         * @brief Snmp Trap 처리 (미완성)
         **/
        function procNmsSnmpTrap() {
            Context::setResponseMethod("XMLRPC");
            $args = Context::getRequestVars();
            if($args->act != "procNmsSnmpTrap") return;

            return;
        }

        /**
         * @brief severity 값의 필터 처리를 위한 트리거 함수
         **/
        function procNmsSeverity($args = "", $type) {
            if(!$args || !$type) return;

            // trigger 호출 (before)
            $output = ModuleHandler::triggerCall("nms.procNmsSeverity", "before", $args);
            $output = ModuleHandler::triggerCall("nms.procNmsSeverity", "after", $args);
               
            return false;
        }

        /**
         * @brief 번호 부여 함수
         **/        
        function getNextSequence() {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            $output = executeQuery("nms.getNmsSequence");
            if(!$output->toBool()) return;

            if(!$output->data->seq) {
                $args->seq = 1;
                $output = executeQuery("nms.insertNmsSequence", $args);
            
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return $output;
                }

            } else { 
                $args->seq = $output->data->seq+1;
                $output = executeQuery("nms.updateNmsSequence", $args);

                if(!$output->toBool()) {
                    $oDB->rollback();
                    return $output;
                }

            }

            // commit
            $oDB->commit();

            return $args->seq;
        }

        function deleteNmsSyslog($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            // trigger 호출 (before) : Syslog가 삭제될때 연동될 내용을 위해 선언해 둠
            $output = ModuleHandler::triggerCall("nms.deleteNmsSyslog", "before", $args);
            if(!$output->toBool()) return $output;


            $output = executeQuery("nms.deleteNmsSyslog", $args);

            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // trigger 호출 (after) : Syslog가 삭제될때 연동될 내용을 위해 선언해 둠
            if($output->toBool()) {
                $trigger_output = ModuleHandler::triggerCall("nms.deleteNmsSyslog", "after", $args);
                if(!$trigger_output->toBool()) {
                    $oDB->rollback();
                    return $trigger_output;
                }
            }

            // commit
            $oDB->commit();

            return $output;
        }

        function deleteNmsSnmpTrap($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            // trigger 호출 (before) : Snmp Trap이 삭제될때 연동될 내용을 위해 선언해 둠
            $output = ModuleHandler::triggerCall("nms.deleteNmsSnmpTrap", "before", $args);
            if(!$output->toBool()) return $output;

            $output = executeQuery("nms.deleteNmsSnmpTrap", $args);

            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // trigger 호출 (after) : Snmp Trap이 삭제될때 연동될 내용을 위해 선언해 둠
            if($output->toBool()) {
                $trigger_output = ModuleHandler::triggerCall("nms.deleteNmsSnmpTrap", "after", $args);
                if(!$trigger_output->toBool()) {
                    $oDB->rollback();
                    return $trigger_output;
                }
            }

            // commit
            $oDB->commit();

            return $output;
        }

        // Host가 삭제 될때 해당하는 MIB도 삭제를 하기 위한 트리거 함수
        function triggerDeleteNmsMib($args) {
            $this->deleteNmsMib($args);
        }

        // MIB가 삭제될떄 해당 Severity도 삭제를 하기 위한 트리거 함수
        function triggerDeleteNmsSeverity($args) {
            $this->deleteNmsSeverity($args);
        }

        function deleteNmsSeverity($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            $output = executeQuery("nms.deleteNmsSeverity", $args);

            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // commit
            $oDB->commit();

            return $output;
        }

        function deleteNmsSnmpLog($args) {
            // begin transaction
            $oDB = &DB::getInstance();
            $oDB->begin();

            $output = executeQuery("nms.deleteNmsSnmpLog", $args);
            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // commit
            $oDB->commit();

            return $output;
        }

    }

?>
