<?php
    /**
     * @class  nms
     * @author largeden (webmaster@animeclub.net)
     * @brief  nms 모듈의 high class
     **/

    require_once(_XE_PATH_."modules/nms/nms.item.php");

    class nms extends ModuleObject {

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
            $oModuleController = &getController("module");

            $oModuleController->insertTrigger("nms.dispNmsHostInfo", "nms", "view", "triggerDispNmsHostGraph", "before");
            $oModuleController->insertTrigger("nms.dispNmsInsertMib", "nms", "view", "triggerDispNmsMibInsert", "before");
            $oModuleController->insertTrigger("nms.dispNmsInsertMib", "nms", "view", "triggerDispNmsSeveritySetup", "after");
            $oModuleController->insertTrigger("nms.dispNmsSyslogList", "nms", "view", "triggerDispNmsSeveritySetup", "after");
            $oModuleController->insertTrigger("nms.dispNmsSnmpTrapList", "nms", "view", "triggerDispNmsSeveritySetup", "after");
            $oModuleController->insertTrigger("nms.deleteNmsHost", "nms", "controller", "triggerDeleteNmsMib", "after");
            $oModuleController->insertTrigger("nms.deleteNmsHost", "nms", "controller", "triggerDeleteNmsSeverity", "after");
            $oModuleController->insertTrigger("nms.deleteNmsMib", "nms", "controller", "triggerDeleteNmsSeverity", "after");

        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {

            return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {

            return new Object(0, "success_updated");
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }
    }
?>
