<?php
    /**
     * @class  nmsAdminController
     * @author largeden (largeden@animeclub.net)
     * @brief  nmsXE 모듈의 admin controller class
     **/

    class nmsAdminController extends nms {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief Shell 스크립트 처리 함수 (관리자페이지 기본설정에서 소켓을 실행할때 이 함수가 백그라운드 명령 수행을 함)
         **/
        function getShellScript($cmd){
            $path = dirname(__FILE__)."/";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
                pclose(popen("start /B ". "php -q ".$path."nms.socket.php ".$cmd, "r"));
            } else { 
                shell_exec("php -q ".$path."nms.socket.php ".$cmd." > /dev/null &");
            }
        }

        /**
         * @brief 기본설정에서 syslog, snmptrap 수행시 그룹에서 시간 설정 시 sockets 폴더로 해당 Url정보를 만들어 생성 함
         **/
        function procCronInsert($time = "", $group_srl = ""){
            if(!$time || !$group_srl) return;

            $path = dirname(__FILE__)."/socket/crontab/".$time."/";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
            }

            $fp = fopen($path.$group_srl, "w");
            
            if($group_srl == "syslog") fwrite($fp, Context::getRequestUri()."?module=nms&act=procNmsSyslog");
            elseif($group_srl == "snmptrap") fwrite($fp, Context::getRequestUri()."?module=nms&act=procNmsSnmpTrap");
            else fwrite($fp, Context::getRequestUri()."?module=nms&act=procNmsSnmp&group_srl=".$group_srl);

            fclose($fp);

            return false;
        }

        /**
         * @brief Cron 정보 삭제 함수
         **/
        function procCronDelete($time = "", $group_srl = ""){
            if(!$time || !$group_srl) return;

            $path = dirname(__FILE__)."/socket/crontab/".$time."/";
            if(substr(php_uname(), 0, 7) == "Windows") {
                $path = ereg_replace("/","\\",$path);
                pclose(popen("del ".$path.$group_srl, "r"));
            } else { 
                shell_exec("rm -rf ".$path.$group_srl." > /dev/null &");
            }

            return false;
        }

        /**
         * @brief 기본정보 설정
         **/
        function procNmsAdminInsertConfig($args = null) {
            $oModuleModel = &getModel("module");

            $args = Context::getRequestVars();

            $oNms = $oModuleModel->getModuleConfig("nms", $args);

            /* cron 사용여부에 따른 shell 명령 처리*/
            if($args->crontype=="Y") {
                if($args->crontype == $oNms->crontype) $this->getShellScript("cron stop");
            
                if(ereg("\|@\|",$args->schedule)) {
                    $cron_schedule = explode("|@|",$args->schedule);
                    foreach($cron_schedule as $key => $val) {
                        $this->getShellScript("cron ".$val);
                    }
                } else $this->getShellScript("cron ".$args->schedule);
            } elseif ($args->crontype=="N") $this->getShellScript("cron stop");

            /* syslog 사용여부에 따른 shell 명령 처리*/
            if($args->syslogtype=="Y") {
                $this->procCronInsert("syslog","syslog");
                if($oNms->syslogtype=="N") $this->getShellScript("syslog start"); 
            } elseif($args->syslogtype=="N") $this->getShellScript("syslog stop");

            /* snmp trap 사용여부에 따른 shell 명령 처리*/
            if($args->snmptraptype=="Y") {
                $this->procCronInsert("snmptrap","snmptrap");
                if($oNms->snmptraptype=="N") $this->getShellScript("snmptrap start"); 
            } elseif($args->snmptraptype=="N") $this->getShellScript("snmptrap stop");

            $oModuleController = &getController("module");
            $oModuleController->insertModuleConfig("nms", $args);

            $this->setMessage("success_saved");
        }

        function procNmsAdminInsertHost($args = null) {
            // module 모듈의 model/controller 객체 생성
            $oModuleController = &getController("module");
            $oModuleModel = &getModel("module");
            $oNmsController = &getController("nms");

            $args = Context::getRequestVars();
            $args->module = "nms";
            $args->mid = $args->board_name;
            unset($args->board_name);

            // module_srl이 넘어오면 원 모듈이 있는지 확인
            if($args->module_srl) {
                $module_info = $oModuleModel->getModuleInfoByModuleSrl($args->module_srl);
                if($module_info->module_srl != $args->module_srl) unset($args->module_srl);
            }

            $obj->module_srl = $args->module_srl;
            $obj->module = $args->module;
            $obj->mid = $args->mid;
            $obj->browser_title = $args->browser_title;
            $obj->skin = $args->skin;
            $obj->description = $args->description;

            // module_srl의 값에 따라 module insert/update
            if(!$args->module_srl) {
                $output = $oModuleController->insertModule($obj);
                $msg_code = "success_registed";
            } else {
                $output = $oModuleController->updateModule($obj);
                $msg_code = "success_updated";
            }

            if(!$output->toBool()) return $output;

            // module_srl의 값에 따라 host insert/update
            if(!$args->module_srl) {
                $args->module_srl = $output->get("module_srl");
                $output = $oNmsController->insertNmsHost($args);
            } else {
                $output = $oNmsController->updateNmsHost($args);
            }

            if(!$output->toBool()) return $output;

            $this->add("page",Context::get("page"));
            $this->add("module_srl",$output->get("module_srl"));
            $this->add("act","dispNmsAdminHostInfo");
            $this->setMessage($msg_code);

        }

        function procNmsAdminInsertGroup($args = null){
            $oNmsController = &getController("nms");
            $oNmsModel = &getModel("nms");

            $args = Context::getRequestVars();

            if($args->group_srl) {
                $group_info = $oNmsModel->getNmsGroupInfo($args->group_srl);
                if($args->schedule != $group_info->schedule) $this->procCronDelete($group_info->schedule,$group_info->group_srl);
            }

            // group_srl의 값에 따라 insert/update
            if(!$args->group_srl) {
                $output = $oNmsController->insertNmsGroup($args);
                $msg_code = "success_registed";
                $this->add("act","dispNmsAdminGroupList");
            } else {
                $output = $oNmsController->updateNmsGroup($args);
                $msg_code = "success_updated";
                $this->add("act","dispNmsAdminGroupInfo");
            }

            if(!$output->toBool()) return $output;

            // Cron 정보를 저장하기 위한 처리
            if(!$args->group_srl) $args->group_srl = $output->get("group_srl");
            if($args->cronstate=="Y") $this->procCronInsert($args->schedule,$args->group_srl);
            elseif($args->cronstate=="N") $this->procCronDelete($args->schedule,$args->group_srl);

            $this->add("page",Context::get("page"));
            $this->add("group_srl",$output->get("group_srl"));
            $this->setMessage($msg_code);

        }

        function procNmsAdminDeleteHost($args = null) {
            $oModuleController = &getController("module");
            $oNmsController = &getController("nms");

            $args = Context::getRequestVars();

            // 모듈 삭제
            $output = $oModuleController->deleteModule($args->module_srl);
            if(!$output->toBool()) return $output;

            // 호스트 삭제
            $output = $oNmsController->deleteNmsHost($args);
            if(!$output->toBool()) return $output;

            // 삭제 전 Host로 설정된 모든 SNMP 로그를 삭제 함
            if($args->log_delete=="Y") {
                $snmp_log_output = $oNmsController->deleteNmsSnmpLog($args);
                if(!$snmp_log_output->toBool()) return $snmp_log_output;
            }

            $this->add("page",Context::get("page"));
            $this->add("act","dispNmsAdminIndex");
            $this->setMessage("success_deleted");
        }

        function procNmsAdminDeleteGroup($args = null) {
            $oNmsController = &getController("nms");
            $oNmsModel = &getModel("nms");

            $args = Context::getRequestVars();

            // 생성한 Cron 파일 삭제
            if($args->cronstate=="Y") {
                $group_info = $oNmsModel->getNmsGroupInfo($args->group_srl);
                $this->procCronDelete($group_info->schedule,$group_info->group_srl);
            }

            $output = $oNmsController->deleteNmsGroup($args);
            if(!$output->toBool()) return $output;

            $this->add("page",Context::get("page"));
            $this->add("act","dispNmsAdminGroupList");
            $this->setMessage("success_deleted");
        }

        function procNmsAdminInsertMib($args = null) {
            $oNmsController = &getController("nms");
            $oNmsModel = &getModel("nms");

            $args = Context::getRequestVars();

            // mib_srl의 값에 따라 insert/update
            if(!$args->mib_srl) {
                $output = $oNmsController->insertNmsMib($args);
                $msg_code = "success_registed";
                $this->add("act","dispNmsAdminMibList");
            } else {
                $output = $oNmsController->updateNmsMib($args);
                $msg_code = "success_updated";
                $this->add("act","dispNmsAdminMibInfo");
            }

            if(!$output->toBool()) return $output;

            $this->add("page",Context::get("page"));
            $this->add("module_srl",$output->get("module_srl"));
            $this->add("mib_srl",$output->get("mib_srl"));
            $this->setMessage($msg_code);

        }

        function procNmsAdminDeleteMib($args = null) {
            $oNmsController = &getController("nms");

            $args = Context::getRequestVars();

            $output = $oNmsController->deleteNmsMib($args);
            if(!$output->toBool()) return $output;

            // MIB 삭제 전 MIB의 SNMP 로그를 삭제
            if($args->log_delete=="Y") {
                $snmp_log_output = $oNmsController->deleteNmsSnmpLog($args);
                if(!$snmp_log_output->toBool()) return $snmp_log_output;
            }

            $this->add("page",Context::get("page"));
            $this->add("module_srl",$output->get("module_srl"));
            $this->add("mib_srl",$output->get("mib_srl"));
            $this->add("act","dispNmsAdminMibList");
            $this->setMessage("success_deleted");
        }

        /**
         * @brief Syslog 삭제
         **/
        function procNmsAdminDeleteSyslog($args = null) {
            $oNmsController = &getController("nms");
            $args = Context::getRequestVars();

            if($args->mode == "delete") {
                $output = $oNmsController->deleteNmsSyslog($args);
                if(!$output->toBool()) return $output;
                $msg_code = "success_deleted";
            }

            $this->add("page",Context::get("page"));
            $this->setMessage($msg_code);
        }

        /**
         * @brief Snmp Trap 삭제
         **/
        function procNmsAdminDeleteSnmpTrap($args = null) {
            $oNmsController = &getController("nms");
            $args = Context::getRequestVars();

            if($args->mode == "delete") {
                $output = $oNmsController->deleteNmsSnmpTrap($args);
                if(!$output->toBool()) return $output;
                $msg_code = "success_deleted";
            }

            $this->add("page",Context::get("page"));
            $this->setMessage($msg_code);
        }

    }
?>
