<?php
    if(!defined("__ZBXE__")) exit();

	class rnq_newest_integrate {
	
		/**
         * @brief 언어파일 불러오기
         **/		
		function lang_($path) {
			$lang_type = Context::getLangType();
			require($path.'lang/'.$lang_type.'.lang.php');

			return $lang->rnq;
		}

		/**
         * @brief 브라우져 버젼 확인
         **/
		function getBrowser($ver) { // type::msie,msie6,firefox,opera(chrome),safari
			switch(eregi($ver,$_SERVER['HTTP_USER_AGENT'])) {
				case 1: return $ver; break;
				default: return false; break;
			}
		}

		/**
         * @brief 선택 값(모듈) 중 최근 게시글 시간(update) 구해오기
         **/
		function getDocuments($widget_info,$path) {
			$path = str_replace('./widgets/','',$path);
			$path = str_replace('/skins/rnq_newest_integrate/','',$path);
			$args->module_srl = $widget_info->module_srl;
			$args->list_count = 1;
			$args->sort_index = 'last_update';
			$args->order_type = 'desc';
			$args->category_srl = $widget_info->category_srl;
			$args->is_notice = $widget_info->is_notice;

			$output = executeQueryArray('widgets.'.$path.'.getNewestDocuments', $args);

			if(!$output->toBool()) return;
	
			foreach($output->data as $key) {
				$last_update = $key->last_update;
			}

			return $last_update;
		}

		/**
         * @brief 현재시간과 최근 게시글 시간(update)을 비교하여 갱신 일자 계산
         **/
		function TimeChangeName($Start_date,$Start_time,$path) {
			/* 언어파일 호출 */
			$lang->rnq = rnq_newest_integrate::lang_($path);

			$End_date = date('Ymd');
			$End_time = date('H:i:s');

			$Start = strtotime(substr($Start_date,0,4)."-".substr($Start_date,4,2)."-".substr($Start_date,6,2)." "."00:00:00");
			$End = strtotime(substr($End_date,0,4)."-".substr($End_date,4,2)."-".substr($End_date,6,2)." "."00:00:00");

			$DiffTime = $End - $Start;
			$DiffDay = floor($DiffTime / 86400);

			if($DiffDay <= 0) {
				$Start = strtotime(substr($Start_date,0,4)."-".substr($Start_date,4,2)."-".substr($Start_date,6,2)." ".$Start_time);
				$End = strtotime(substr($End_date,0,4)."-".substr($End_date,4,2)."-".substr($End_date,6,2)." ".$End_time);

				$DiffTime = $End - $Start;
				$DiffDay = floor($DiffTime / 86400);
				$DiffHour = floor($DiffTime % 86400 / 3600);
				$DiffMin = floor($DiffTime % 86400 % 3600 / 60);
				$DiffSec = $DiffTime % 86400 % 3600 % 60;
			}

			if($DiffDay != 0) {
				foreach($lang->rnq->_time->DiffDay as $key=>$val) {
					if($DiffDay <= $key) {
						$time = $val;
						break;
					}
				}
			} elseif($DiffHour != 0) {
				$time = $DiffHour.$lang->rnq->_time->DiffHour.' '.$DiffMin.$lang->rnq->_time->DiffMin;
			} elseif($DiffMin != 0) {
				$time = $DiffMin.$lang->rnq->_time->DiffMin;
			} elseif($DiffSec != 0) {
				foreach($lang->rnq->_time->DiffSec as $key=>$val) {
					if($DiffSec <= $key) {
						$time = $val;
						break;
					}
				}
			}
			return $time;
		}

	}

?>