<?php
    if(!defined("__ZBXE__")) exit();

	class rnq_login {

		/**
         * @brief 읽지 않은 쪽지 갯수 출력 함수
         **/
		function getNewMessage_info() {
				$logged_info = Context::get('logged_info');
				$args->receiver_srl = $logged_info->member_srl;
				$args->readed = 'N';
				$args->message_type = 'R';
			
				$output = executeQueryArray('widgets.login_info/skins/rnq_login.getNewMessage', $args);
				if(!$output->toBool()) return;
		
				foreach($output->data as $key){
					$message = $key->count;
				}

				return $message;
		}

		/**
         * @brief 외부 프로필 섬네일 생성 함수 (member 전용)
         **/
        function getMemberThumbnail($width = 80, $height = 80, $thumbnail_type = '', $thumbnail_src = '', $thumb_width = 1500, $thumb_height = 1500) {
			$width += 1;
			$height += 1;

            // 문서 모듈의 기본 설정에서 Thumbnail의 생성 방법을 구함
            if(!in_array($thumbnail_type, array('crop','ratio'))) {
                $config = $GLOBALS['__document_config__'];
                if(!$config) {
                    $oDocumentModel = &getModel('document');
                    $config = $oDocumentModel->getDocumentConfig();
                    $GLOBALS['__document_config__'] = $config;
                }
                $thumbnail_type = $config->thumbnail_type;
            }

			/* 요청 이미지의 사이즈를 구해서 제한 사이즈보다 크면 대체 이미지로 전환 */
			list($source_width, $source_height, $type, $attrs) = getimagesize(urldecode($thumbnail_src));
			if($source_width > $thumb_width || $source_height > $thumb_height) {
				return rnq_login::getThumbnail($width, $height, 'ratio', Context::getRequestUri()."widgets/login_info/skins/rnq_login/images/no_profile.jpg");
			}else if($source_width < $width || $source_height < $height) {
				return $thumbnail_src;
			}

			$width -= 1;
			$height -= 1;

			// 문서의 이미지 첨부파일 위치를 구함
			$thumbnail_exp = explode("/",$thumbnail_src);
			$thumbnail_count = count($thumbnail_exp);
			$thumbnail_domain = str_replace(Context::getRequestUri(),"",$thumbnail_src);
			$document_path = str_replace($thumbnail_exp[$thumbnail_count-1],"",$thumbnail_domain);

			if(!is_dir($document_path)) FileHandler::makeDir($document_path);

			// 썸네일 임시 파일명을 구함
			if($width != $height) $thumbnail_file = sprintf('%sthumbnail_%dx%d_%s.jpg', $document_path, $width, $height, $thumbnail_type);
			else $thumbnail_file = sprintf('%sthumbnail_%d_%s.jpg', $document_path, $width, $thumbnail_type);
            $thumbnail_url  = Context::getRequestUri().$thumbnail_file;

            // 썸네일 파일이 있을 경우
            if(file_exists($thumbnail_file)) {
				// 파일의 크기가 0 이면 return false 아니면 경로 return
                if(filesize($thumbnail_file)<1) {
					return false;
				}else{
					// 섬네일 파일이 있을 경우 원본 파일의 생성 시간이 나중이면 기존 파일 삭제
					if(filemtime($thumbnail_domain) > filemtime($thumbnail_file)){
						FileHandler::removeFile($thumbnail_file);
					}else{
						return $thumbnail_url;
					}
				}
            }

            $output = FileHandler::createImageFile($thumbnail_domain, $thumbnail_file, $width, $height, 'jpg', $thumbnail_type);

            // 썸네일 생성 성공시 경로 return
            if($output) return Context::getRequestUri().$thumbnail_file;

            // 차후 다시 썸네일 생성을 시도하지 않기 위해 빈 파일을 생성
            else FileHandler::writeFile($thumbnail_file, '','w');

            return;
        }

	}

?>