<?php
	/**
	* @class division
	* @author largeden (webmaster@animeclub.net)
	* @brief 
	* @version 1.1
	**/

	class division extends WidgetHandler {

		/**
		* @brief 위젯의 실행 부분
		*
		* ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
		* 결과를 만든후 print가 아니라 return 해주어야 한다
		**/
		function proc($args) {
			$oModuleModel = &getModel('module');

			// 제목
			$title = $args->title;

			// 정렬 대상
			$division_type = $args->division_type;
			$list_count = $args->list_count;
			if(!$list_count) $list_count = 1;

			// 정렬 대상
			$order_target = $args->order_target;

			$search_type = $args->search_type;

			$category_type = $args->category_type;

			// 제목 길이 자르기
			$subject_cut_size = $args->subject_cut_size;
			if(!$subject_cut_size) $subject_cut_size = 0;

			// 대상 모듈
			$mid_list = explode(",",$args->mid_list);

			// mid_type이 Y일 경우 mid_list 값을 무시하고 현재 모듈 정보로 검색
			if($args->mid_type == 'Y')
			{
				$module_srl = $oModuleModel->getModuleSrlByMid(Context::get('mid'));
				$logged_info = Context::get('logged_info');
			}
			else
			{
				// module_srl 대신 mid가 넘어왔을 경우는 직접 module_srl을 구해줌
				if($mid_list)
				{
					$module_srl = $oModuleModel->getModuleSrlByMid($mid_list);
					$logged_info = Context::get('logged_info');
				}
			}

			// DocumentModel::getDocumentList()를 이용하기 위한 변수 정리
			if(is_array($module_srl)) {
				$module_srl_im = implode(',',$module_srl);
				$divi->module_srl = $module_srl_im;
				}
			else $divi->module_srl = $module_srl;

			if($args->document_type == 'Y')
			{
				$divi->document_srl = Context::get('document_srl');
			}
			else
			{
				$divi->document_srl = $args->document_id;
			}

			$divi->category_type = $category_type;
			$divi->list_count = $list_count;
			$divi->no_search = $search_type;

			if($division_type == 'prev') $document_list = getDivision_prev($order_target,$divi);
			elseif($division_type == 'next') $document_list = getDivision_next($order_target,$divi);

			// 템플릿 파일에서 사용할 변수들을 세팅
			if(count($mid_list)==1) $widget_info->module_name = $mid_list[0];

			$widget_info->title = $title;
			$widget_info->subject_cut_size = $subject_cut_size;
			$widget_info->document_list = $document_list;

			Context::set('widget_info', $widget_info);

			// 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
			$tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
			Context::set('colorset', $args->colorset);


			// 템플릿 파일을 지정
			$tpl_file = 'list';

			// 템플릿 컴파일
			$oTemplate = &TemplateHandler::getInstance();
			$output = $oTemplate->compile($tpl_path, $tpl_file);
			return $output;
		}

	}

		function getDivision_next($order,$division){
			return _getDocumentDivision('next',$order,$division);
		}

		function getDivision_prev($order,$division){
			return _getDocumentDivision('prev',$order,$division);
		}

		function _getDocumentDivision($type,$order,$division){
			if(!$division->document_srl) {
				if(Context::get('document_srl')) $division->document_srl = Context::get('document_srl');
				else return;
			}
			if(!$division->search_target) {
				if(Context::get('search_target')) $division->search_target = Context::get('search_target');
			}
			if(!$division->search_keyword) {
				if(Context::get('search_keyword')) $division->search_keyword = Context::get('search_keyword');
			}
			if(!$division->list_count) $division->list_count = 1;
			if(!$type) $type = 'next';
			if(!$order) $order = 'list_order';

			$oDocumentModel = &getModel('document');
			$oDocument = $oDocumentModel->getDocument($division->document_srl, '');

			if($order == 'list_order') {
				$args->list_order = $oDocument->get('list_order'); 
				if($type == 'prev')	$args->first_list_order = $oDocument->get('list_order'); 
				elseif($type == 'next') $args->last_list_order = $oDocument->get('list_order'); 
			} elseif($order == 'update_order') {
				$args->update_order = $oDocument->get('update_order'); 
				if($type == 'prev')	$args->first_update_order = $oDocument->get('update_order'); 
				elseif($type == 'next')	$args->last_update_order = $oDocument->get('update_order'); 
			}

			$args->module_srl = $division->module_srl;
			$args->category_srl = ($division->category_type == 'Y')? Context::get('category'):'';
			$args->sort_index = ($order == 'list_order')?'list_order':'update_order';
			$args->order_type = ($type == 'prev')? ($division->list_count > 0)? 'desc':'asc' :'asc';
			$args->list_count = ($division->list_count > 1)? $division->list_count:1;
			$args->page_count = 1;
			$args->page = 1;

			// 검색 옵션 정리
			$search_target = ($division->no_search=='Y')? $division->search_target:'';
			$search_keyword = ($division->no_search=='Y')? $division->search_keyword:'';
			$query_id = "widgets.division.getDivisionDocument";
			if($search_target && $search_keyword) {

				switch($search_target) {
					case 'title' :
					case 'content' :
							if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
							$args->{"s_".$search_target} = $search_keyword;
						break;
					case 'title_content' :
							if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
							$args->s_title = $search_keyword;
							$args->s_content = $search_keyword;
						break;
					case 'user_id' :
							if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
							$args->s_user_id = $search_keyword;
							$args->sort_index = 'documents.'.$args->sort_index;
						break;
					case 'user_name' :
					case 'nick_name' :
					case 'email_address' :
					case 'homepage' :
							if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
							$args->{"s_".$search_target} = $search_keyword;
						break;
					case 'is_notice' :
					case 'is_secret' :
							if($search_keyword=='Y') $args->{"s_".$search_target} = 'Y';
							else $args->{"s_".$search_target} = '';
						break;
					case 'member_srl' :
					case 'readed_count' :
					case 'voted_count' :
					case 'comment_count' :
					case 'trackback_count' :
					case 'uploaded_count' :
							$args->{"s_".$search_target} = (int)$search_keyword;
						break;
					case 'regdate' :
					case 'last_update' :
					case 'ipaddress' :
							$args->{"s_".$search_target} = $search_keyword;
						break;
					case 'comment' :
							$args->s_comment = $search_keyword;
							$args->sort_index = 'documents.'.$args->sort_index;
							$query_id = 'widgets.division.getDivisionComment';
						break;
					case 'tag' :
							$args->s_tags = str_replace(' ','%',$search_keyword);
							$args->sort_index = 'documents.'.$args->sort_index;
							$query_id = 'widgets.division.getDivisionTag';
						break;
					default :
							preg_match('/^extra_vars([0-9]+)$/',$search_target,$matches);
							if($matches[1]) {
								$args->{"s_extra_vars".$matches[1]} = $search_keyword;
							}
						break;
				}
			}

			$output = executeQuery($query_id, $args);

			if($output->data) {
				if($type == 'prev'){
					$division_count = $division->list_count;
					foreach($output->data as $division_no2){
						$division_next[$division_count--] = $division_no2;
					}
					for($i=($division_count+1);$i<($division->list_count+1);$i++){
						$division_document[$i] = $division_next[$i];
					}
				}elseif($type == 'next'){
					$division_document = $output->data;
				}

				return $division_document;
			}
		}
/* End of file division.class.php */
/* Location: ./system/widgets/division/division.class.php */