<?php
/**
 * @class location
 * @author 라르게덴 (webmaster@animeclub.net)
 * @brief 메뉴 위치 출력 위젯
 * @version 0.2
 **/

class location extends WidgetHandler {

    /**
     * @brief 위젯의 실행 부분
     *
     * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
     * 결과를 만든후 print가 아니라 return 해주어야 한다
     **/
    function proc($args) {
		// 언어 파일 로딩

		
		$lang_type = context::getLangType();
		require_once('lang/'.$lang_type.'.lang.php');
		$Wlang = Context::get('lang');
		$Wlang->location = $lang->location;
        Context::set('lang', $Wlang);
		
		// 객체선언
		$oDocumentModel = &getModel('document');
		$oModuleModel = &getModel('module');

		$menu = $this->menu_view();


		// mid 정보 구하기
		$mid = (Context::get('mid'))? Context::get('mid'):'none';
		$oModule = $oModuleModel->getModuleInfoByMid(Context::get('mid'));
		if($lang->location->mid->{$mid}){
			$mid_title = $lang->location->mid->{$mid};
		}else{
			$mid_title = $oModule->browser_title;
		}
	
		// category 정보 구하기
		$category = (Context::get('category'))? Context::get('category'):'none';
	    if($lang->location->category->{'n_'.$category}) {
			$category_title = $lang->location->category->{'n_'.$category};
		}else{
			$oCategory = $oDocumentModel->getCategory(Context::get('category'));
			$category_title = $oCategory->title;
		}

		// document_srl 정보 구하기
		$document_srl = (Context::get('document_srl'))? Context::get('document_srl'):'none';
	    if($lang->location->document_srl->{'n_'.$document_srl}) {
			$document_title = $lang->location->document_srl->{'n_'.$document_srl};
		}else{
			if(Context::get('document_srl') && Context::get('act') != 'dispBoardWrite') {
				$oDocument = $oDocumentModel->getDocument(Context::get('document_srl'));
				$document_title = $oDocument->get('title');
			}
		}

		// action 정보 구하기
		$act = (Context::get('act'))? Context::get('act'):'none';
	    $act_title = ($lang->location->act->{$act})? $lang->location->act->{$act}:$act;

		// 구분자가 없을 경우 '>'로 기본값 설정
        if(!$args->partition) $args->partition = '&gt;';
        Context::set('partition', $args->partition);

		// 내용 길이가 길경우 문자열 제거
		if(!$args->subject_cut_size) $args->subject_cut_size = 20;


		if($menu){
			$widget_menu = $menu;
		}


		if($mid!='none') {
			$location[mid]->url = getUrl('','mid',$mid);
			$location[mid]->title = cut_str($mid_title,$args->subject_cut_size,'...');
		}
		// module이 default 일 경우 표시할지 안할지 여부
		if($args->is_default == 'N') {
			if($oModule->is_default == 'Y')	unset($location[mid]);
		}

		if($category!='none') {
			$location[category]->url = getUrl('','mid',$mid,'category',$category);
			$location[category]->title = cut_str($category_title,$args->subject_cut_size,'...');
		}

		if($document_srl!='none') {
			$location[document_srl]->url = getUrl('','document_srl',$document_srl);
			$location[document_srl]->title = cut_str($document_title,$args->subject_cut_size,'...');
		}
		// 문서 작성, 수정 시 문서 번호(명) 제거
		if(Context::get('act') == 'dispBoardWrite')	unset($location[document_srl]);

		if($act!='none') {
			$location[act]->url = getUrl('act',$act);
			$location[act]->title = cut_str($act_title,$args->subject_cut_size,'...');
		}

        // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
        $tpl_path = $this->widget_path.'skins/'.$args->skin;
        Context::set('colorset', $args->colorset);

		$widget_info = $location;
		Context::set('widget_menu', $widget_menu);
		Context::set('widget_info', $widget_info);

        // 템플릿 파일을 지정
        $tpl_file = 'location';

        // 템플릿 컴파일
        $oTemplate = &TemplateHandler::getInstance();
        return $oTemplate->compile($tpl_path, $tpl_file);
    }


	function menu_view(){
        $layout_info = Context::get('layout_info');
        $menu = Context::get($layout_info->default_menu);
        if(!$menu->list) return;

		$selected_node = $this->menu_sub_view($menu->list);
		$menu_list = $selected_node;
		$menu_list_selected = $selected_node;

		$menu_location = array();
		$menu_location[$selected_node['text']] = $selected_node['href'];

		$i=1;
		while($while=$i){
			if($menu_list_selected['selected']==1){
				$sub_menu = $this->menu_sub_view($menu_list['list']);
				$menu_location[$sub_menu['text']] = $sub_menu['href'];
				$menu_srl[$i] = $sub_menu['node_srl'];
				$menu_list = $menu_list['list'][$menu_srl[$i]];
				$menu_list_selected = $menu_list;
				$i++;
			}else{
				$i=0;
			}
		}

	return $menu_location;

	}

	function menu_sub_view($menu){
		foreach($menu as $var) {
            if($var['selected'] == 1) {
                return $var;
            }
        }
	}


}
?>
