<?php
    /**
     * @class rnq_newest_document
     * @author largeden (webmaster@animeclub.net)
     * @brief 로마네스크 최근 게시물을 출력하는 위젯
     * @version 0.2
     **/

    class rnq_newest_document extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 제목
            $title = $args->title;

            // 정렬 대상
            $order_target = $args->order_target;
            if(!in_array($order_target, array('list_order','update_order','title','readed_count','voted_count'))) $order_target = 'list_order';

            // 정렬 순서
            $order_type = $args->order_type;
            if(!in_array($order_type, array('asc','desc'))) $order_type = 'asc';

            // 출력된 목록 수
            $list_count = (int)$args->list_count;
            if(!$list_count) $list_count = 5;

            // 최근 글 표시 시간
            $duration_new = (int)$args->duration_new;
            if(!$duration_new) $duration_new = 12;

            // 제목 길이 자르기
            $subject_cut_size = (int)$args->subject_cut_size;
            if(!$subject_cut_size) $subject_cut_size = 0;


			/* Romanesque 추가 정보 */
            
			// 내용 길이 자르기
			$content_cut_size = (int)$args->content_cut_size;
            if(!$content_cut_size) $content_cut_size = 200;

			// 리스트 출력 여부
			$is_notice = $args->is_notice;

			// 페이지 출력 여부
			$page_type = $args->page_type;
            if(!in_array($page_type, array('Y','N'))) $page_type = 'Y';

			// 페이지 구분자
			$page_value = 'page_'.$args->page_value;

			// 페이지 목록 수
			$page_count = $args->page_count;
			if(!$page_count) $page_count = 0;

            // 가로 사이즈
            $width_size = (int)$args->width_size;
            if(!$width_size) {
				$width_size = false;
			}else{
				if(100 >= $width_size) $width_size = $width_size.'%';
				else $width_size = $width_size.'px';
			}

            // 대상 카테고리
            $category_list = explode(",",$args->category_list);

			/* XML로 넘기기 위해 obj로 선언 */
            // 대상 모듈 (mid_list는 기존 위젯의 호환을 위해서 처리하는 루틴을 유지. module_srl로 위젯에서 변경)
            $oModuleModel = &getModel('module');
            if($args->mid_list) {
                $mid_list = explode(",",$args->mid_list);
                if(count($mid_list)) {
                    $module_srl = $oModuleModel->getModuleSrlByMid($mid_list);
                } else {
                    $site_module_info = Context::get('site_module_info');
                    if($site_module_info) {
                        $margs->site_srl = $site_module_info->site_srl;
                        $oModuleModel = &getModel('module');
                        $output = $oModuleModel->getMidList($margs);
                        if(count($output)) $mid_list = array_keys($output);
                        $module_srl = $oModuleModel->getModuleSrlByMid($mid_list);
                    }
                }
            } else $module_srl = explode(',',$args->module_srls);

            /* DocumentModel::getDocumentList()를 이용하기 위한 변수 정리 */
			if(is_array($module_srl)) $obj->module_srl = implode(',',$module_srl);
            else $obj->module_srl = $module_srl;
            $obj->sort_index = $order_target;
            $obj->order_type = $order_type=="desc"?"asc":"desc";
            $obj->list_count = $list_count;

            $obj->is_notice = $is_notice;
			if($page_type=='Y') $obj->page = (!Context::get($page_value))?1:Context::get($page_value);
			if(is_array($category_list)) $obj->category_srl = implode(',',$category_list);
            else $obj->category_srl = $category_list;

            $output = executeQueryArray('widgets.rnq_newest_document.getNewestDocuments', $obj);
			$output_count = executeQueryArray('widgets.rnq_newest_document.getNewestDocumentsCount', $obj);

            // document 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oDocumentModel = &getModel('document');

            // 오류가 생기면 그냥 무시
            if(!$output->toBool()) return;

            // 결과가 있으면 각 문서 객체화를 시킴
            if(count($output->data)) {
                foreach($output->data as $key => $attribute) {
                    $document_srl = $attribute->document_srl;

                    $oDocument = null;
                    $oDocument = new documentItem();
                    $oDocument->setAttribute($attribute);

                    $document_list[$key] = $oDocument;

					/* 출력되는 모듈의 번호를 구함 */
					$document_modulies[$attribute->module_srl] = $attribute->module_srl;
                }
            } else {
                $document_list = array();
            }

			/* 출력 중 구한 모듈의 번호로 모듈이름, 카테고리 이름을 계산 */
			foreach($document_modulies as $key) {
				// 모듈의 타이틀(browser_title) 정보를 구함
				$module_title[$key] = $oModuleModel->getModuleInfoByModuleSrl($key);

				// 모듈에 포함되는 카테고리 정보를 캐쉬에서 가져옴
				foreach($oDocumentModel->getCategoryList($key) as $val) {
					$document_categories[$val->category_srl] = $val;
				}
			}

            /* 템플릿 파일에서 사용할 변수들을 세팅 */
			if($args->mid_list){
	            if(is_array($mid_list)) $widget_info->module_name = $mid_list[0];
				else $widget_info->module_name = $mid_list;
			}else{
				if(is_array($module_srl)) {
					$widget_info->module_name[] = $oModuleModel->getModuleInfoByModuleSrl($module_srl[0]);
					$widget_info->module_name = $widget_info->module_name[0]->mid;
				} else {
					$widget_info->module_name = $module_srl;
				}
			}

            $widget_info->title = $title;
            $widget_info->document_list = $document_list;
            $widget_info->subject_cut_size = $subject_cut_size;
            $widget_info->duration_new = $duration_new * 60*60;

			/* Romanesque 추가 정보 */
			$widget_info->content_cut_size = $content_cut_size;
            $widget_info->is_notice = $is_notice;
            $widget_info->width_size = $width_size;
            $widget_info->category_srl = $category_srl;
			if(is_array($module_srl)) $widget_info->module_srl = implode(',',$module_srl);
			else $widget_info->module_srl = $module_srl;
            $widget_info->order_target = $order_target;
			$widget_info->module_title = $module_title;
			$widget_info->category_name = $document_categories;

			/* 페이지 네비게이션 기능 추가 */
            $widget_info->page_value = $page_value; // 페이지 구분자
            $widget_info->page_type = $page_type; // 페이지 사용 여부
			$widget_info->total_count = $output_count->data[0]->count; // 전체 개시물 수
            $widget_info->page = (!Context::get($page_value))? 1:Context::get($page_value); // 현재 페이지
			$total_count = $widget_info->total_count/$list_count; // 총 페이지 수
			if($widget_info->total_count%$list_count != 0) $total_count+=1;
            $widget_info->total_page = floor($total_count); // 총 페이지 수
            $widget_info->page_count = $page_count; // 총 페이지 수

			// 템플릿에서 사용하도록 변수를 선언
			Context::set('widget_info', $widget_info);

            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            // 템플릿 파일을 지정
            $tpl_file = 'list';

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            $output = $oTemplate->compile($tpl_path, $tpl_file);
            return $output;
        }

		/**
		 * @brief 다음 페이지 요청
		 **/
		function WD_getNextPage($total_count, $total_page, $cur_page, $page_count = 10) {

			$first_page = $cur_page - (int)($page_count/2);
			if($first_page<1) $first_page = 1;
			$last_page = $total_page;
			if($last_page>$total_page) $last_page = $total_page;
			if($total_page < $page_count) $page_count = $total_page;

			$GLOBALS['wd_total_page'] = $total_page;
			$GLOBALS['wd_first_page'] = $first_page;
			$GLOBALS['wd_page_count'] = $page_count;
			$GLOBALS['wd_last_page'] = $last_page;

			$page->first_page = $first_page;
			$page->last_page = $last_page;

			return $page;
		}

		function WD_getNextPage2() {
			$page = $GLOBALS['wd_first_page']+$GLOBALS['wd_i']++;
			if($GLOBALS['wd_i'] > $GLOBALS['wd_page_count'] || $page > $GLOBALS['wd_last_page']) $page = 0;
			return $page;
		}

		function WD_getNextClear() {
			$GLOBALS['wd_i'] = 0;
		}

	}

?>
