<?php
    if(!defined("__ZBXE__")) exit();

	class rnq_newest_notice {

		/**
         * @brief 브라우져 버젼 확인
         **/	
		function _browser() {
			$_ver = $_SERVER['HTTP_USER_AGENT'];
		return $_ver;
		}

		/**
         * @brief 공지용 글내용 처리를 위한 함수(글 가운데 섬네일 이미지를 넣기 위한 수단)
         **/	
		function getNotice($content) {
			$content_1 = rnq_newest_notice::getSummary($content,30);
			$content_2 = rnq_newest_notice::getSummary($content,false);

			return str_replace($content_1,'',$content_2);
		}

		/**
         * @brief 문자열 자르기에서 ...을 하지 않기 위해 별도로 함수 선언
         **/
        function getSummary($content, $str_size = 50) {
            // 영문이나 숫자가 연결되어서 20개 이상으로 연결시에 강제 띄움 시도
            $content = preg_replace('/([a-z0-9\-\+:\/\.\~,\|\!\@\#\$\%\^\&\*\(\)\_\+]){20,}/is',"$0 ",$content);
            // 태그 제거
            $content = preg_replace('!<([^>]*?)>!is','', $content);
            // < , > , " 를 치환
            $content = str_replace(array('&lt;','&gt;','&quot;','&nbsp;'), array('<','>','"',' '), $content);
            // 문자열을 자름
            $content = trim(cut_str($content, $str_size, ''));
            // >, <, "를 다시 복구
            return str_replace(array('<','>','"'),array('&lt;','&gt;','&quot;'), $content);
        }
	
		/**
         * @brief 언어파일 불러오기
         **/
		function lang_($path) {
			$lang_type = Context::getLangType();
			require($path.'lang/'.$lang_type.'.lang.php');

			return $lang->rnq;
		}

		/**
         * @brief 선택 값(모듈) 중 최근 게시글 시간(update) 구해오기
         **/
		function getDocuments($widget_info,$path) {
			$path = str_replace('./widgets/','',$path);
			$path = str_replace('/skins/rnq_newest_notice/','',$path);
			$args->module_srl = $widget_info->module_srl;
			$args->list_count = 1;
			$args->sort_index = 'last_update';
			$args->order_type = 'desc';
			$args->category_srl = $widget_info->category_srl;
			$args->is_notice = $widget_info->is_notice;

			$output = executeQueryArray('widgets.'.$path.'.getNewestDocuments', $args);

			if(!$output->toBool()) return;
	
			foreach($output->data as $key){
				$last_update = $key->last_update;
			}

			return $last_update;
		}

		/**
         * @brief 현재시간과 최근 게시글 시간(update)을 비교하여 갱신 일자 계산
         **/
		function TimeChangeName($Start_date,$Start_time,$path) {
			/* 언어파일 호출 */
			$lang->rnq = rnq_newest_notice::lang_($path);

			$End_date = date('Ymd');
			$End_time = date('H:i:s');

			$Start = strtotime(substr($Start_date,0,4)."-".substr($Start_date,4,2)."-".substr($Start_date,6,2)." "."00:00:00");
			$End = strtotime(substr($End_date,0,4)."-".substr($End_date,4,2)."-".substr($End_date,6,2)." "."00:00:00");

			$DiffTime = $End - $Start;
			$DiffDay = floor($DiffTime / 86400);

			if($DiffDay <= 0) {
				$Start = strtotime(substr($Start_date,0,4)."-".substr($Start_date,4,2)."-".substr($Start_date,6,2)." ".$Start_time);
				$End = strtotime(substr($End_date,0,4)."-".substr($End_date,4,2)."-".substr($End_date,6,2)." ".$End_time);

				$DiffTime = $End - $Start;
				$DiffDay = floor($DiffTime / 86400);
				$DiffHour = floor($DiffTime % 86400 / 3600);
				$DiffMin = floor($DiffTime % 86400 % 3600 / 60);
				$DiffSec = $DiffTime % 86400 % 3600 % 60;
			}

			if($DiffDay != 0) {
				foreach($lang->rnq->_time->DiffDay as $key=>$val) {
					if($DiffDay <= $key) {
						$time = $val;
						break;
					}
				}
			} elseif($DiffHour != 0) {
				$time = $DiffHour.$lang->rnq->_time->DiffHour.' '.$DiffMin.$lang->rnq->_time->DiffMin;
			} elseif($DiffMin != 0) {
				$time = $DiffMin.$lang->rnq->_time->DiffMin;
			} elseif($DiffSec != 0) {
				foreach($lang->rnq->_time->DiffSec as $key=>$val) {
					if($DiffSec <= $key) {
						$time = $val;
						break;
					}
				}
			}
			return $time;
		}

	}

?>