<?php
    /**
     * @class newest_document
     * @author zero (zero@nzeo.com)
     * @brief 최근 게시물을 출력하는 위젯
     * @version 0.1
     **/

    class Medias extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 제목
            $title = $args->title;

            // 정렬 대상
            $order_target = $args->order_target;

            // 정렬 순서
            $order_type = $args->order_type;

            // 출력된 목록 수
			$args->cols_list_count = (!$args->cols_list_count)? 5:$args->cols_list_count;
			$args->rows_list_count = (!$args->rows_list_count)? 5:$args->rows_list_count;
			$cols_list_count = (int)$args->cols_list_count;
            if(!$list_count) $list_count = 2;
			$rows_list_count = (int)$args->rows_list_count;
            if(!$list_count) $list_count = 2;
            $list_count = $cols_list_count * $rows_list_count;
            if(!$list_count) $list_count = 4;
			$page_count = $args->page_count;
            if(!$page_count) $page_count = 5;

			// 페이지 출력 여부
			$page_type = $args->page_type;

            // 대상 모듈
            $mid_list = explode(",",$args->mid_list);

			// 분류 선택
            $obj->category_id = $args->category_id;

            // 최근 글 표시 시간
            $duration_new = $args->duration_new;
            if(!$duration_new) $duration_new = 12;

            // module_srl 대신 mid가 넘어왔을 경우는 직접 module_srl을 구해줌
            if($mid_list) {
                $oModuleModel = &getModel('module');
                $module_srl = $oModuleModel->getModuleSrlByMid($mid_list);
				$logged_info = Context::get('logged_info');
            }

            // DocumentModel::getDocumentList()를 이용하기 위한 변수 정리

            if(is_array($module_srl)) {
				$module_srl_im = implode(',',$module_srl);
				$obj->module_srl = $module_srl_im;
				}
            else $obj->module_srl = $module_srl;

			if($order_target != 'N') $obj->sort_index = $order_target;

            $obj->order_type = $order_type=="desc"?"asc":"desc";

            $obj->list_count = $list_count;
            $obj->page_count = $page_count;
			if($page_type=='Y') $obj->page = (Context::get('page'))? Context::get('page'): 1;


			if($args->document_type == 'Y' && $args->comment_type == 'Y') {

			}elseif($args->document_type == 'Y'){
				$obj->document_type = '1';
				$obj->comment_type2 = '1';
			}elseif($args->comment_type == 'Y'){
				$obj->comment_type = '1';
			}else{
				$obj->document_type2 = '1';
				$obj->comment_type2 = '1';
			}

			if($args->aqua_hide) $obj->aqua_hide = $args->aqua_hide;
			if($args->document_hide) $obj->document_hide = $args->document_hide;

			$obj->document_id = ($args->document_id)? $args->document_id:false;
			$obj->comment_id = ($args->comment_id)? $args->comment_id:false;

            $output = executeQueryArray('widgets.medias.getMedias', $obj);
			$output_count = executeQueryArray('widgets.medias.getMediasCount', $obj);

            // document 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oDocumentModel = &getModel('document');

            // 오류가 생기면 그냥 무시
            if(!$output->toBool()) return;

            // 결과가 있으면 각 문서 객체화를 시킴
            if(count($output->data)) {
                foreach($output->data as $key => $attribute) {
                    $document_srl = $attribute->document_srl;

                    $oDocument = null;
                    $oDocument = new documentItem();
                    $oDocument->setAttribute($attribute);

                    $document_list[$key] = $oDocument;
                }
            } else {

                $document_list = array();
                
            }

            // 템플릿 파일에서 사용할 변수들을 세팅
			$widget_info->module_name = $mid_list[0];

            $widget_info->title = $title;
            $widget_info->document_list = $document_list;
            $widget_info->subject_cut_size = $subject_cut_size;
			$widget_info->cols_list_count = $cols_list_count;
			$widget_info->rows_list_count = $rows_list_count;
            $widget_info->duration_new = $duration_new * 60*60;
            $widget_info->page_type = $page_type;
			$widget_info->total_count = $output_count->data[0]->count; // 전체 개시물 수
            $widget_info->page = (!Context::get('page'))? 1:Context::get('page'); // 현재 페이지
			// 총 페이지 수
			$total_count = $widget_info->total_count/$list_count;
			if($widget_info->total_count%$list_count != 0) $total_count+=1;
            $widget_info->total_page = floor($total_count); // 총 페이지 수
            $widget_info->page_count = $page_count; // 총 페이지 수

            Context::set('widget_info', $widget_info);

            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);
			

            // 템플릿 파일을 지정
            $tpl_file = 'list';

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            $output = $oTemplate->compile($tpl_path, $tpl_file);
            return $output;
        }
    }

	/**
	 * @brief 다음 페이지 요청
	 **/

	function WD_getNextPage($total_count, $total_page, $cur_page, $page_count = 10) {

		$first_page = $cur_page - (int)($page_count/2);
		if($first_page<1) $first_page = 1;
		$last_page = $total_page;
		if($last_page>$total_page) $last_page = $total_page;
		if($total_page < $page_count) $page_count = $total_page;

		$GLOBALS['wd_total_page'] = $total_page;
		$GLOBALS['wd_first_page'] = $first_page;
		$GLOBALS['wd_page_count'] = $page_count;
		$GLOBALS['wd_last_page'] = $last_page;

		$page->first_page = $first_page;
		$page->last_page = $last_page;

		return $page;
	}

	function WD_getNextPage2() {
		$page = $GLOBALS['wd_first_page']+$GLOBALS['wd_i']++;
		if($GLOBALS['wd_i'] > $GLOBALS['wd_page_count'] || $page > $GLOBALS['wd_last_page']) $page = 0;
		return $page;
	}

	function WD_getNextClear() {
		$GLOBALS['wd_i'] = 0;
	}

	function medias_thumbnail($width = 300,$height = 0,$thumbnail_type = '',$thumbnail_src = '',$get_module_srl,$get_document_srl){

		// 문서 모듈의 기본 설정에서 Thumbnail의 생성 방법을 구함
		if(!in_array($thumbnail_type, array('crop','ratio'))) {
			$config = $GLOBALS['__document_config__'];
			if(!$config) {
				$oDocumentModel = &getModel('document');
				$config = $oDocumentModel->getDocumentConfig();
				$GLOBALS['__document_config__'] = $config;
			}
			$thumbnail_type = $config->thumbnail_type;
		}

		// 문서의 이미지 첨부파일 위치를 구함
		$src_proc_0 = array('%20','%28','%29');
		$src_proc_1 = array(' ','(',')');
		$thumbnail_src = str_replace($src_proc_0,$src_proc_1,$thumbnail_src);
		$thumbnail_exp = explode("/",$thumbnail_src);
		$thumbnail_count = count($thumbnail_exp);
		$thumbnail_domain = str_replace(Context::getRequestUri(),".",$thumbnail_src);
		$document_path = str_replace($thumbnail_exp[$thumbnail_count-1],"",$thumbnail_domain);
		if(!is_dir($document_path)) FileHandler::makeDir($document_path);

		// 썸네일 임시 파일명을 구함
		if($width != $height) $thumbnail_file = sprintf('%s%s_thumbnail_%dx%d_%s.jpg', $document_path, urldecode($thumbnail_exp[$thumbnail_count-1]), $width, $height, $thumbnail_type);
		else $thumbnail_file = sprintf('%s%s_thumbnail_%d_%s.jpg', $document_path, urldecode($thumbnail_exp[$thumbnail_count-1]), $width, $thumbnail_type);
		
		// 썸네일이 이미 만들어져있다면 ...
		if(file_exists($thumbnail_file)) return "./".$thumbnail_file; 
		
		// 외부파일이라면 ...
		if(!file_exists($document_path)) {
        $document_path = sprintf('files/attach/images/%d/%d/',$get_module_srl, $get_document_srl);
        $thumbnail_domain = sprintf('%s%s.jpg', $document_path,urldecode($thumbnail_exp[$thumbnail_count-1]), $width,$height,$thumbnail_type);
		$thumbnail_file = sprintf('%s%s_thumbnail_%dx%d_%s.jpg', $document_path, urldecode($thumbnail_exp[$thumbnail_count-1]), $width, $height, $thumbnail_type);
		FileHandler::makeDir($document_path);
        FileHandler::getRemoteFile($thumbnail_src, $thumbnail_domain);
		}

		// 비율계산해서 오류 수정하기 (원본과 썸네일 크기 비교)
        list($source_width, $source_height, $type, $attrs) = @getimagesize($thumbnail_domain);
		if($source_width < $width && $source_height < $height) return "./".$thumbnail_domain;
		if($source_width > $width && $source_height > $height) { 
		} elseif($thumbnail_type == 'ratio') {
			if($source_width > $source_height) unset($height);
			else unset($width);
		}

		// 썸네일 하기
		FileHandler::writeFile($thumbnail_file, '', 'w');
		FileHandler::createImageFile($thumbnail_domain, $thumbnail_file, $width, $height, 'jpg', $thumbnail_type);
		if(file_exists($thumbnail_file)) return "./".$thumbnail_file;

		FileHandler::writeFile($thumbnail_file,'');
		return;
	}

?>
