<?php
    /**
     * @class  MediasController 
     * @author largeden (webmaster@animeclub.net)
     * @brief  medias module's class 
     **/

    class MediasController extends medias {

        /**
         * @brief 초기화
         **/
        function init() {
        }
		
	/**
	 * @brief 글 등록 시 글 내용을 축출하여 medias 테이블에 저장
	 **/
	function procMedias($obj) {
		$args->document_srl = $obj;
		$this->procMediasDelete('no_comment',$obj);

		$oDocument = $this->getEntryDocument($args);

		$oMediasModel = &getModel('medias');
		preg_match_all('!<img([^\>]*)src=([^\>]*?)\>!is', $oDocument->content, $img_matchs);
		if(count($img_matchs[0]) >= 0) {
			for($i=0;$i<count($img_matchs[0]);$i++) {
				$args2[$i] = $this->procMediasImage($img_matchs[0][$i]);
				$args2[$i]->media_srl = $oMediasModel->stateSeqNext('sequence');
				$args2[$i]->document_srl = $oDocument->document_srl;
				$args2[$i]->comment_srl = 0;
				$args2[$i]->module_srl = $oDocument->module_srl;
				$args2[$i]->category_srl = $oDocument->category_srl;
				$args2[$i]->is_notice = $oDocument->is_notice;
				$args2[$i]->is_secret = $oDocument->is_secret;
				$args2[$i]->user_id = $oDocument->user_id;
				$args2[$i]->user_name = $oDocument->user_name;
				$args2[$i]->nick_name = $oDocument->nick_name;
				$args2[$i]->member_srl = $oDocument->member_srl;
				$args2[$i]->type = 'image';
				executeQuery('medias.insertMedias', $args2[$i]);
			}
		}


	}


	/**
	 * @brief 댓글 등록 시 댓글 내용을 축출하여 medias 테이블에 저장
	 **/
	function procMediasComment($obj) {
		$args->comment_srl = $obj;
		$this->procMediasDelete('comment',$obj);

		$oComment = $this->getEntryComment($args);
		$document_srl = $oComment->document_srl;
		$oDocument = $this->getEntryDocument($document_srl);

		$oMediasModel = &getModel('medias');
		preg_match_all('!<img([^\>]*)src=([^\>]*?)\>!is', $oComment->content, $img_matchs);
		if(count($img_matchs[0]) >= 0) {
			for($i=0;$i<count($img_matchs[0]);$i++) {
				$args2[$i] = $this->procMediasImage($img_matchs[0][$i]);
				$args2[$i]->media_srl = $oMediasModel->stateSeqNext('sequence');
				$args2[$i]->document_srl = $oComment->document_srl;
				$args2[$i]->comment_srl = $oComment->comment_srl;
				$args2[$i]->module_srl = $oComment->module_srl;
				$args2[$i]->category_srl = $oDocument->category_srl;
				$args2[$i]->is_notice = $oDocument->is_notice;
				$args2[$i]->is_secret = $oComment->is_secret;
				$args2[$i]->user_id = $oComment->user_id;
				$args2[$i]->user_name = $oComment->user_name;
				$args2[$i]->nick_name = $oComment->nick_name;
				$args2[$i]->member_srl = $oComment->member_srl;
				$args2[$i]->type = 'image';
				executeQuery('medias.insertMedias', $args2[$i]);
			}
		}


	}


	/**
	 * @brief 내용의 에디터 컴포넌트 코드를 변환
	 **/
	function _MediasQuotation($matches) {
		$key = $matches[1];
		$val = $matches[2];
		if(substr($val,0,1)!='"') $val = '"'.$val.'"';
		return sprintf('%s=%s', $key, $val);
	}

	/**
	 * @brief 첫번째, 두번째 수행 검사 시 존재하는 경우 처리 함수
	 **/
	function procMediasImage($matches) {
		$matches = str_replace("<IMG","<img",$matches);
        $matches = preg_replace_callback('/([^=^"^ ]*)=([^ ^>]*)/i', array($this, _MediasQuotation), $matches);

		$img_tag = explode("<img",$matches);
		$img = explode("\"",$img_tag[1]);
		
		$args->document_srl = $GLOBALS['document_srl'];
		$oDocument = $this->getEntryDocument($args);

		for ($z=0; $z<count($img); $z++) {
			switch($img[$z]){
				case " alt=": $obj->alt = $img[$z+1];
					break;
				case " src=": 
							$img_src = str_replace("http://",".",$img[$z+1]);
							$img_src_0 = explode("/",$img_src);
							if($img_src_0[0] != "files"){
								

								$img_src_count = count($img_src_0);
								$img_filename = urldecode($img_src_0[$img_src_count-1]);						        
								$img_filename = str_replace("%20"," ",$img_filename);
								$document_path = sprintf('files/attach/images/%d/%d/', $oDocument->module_srl, $oDocument->document_srl);
								FileHandler::makeDir($document_path);
								FileHandler::getRemoteFile($img[$z+1], $document_path.$img_filename);
		
								$obj->src = $document_path.$img_filename;
							}else{
								$obj->src = $img[$z+1];
							}
					break;
				case " width=": $obj->width = $img[$z+1];
					break;
				case " height=": $obj->height = $img[$z+1];
					break;
				case " zwidth=": $obj->zwidth = $img[$z+1];
					break;
				case " zheight=": $obj->zheight = $img[$z+1];
					break;
				case " aqua_hide=": $obj->aqua_hide = $img[$z+1];
					break;
				case " document_hide=": $obj->document_hide = $img[$z+1];
					break;
			}
		}

		return $obj;
	}

		/**
         * @brief document_srl의 정보를 축출
         **/
		function getEntryDocument($entry) {
            if($entry) {
                $output = executeQuery('document.getDocument', $entry);
            }
			
			if($output->data) {
					$oDocument = $output->data;
			}

            return $oDocument;
        }

		/**
         * @brief comment_srl의 정보를 축출
         **/
		function getEntryComment($entry) {
            if($entry) {
                $output = executeQuery('comment.getComment', $entry);
            }
			
			if($output->data) {
					$oComment = $output->data;
			}

            return $oComment;
        }	

		/**
         * @brief Medias 등록 내용 삭제
         **/
		function procMediasDelete($type, $srl){
			if($type == 'no_comment') {
				$args->document_srl = $srl;
				executeQuery('medias.deleteMediasDocument', $args);
			}elseif($type == 'document') {
				$args->document_srl = $srl;
				executeQuery('medias.deleteMedias', $args);
			}elseif($type == 'comment') {
				$args->comment_srl = $srl;
				executeQuery('medias.deleteMediasComment', $args);
			}
		}
	}
?>
