<?php
    /**
     * @class  medias 
     * @author largeden (webmaster@animeclub.net)
     * @brief  medias module's class 
     **/

    class medias extends ModuleObject {

        /**
         * @brief Install Medias module 
         **/
        function moduleInstall() {
            // action forward에 등록 (관리자 모드에서 사용하기 위함)
            $oModuleController = &getController('module');
            $oModuleController->insertActionForward('medias', 'view', 'dispMediasAdminIndex');
            $oModuleController->insertActionForward('medias', 'view', 'dispMediasAdminOBJ');
            $oModuleController->insertActionForward('medias', 'view', 'dispMediasAdminMIDI');

			$oMediasModel = &getModel('medias');
			$oMediasModel->insertState('sequence',0);
	
            return new Object();
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
            /**
             * 2008. 7. 16 : 초기 sequence 값이 등록실패인 경우 추가
             **/		
			$args->state_name = 'sequence';
            $output = executeQuery('medias.getState', $args);
			$row = $output->data->state_name;
			if(!$row) { return true; }

            return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {

			/**
             * 2008. 7. 16 : 초기 sequence 값이 등록실패인 경우 추가
             **/
			$args->state_name = 'sequence';
            $output = executeQuery('medias.getState', $args);
			$row = $output->data->state_int;
			if(!$row) {
				$oMediasModel = &getModel('medias');
				$oMediasModel->insertState('sequence',0);
			}

            return new Object(0,'success_updated');
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }
    }
?>
