<?php
    /**
     * @class  MediasAdminView 
     * @author largeden (webmaster@animeclub.net)
     * @brief  medias module's class 
     **/

    class MediasAdminView extends medias {

        /**
         * @brief 초기화
         **/
        function init() {
            // 템플릿 경로 지정 
            $this->setTemplatePath($this->module_path.'tpl');
        }

	    /**
         * @brief 로그 목록 출력
         **/
        function dispMediasAdminIndex() {
			if(!Context::get('sort_index')) Context::set('sort_index', 'regdate');
			if(!Context::get('sort_order')) Context::set('sort_order', 'desc');

            // member model 객체 생성후 목록을 구해옴
            $oMediasAdminModel = &getAdminModel('medias');
            $output = $oMediasAdminModel->getMediasList();

            // 템플릿에 쓰기 위해서 context::set
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('medias_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);

            // 템플릿 파일 지정
            $this->setTemplateFile('list');
        }

    }
?>
