<?php
    if(!defined("__ZBXE__")) exit();

    class entryProc extends ModuleObject {
        /**
         * @brief 관리자 기능으로 게시물 이동, 복사 시 처리 함수
         **/
        function procEntryAdminManageCheckedDocument($entry) {
            $type = $entry->type;
            $module_srl = $entry->module_srl;
            $cart = $entry->cart;
            // 선택된 게시물이 여러개일 경우를 대비하여 구분처리
            if($cart) $document_srl_list = explode('|@|', $cart);
            else $document_srl_list = array();
            $document_srl_count = count($document_srl_list);

            for($i=0;$i<$document_srl_count;$i++) {
            $oEntry->document_srl = $document_srl_list[$i];
            $oEntry->entry = $entry->eid;
            $oEntry->lang_code = $entry->lang_code;
                // move,copy 수행 시 처리
                if($type == 'move') {
                    $oEntry->module_srl = $module_srl;
                    $this->procEntryDocument($oEntry); // Entry URL을 var_idx 항목에 기록
                } elseif($type == 'copy') {
                    /* 
                    새로 생성되는 글 번호를 알 수 없기 때문에 복사대상의 글 중 extra_vars20 값과
                    중복인 대상자를 찾아 우선순위를 document_srl가 제일 높은 대상의 번호를 구함
                    */
                    $oEntry = getEntryDocument($oEntry);
                    $oEntry->module_srl = $module_srl;
                    $oEntry = getEntryID($oEntry);
                    $this->procEntryDocument($oEntry); // Entry URL을 var_idx 항목에 기록
                }
            }
        }
        
        /**
         * @brief document_srl을 알 수 없는 상태일 시 var_idx 기준으로 중복 검사 함수
         **/
        function getEntryID($entry) {
            if($entry) {
                $entry->sort_index = 'document_srl'; // regdate로 놀 경우 var_idx에 값이 없을 경우 문제발생
                $entry->order_type = "asc";
                $output = executeQuery('addons.entry.getEntryID', $entry);
                debugPrint($output);                
            }

            if(!$output->toBool()) return $output;
            $list = $output->data;
            if(!$list) return;
            if(!is_array($list)) $list = array($list);

            foreach($list as $val) {
                $oDocument = null;
                $oDocument->document_srl = $val->document_srl;
                $oDocument->module_srl = $val->module_srl;
                $oDocument->eid = $val->eid;
                $oDocument->lang_code = $val->lang_code;
            }

            return $oDocument; // 결과에서 document_srl만 리턴
        }

        /**
         * @brief Entry 주소를 위한 var_idx 값 중복 검사
         **/
        function getEntrySearch($entry) {
            if($entry) {
                $output = executeQuery('addons.entry.getEntrySearch', $entry);
                debugPrint($output);
            }

            if(!$output->toBool()) return $output;
            $list = $output->data;
            if(!$list) return;
            if(!is_array($list)) $list = array($list);

            foreach($list as $val) {
                $oEntry->count = ($val->entry == 0) ? true : false;
            }

            return $oEntry; // 중복된 결과의 수를 리턴
        }

        /**
         * @brief 특수 문자 제거 처리를 위해 필요한 특수문자를 array 처리 함수
         **/
        function procEntrySp_label($label) {
            // 제거할 문자: ?!@#$%^&\;:./=+'
            $sp_label = "?<>!<>@<>#<>$<>%<>^<>&<>\<>;<>:<>.<>/<>=<>+<>'<>";
            // 애드온 설정에 추가된 특수문자가 있다면 추가
            if($label) $sp_label = $sp_label."<>".$label;

            $sp_label_all = explode('<>',$sp_label);
            // 구분된 정보로 $GLOBALS['sp_label'] 변수에 저장
            for($i=0;$i<count($sp_label_all);$i++) {
                $GLOBALS['sp_label'][$i] = $sp_label_all[$i];
            }
        }

        /**
         * @brief Entry URL 저장을 위해 title 및 기존 var_idx에서 HTML,특수문자 등 제거
         **/
        function getEntryReplace($entry) {
            $title = strip_tags($entry->value); // HTML 제거
            $title = str_replace($GLOBALS['sp_label'],"",$title); // 특수문자 제거
            $title = str_replace(" ","-",$title); // 공백은 -(하이픈)으로 변경
            $oEntry->module_srl = $entry->module_srl;
            $oEntry->document_srl = $entry->document_srl;
            $oEntry->eid = $entry->eid;
            $oEntry->lang_code = $entry->lang_code;
            $oEntry->value = $title;

            $oEntrySearch = $this->getEntrySearch($oEntry); // 중복 검사
                debugPrint($oEntrySearch);            

            $i = 0;
            while(!$oEntrySearch->count) // 값이 없을때 까지 반복
            {
            $i++;
            $oEntry->value = $title."-".$i; // 중복 시 -숫자 로 값 증가
            $oEntrySearch = $this->getEntrySearch($oEntry); // 재검사
                debugPrint($oEntrySearch);                        
            }

            return $oEntry->value;
        }

        /**
         * @brief document_srl의 정보를 축출
         **/
        function getEntryDocument($entry) {
            if(!$entry) return;

            $output = executeQuery('addons.entry.getDocument', $entry);
                debugPrint($output);                        
            
            if(!$output->toBool()) return $output;
            $list = $output->data;
            if(!$list) return;
            if(!is_array($list)) $list = array($list);

            foreach($list as $val) {
                // 6가지만 필요로 하여 수행(다른변수가 필요하다면 컬럼 추가가능)
                $oDocument = null;
                $oDocument->document_srl = $val->document_srl;
                $oDocument->module_srl = $val->module_srl;
                $oDocument->title = $val->title;
                $oDocument->eid = $val->eid;
                $oDocument->lang_code = $val->lang_code;
                $oDocument->value = $val->value;
            }

            return $oDocument;
        }

        /**
         * @brief 다국어 글에 대한 정보를 축출
         **/
        function getEntryDocumentLang($entry) {
            if(!$entry) return;

            // 확장변수에서 해당 document_srl을 검사하여 지정 var_idx로 값을 구한다
            $output = executeQuery('addons.entry.getDocumentLang', $entry);
                debugPrint($output);                                    
            if(!$output->toBool()) return $output;
            $list = $output->data;
            if(!$list) return;
            if(!is_array($list)) $list = array($list);

            foreach($list as $val) {
                // 5가지만 필요로 하여 수행(다른변수가 필요하다면 컬럼 추가가능)
                $oDocument = null;
                $oDocument->document_srl = $val->document_srl;
                $oDocument->module_srl = $val->module_srl;
                $oDocument->eid = $val->eid;
                $oDocument->lang_code = $val->lang_code;
                $oDocument->value = $val->value;
            }

            // 다국어 정보 중 제목이 되는 var_idx를 구하여 추가적으로 타이틀을 구한다.
            $entry->var_idx = -1;
            $output = executeQuery('addons.entry.getDocumentLang', $entry);
                debugPrint($output);                                    
            if(!$output->toBool()) return $output;
            $list = $output->data;
            if(!$list) return;
            if(!is_array($list)) $list = array($list);

            foreach($list as $val) {
                // 확장변수는 확장 값과 다국어 제목이 value에 저장되어있어서 이를 title로 수정
                $oDocument->title = $val->value;
            }

            return $oDocument;
        }

        /**
         * @brief value 항목으로 Entry URL 결과물을 수정 함수
         * - 글 등록 시 같이 저장이 불가 하여 등록된 게시물을 다시 찾아 Entry URL을 수정 함
         **/
        function procEntryDocument($entry) {
            if(!$entry->document_srl) $entry = $this->getEntryID($entry);

            $oEntry = $this->getEntryDocument($entry);
            if(!$oEntry) return;

            // var_idx 항목에 내용이 없다면 글 제목으로 Entry URL 정보를 구함
            $oEntry->value = ($oEntry->value)? $oEntry->value : $oEntry->title;
            $obj->document_srl = $oEntry->document_srl;
            $obj->eid = $entry->eid;
            $obj->lang_code = $oEntry->lang_code; // 다국어 용으로 사용 시
            $obj->value = $this->getEntryReplace($oEntry); // Entry URL 형식으로 변경

            $output = executeQuery('addons.entry.updateEntry', $obj); // 결과물 수정
                debugPrint($output);                        
            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }
        }

        /**
         * @brief entry 변수 노출을 피하기 위해 링크 경로에서 제거하는 함수
         **/
        function procDocument_srlChangeEntry($output,$replace) {
            // 검사 대상자는 a 태그로 진행되는 대상 'href=' 이걸 page=로 바꾸면 검사 항목이 팍 줌
            preg_match_all('!<a([^\>]*)href=([^\>]*?)\>!is', $output, $matches);
            $matches_count = count($matches[0]);

            for($i=0;$i<$matches_count;$i++) {
                /*
                    entry.addon.php에서 호출 시 입력받은 정규식을 이용하여 대상자 색출
                    첫번째 검사 : a태그에 entry= 부분부터 처음나오는 &(&amp) 까지의 값을 찾음
                    두번쨰 검사 : a태그에 entry= 부분부터 처음나오는 " 까지의 값을 찾음
                */
                $matches_val = preg_replace_callback($replace, array($this,'getDocument_srlChangeEntry'), $matches[0][$i]);
                $output = str_replace($matches[0][$i],$matches_val,$output);
            }

            return $output;
        }

        /**
         * @brief 첫번째, 두번째 수행 검사 시 존재하는 경우 처리 함수
         **/
        function getDocument_srlChangeEntry($matches) {
            // 별거 없음 없애 버림
            return str_replace($matches[2],"",$matches[0]);
        }

        /**
         * @brief rewrite mod로 접근하지 않은 대상자를 rewrite 식으로 보이게 처리 함수
         **/
        function procEntryUri($entry_uri) {
            if(eregi("\?",$entry_uri)) { // 주소 값 중 ? 가 있는 주소라면 수행
                $entry = explode($GLOBALS['entry_label'],$entry_uri); // 구분 문자가 존재하면 대상으로 문자열 나눔
                $entry = explode("&",$entry[1]); // 구분 문자 다음부터 처음으로 오는 & 전까지를 구함
                $entry = $entry[0];
            } else {
                $entry = Context::get('entry');
            }

            return $entry;
        }
    }

?>