<?php
    if(!defined("__ZBXE__")) exit();

    /**
     * @file entry.addon.php
     * @author 라르게덴 (webmaster@animeclub.net)
     * @brief Entry URL 주소 생성 및 처리 애드온
     *
     **/

    if(Context::get('module') == 'admin') return; // 관리자 페이지면 수행 중단

    // Entry URL 사용을 위한 변수
    $document_srl = Context::get('document_srl');
    $mid = Context::get('mid'); 
    // 관리자 기능 중 복사,이동 시 사용 되는 변수
    $cart = Context::get('cart');
    $type = Context::get('type');

    // 애드온 설정 값 및 Entry 처리를 위한 변수
    $sp_label = $addon_info->sp_label;
    $GLOBALS['entry_label'] = $addon_info->entry_label;
    $GLOBALS['sp_label'] = array();

    $oEntry->eid = 'entry'; // 확장변수 eid가 entry 인 대상만을 기준으로 동작 합니다.
    $oEntry->lang_code = Context::getLangType();

    require_once('./addons/entry/entry.lib.php'); //Entry URL 처리를 위한 함수들 불러오기

        // 모듈,함수가 실행 된 후에 실행
        if($called_position == 'after_module_proc') {

            // 글 작성, 수정
            if($this->act == 'procBoardInsertDocument') {

                $oEntry->module_srl = $module_srl;
                $oEntry->document_srl = $document_srl;

                // class 선언
                $entryProc = new entryProc();
                $entryProc->procEntrySp_label($sp_label); // 특수문자 처리를 위한 함수 / $GLOBALS['sp_label']로 array 변수로 저장됨
                $entryProc->procEntryDocument($oEntry); // Entry URL을 var_idx 항목에 기록

            // 관리자 기능 중 복사, 이동
            } elseif($this->act == 'procDocumentManageCheckedDocument') {

                /***** 확장변수의 관리자 복사/이동에 문제점이 있어 일단 보류 합니다. ****
                $oModuleModel = &getModel('module'); // target_module의 번호를 mid 이름으로 찾기위해 객체선언
                $oMid = $oModuleModel->getModuleInfoByModuleSrl($module_srl); // module_srl로 검색하여 mid 값 구해옴
                procEntrySp_label($sp_label); // 특수문자 처리를 위한 함수 / $GLOBALS['sp_label']로 array 변수로 저장됨
                $oEntryAdmin->cart = $cart;
                $oEntryAdmin->type = $type;
                $oEntryAdmin->module_srl = $module_srl;

                $entryProc = new entryProc();
                //$entryProc->procEntryAdminManageCheckedDocument($oEntryAdmin); // Entry URL을 var_idx 항목에 기록
                */
            }
        } else {
            // 내용 출력 시 사용 document_srl가 있으면 수행 안함
            if(in_array($this->act, array('dispBoardContent','dispOpageIndex')) && !$document_srl) {
                // class 선언
                $entryProc = new entryProc();
                $entry = $entryProc->procEntryUri(urldecode($_SERVER['REQUEST_URI'])); // rewrite mod 비지원 시 entry 값 구함

                // 모듈 mid 정보로 module_srl 값 축출
                $oModuleModel = &getModel('module'); // 모듈값의 srl을 구하기 위한 객체 선언
                $module_info = $oModuleModel->getModuleInfoByMid($mid);
                $oEntry->module_srl = $module_info->module_srl;
                $_ver = $_SERVER['HTTP_USER_AGENT'];

                // Entry URL 정보를 UTF-8로 후 Entry 값으로 document_srl 축출
                $oEntry->value = (mb_detect_encoding($entry))? $entry : iconv("EUC-KR","UTF-8", $entry);
                $oEntryDocument = ($oEntry->value)? $entryProc->getEntryID($oEntry):'';

                // Entry URL의 모듈 값과 기본 모듈 값이 다를 경우 URL에 모듈 값을 추가
                if(($this->module_srl != $oEntryDocument->module_srl) && $oEntryDocument->document_srl) {
                    $oEntryMid = $oModuleModel->getModuleInfoByModuleSrl($oEntryDocument->module_srl);
                    // IE 6 패치
                    if(eregi('MSIE 6',$_SERVER['HTTP_USER_AGENT'])) $oEntry->value = iconv("UTF-8","EUC-KR", $oEntry->value);

                    $site = getUrl('','mid',$oEntryMid->mid,'document_srl',$GLOBALS['entry_label'].$oEntry->value);
                    header("location:$site"); exit;
                }

                if($oEntryDocument->document_srl) {
                    Context::set('document_srl',$oEntryDocument->document_srl); // document_srl 변수를 생성
                } else {
                    Context::set('entry'); // entry 변수 제거(?) 인듯 한데 잘 안되는듯;;
                }
            }
        }



    if($called_position != 'before_display_content') return; // 출력 바로 전 position이 아니면 수행 중단

    // class 선언
    $entryProc = new entryProc();
    // 게시물 페이지(page) 부분에서 entry변수가 노출 되기 때문에 이를 주소에서 제거
    $output = $entryProc->procDocument_srlChangeEntry($output,'!<a href="([^\>]*)(&amp;entry=([^\>]*?))&amp;!is');
    $output = $entryProc->procDocument_srlChangeEntry($output,'!<a href="([^\>]*)(&amp;entry=([^\>]*?))"!is');

?>