<?php
	if(!defined("__ZBXE__")) exit();

	class piclens {

		/**
		* @brief 본문 내용에서 mediasrss 태그만 추출하기
		**/
		function piclens_rss($output){ 
			Context::setResponseMethod("XMLRPC");
			$value = explode("</mediasrss>",$output);
			$value = explode("<mediasrss>",$value[0]);
			$output = $value[1];

			return $output;
		} 
		
		/**
		* @brief PicLens RSS 주소 추출하기 2008.11.09 20:00 추가
		**/
		function piclens_url($piclens_url){
			$value = explode("href=\"",$piclens_url);
			$value = explode("\"",$value[1]);
			$output = $value[0];

			return $output;
		}

		/**
		* @brief 먼가 module_srl을 mid로 바꾸는 함수가 실행이 안되서 임시로 만듬
		**/
		function getModuleInfoByModuleSrl($module_srl){
			$obj->module_srl = $module_srl;
			$output = executeQueryArray('module.getMidInfo', $obj);
			// 오류가 생기면 그냥 무시
			if(!$output->toBool()) return;
			return $output->data[0]->mid;
		}

		/**
		* @brief mid가 없이 document_srl로만 불러 올 경우 mid 구하기 2008.11.08 12:00 추가
		**/
		function getDocumentByMid($document_srl){
			$obj->document_srl = $document_srl;
			$output = executeQueryArray('document.getDocument', $obj);
			// 오류가 생기면 그냥 무시
			if(!$output->toBool()) return;
			return $this->getModuleInfoByModuleSrl($output->data[0]->module_srl);
		}

		/**
		* @brief 첨부파일을 가져옴
		**/
		function getFile($obj) {
			/* 대상 모듈 나누기 2008.11.09 20:00 추가 */
			$mid_list = explode(",",$obj->piclens_mid);

			/* module_srl 대신 mid가 넘어왔을 경우는 직접 module_srl을 구해줌 */
			if($mid_list) {
				$oModuleModel = &getModel('module');
				$module_srl = $oModuleModel->getModuleSrlByMid($mid_list);
			}

			if(is_array($module_srl)) {
				$module_srl_im = implode(',',$module_srl);
				$obj->module_srl = $module_srl_im;
			}else{
				$obj->module_srl = $module_srl;
			}

			/* 데이터와 파일의 여부가 일치하는 내용만 가져올지 여부 */
			$obj->isvalid = 'Y';

			$output = executeQueryArray('addons.piclens.getFileList', $obj);

			// 오류가 생기면 그냥 무시
			if(!$output->toBool()) return;

			return $output->data;

		}

		/**
		* @brief 외부 섬네일 생성 함수 특수문자 공백 등 대응 수정 2008.11.09 20:00 추가
		**/
		function getThumbnail($width = 300,$height = 0,$thumbnail_type = '',$target_src = '',$get_module_srl,$get_document_srl) {
			// 존재하지 않는 문서일 경우 return false
			if(!$get_document_srl) return;

			$noThumbnail = Context::getRequestUri()."/addons/piclens/images/noThumbnail.jpg";

			$oFileHandler = new FileHandler();

			// 썸네일 정보 정의 
			$thumbnail_filename = explode("/",$target_src);
			$thumbnail_name = explode(".",$thumbnail_filename[count($thumbnail_filename)-1]);
			$thumbnail_names = str_replace('+','%20',urlencode($thumbnail_name[count($thumbnail_name)-2]));
			$target_src = str_replace($thumbnail_name[count($thumbnail_name)-2],$thumbnail_names,$target_src);

			// 요청 사이즈 보다 작을 경우 원본 출력
			list($source_width, $source_height, $type, $attrs) = getimagesize(urldecode($target_src));
			if($source_width <= $width || $source_height <= $height) return $target_src;

			/*** 2009.07.30 섬네일되지 않는 경우의 패턴을 noThumbnail로 대체 (확장자 제외한 문자 중 공백기호를 기준으로 . 이 있는 경우)***/
			$error_fname = strrpos($thumbnail_filename[count($thumbnail_filename)-1],".");
			$error_fname = substr($thumbnail_filename[count($thumbnail_filename)-1],0,$error_fname);
			$error_name = split(" ",$error_fname);
			for($i=1;$i<count($error_name);$i++){
				if(sizeof(explode('.',$error_fname)) > 1) {
					return $this->getThumbnail($width, $height, 'ratio', $noThumbnail, $get_module_srl, $get_document_srl);
				}
			}

			// 문서 모듈의 기본 설정에서 Thumbnail의 생성 방법을 구함
			if(!in_array($thumbnail_type, array('crop','ratio'))) {
				$config = $GLOBALS['__document_config__'];
				if(!$config) {
					$oDocumentModel = &getModel('document');
					$config = $oDocumentModel->getDocumentConfig();
					$GLOBALS['__document_config__'] = $config;
				}
				$thumbnail_type = $config->thumbnail_type;
			}

			$thumbnail_names = str_replace('%','',$thumbnail_names);
			$thumbnail_path = sprintf('files/attach/images/%s/%s', $get_module_srl, getNumberingPath($get_document_srl, 3));
			$thumbnail_file = sprintf('%s%s_%dx%d.%s.jpg', $thumbnail_path, $thumbnail_names, $width, $height, $thumbnail_type);
			$thumbnail_url  = Context::getRequestUri().$thumbnail_file;

			// 썸네일 파일이 있을 경우 파일의 크기가 0 이면 return false 아니면 경로 return
			if(file_exists($thumbnail_file)) {
				if(filesize($thumbnail_file)<1) return false;
				else return $thumbnail_url;
			}

			// 대상 파일
			$source_file = null;
			$is_tmp_file = false;
			
			// 이미지 파일을 구함
			if(!$source_file) {
				if(!preg_match('/^(http|https):\/\//i',$target_src)) $target_src = Context::getRequestUri().$target_src;
				$tmp_file = sprintf('./files/cache/tmp/%d', md5(rand(111111,999999).$get_document_srl));

				/* ver 1.0.6 에서 외부 이미지 Thumbnail 오류 수정 */
				if(!is_dir('./files/cache/tmp')) $oFileHandler->makeDir('./files/cache/tmp');
				$oFileHandler->getRemoteFile($target_src, $tmp_file);

				if(!file_exists($tmp_file)) {
					continue;
				} else {

					list($_w, $_h, $_t, $_a) = @getimagesize($tmp_file);
					if($_w<$width || $_h<$height) continue;

					$source_file = $tmp_file;
					$is_tmp_file = true;
				}
			}

			$output = $oFileHandler->createImageFile($source_file, $thumbnail_file, $width, $height, 'jpg', $thumbnail_type);

			if($is_tmp_file) $oFileHandler->removeFile($source_file);

			// 썸네일 생성 성공시 경로 return
			if($output) return $thumbnail_url;

			else return $this->getThumbnail($width, $height, 'ratio', $noThumbnail, $get_module_srl,$get_document_srl);

			return;
	}
}
?>