<?php
    /**
     * @class  kinView
     * @author zero (skklove@gmail.com)
     * @brief  kin view class
     **/

    class kinView extends kin {

        function init() {
            $oDocumentModel = &getModel('document');
            if($this->module_info->use_category=='Y') Context::set('categories', $oDocumentModel->getCategoryList($this->module_srl));

            $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            if(!is_dir($template_path)||!$this->module_info->skin) {
                $this->module_info->skin = 'xe_official';
                $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            }
            $this->setTemplatePath($template_path);
            $this->setTemplateFile(strtolower(str_replace('dispKin','',$this->act)));
        }

        function dispKinIndex() {
            $oKinModel = &getModel('kin');
            $oDocumentModel = &getModel('document');

            if(Context::get('document_srl')) {
                $this->setTemplateFile('view');
                return $this->dispKinView();
            }

            $category_srl = Context::get('category_srl');

            $page = Context::get('page');
            if(!$page) Context::set('page',$page=1);
            $category_srl = Context::get('category_srl');
            $type = Context::get('type');
            if(!Context::get('is_logged')&&$type == 'my_questions') $type = '';
            $logged_info = Context::get('logged_info');

            $search_keyword = Context::get('search_keyword');

            switch($type) {
                case 'questions' :
                        $output = $oKinModel->getNotRepliedQuestions($this->module_srl, $category_srl, 40, $page, $search_keyword);
                        Context::set('document_list', $output->data);
                    break;
                case 'replies' :
                        $output = $oKinModel->getNotSelectedReplies($this->module_srl, $category_srl, 40, $page, $search_keyword);
                        Context::set('reply_list', $output->data);
                    break;
                case 'selected' :
                        $output = $oKinModel->getSelectedQuestions($this->module_srl, $category_srl, 40, $page, $search_keyword);
                        Context::set('document_list', $output->data);
                    break;
                case 'my_questions' :
                        $output = $oKinModel->getMyQuestions($this->module_srl, $category_srl, $logged_info->member_srl, 40, $page, $search_keyword);
                        Context::set('document_list', $output->data);
                    break;
                case 'my_replies' :
                        $output = $oKinModel->getMyReplies($this->module_srl, $logged_info->member_srl, $category_srl, 40, $page, $search_keyword);
                        Context::set('reply_list', $output->data);
                    break;
                default :
                        $obj->module_srl = $this->module_srl;
                        $obj->page = $page;
                        $obj->category_srl = $category_srl;
                        if($search_keyword) {
                            $obj->search_target = 'title_content';
                            $obj->search_keyword = $search_keyword;
                        }
                        $output = $oDocumentModel->getDocumentList($obj);
                        Context::set('document_list', $output->data);
                    break;
            }
            Context::set('page_navigation', $output->page_navigation);
        }

        function dispKinView() {
            $oModuleModel = &getModel('module');
            $oDocumentModel = &getModel('document');
            $oKinModel = &getModel('kin');

            $oDocument = $oDocumentModel->getDocument(Context::get('document_srl'));
            if(!$oDocument->isExists()) return new Object(-1, 'msg_document_is_null');

            $module_point_config = $oModuleModel->getModuleConfig('point');
            $min_point = $module_point_config->insert_document;

            Context::addBrowserTitle($oDocument->getTitleText());
            $oDocument->updateReadedCount();

            $point = $oKinModel->getKinPoint($oDocument->document_srl);
            if($point<$min_point) $point = $min_point;
            $oDocument->add('point', $point);
            Context::set('oDocument', $oDocument);

            $parent_srls = array($oDocument->document_srl);
            if(count($oDocument->getCommentCount())) {
                $replies = $oDocument->getComments();
                if(count($replies)) {
                    foreach($replies as $key => $val) $parent_srls[] = $val->comment_srl; 
                }
            }
            $replies_count = $oKinModel->getKinCommentCount($parent_srls);
            Context::set('replies_count', $replies_count);

            Context::set('category_srl', $oDocument->get('category_srl'));
            Context::set('selected_reply', $oKinModel->getSelectedReply($oDocument->document_srl));

            $point_config = $oModuleModel->getModuleConfig('point');
            Context::set('point_name', $point_config->point_name?$point_config->point_name:'point');

            Context::addJsFilter($this->module_path.'tpl/filter', 'insert_comment.xml');
        }

        function dispKinWrite() {
            $oDocumentModel = &getModel('document');
            $oKinModel = &getModel('kin');
            $oPointModel = &getModel('point');
            $oModuleModel = &getModel('module');

            if(!$this->grant->write_document) return new Object(-1,'msg_not_permitted');

            $logged_info = Context::get('logged_info');
            $point_config = $oModuleModel->getModuleConfig('point');
            $module_point_config = $oModuleModel->getModuleConfig('point');
            Context::set('point_name', $point_config->point_name?$point_config->point_name:'point');
            Context::set('user_point', $user_point = $oPointModel->getPoint($logged_info->member_srl, true));
            Context::set('min_point', $min_point = $module_point_config->insert_document);
            $max_point = $this->module_info->limit_give_point;
            if(!$max_point) $max_point = 100;
            Context::set('max_point', $max_point);

            $document_srl = Context::get('document_srl');
            $oDocument = $oDocumentModel->getDocument($document_srl);

            if(!$oDocument->isExists()) {
                if($this->module_info->limit_write == 'Y' && $user_point < $min_point) return new Object(-1,'msg_limit_write');
                $oDocument->add('module_srl', $this->module_srl);
                $oDocument->add('title', Context::get('title'));
            } else {
                $point = $oKinModel->getKinPoint($oDocument->document_srl);
                $oDocument->add('point', $point);
            }

            Context::set('oDocument', $oDocument);
        }

        function dispKinReply() {
            $oDocumentModel = &getModel('document');
            $oCommentModel = &getModel('comment');

            if(!$this->grant->write_reply) return new Object(-1,'msg_not_permitted');

            $document_srl = Context::get('document_srl');
            $oDocument = $oDocumentModel->getDocument($document_srl);
            if(!$oDocument->isExists()) return new Object(-1,'msg_invalid_request');

            $oComment = $oCommentModel->getComment(0);
            $oComment->add('module_srl', $this->module_srl);
            $oComment->add('document_srl', $document_srl);
            $oComment->add('comment_srl', getNextSequence());
            Context::set('oDocument', $oDocument);
            Context::set('oReply', $oComment);
        }

        function dispKinModifyReply() {
            $oCommentModel = &getModel('comment');

            $comment_srl = Context::get('comment_srl');
            if(!$comment_srl) return new Object(-1,'msg_invalid_request');

            $oReply = $oCommentModel->getComment($comment_srl);
            if(!$oReply->isExists() || !$oReply->isGranted()) return new Object(-1,'msg_not_permitted');

            Context::set('oReply', $oReply);
        }

    }
?>
