<?php
    /**            
     * @class CoolirisPlayer
     * @author 철쌤 (lamb91@naver.com)
     * @brief cooliris의 flash player을 출력하는 위젯
     * @version 2.0
     **/

    class CoolirisPlayer extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {

	  		//추출대상 선택
			$optionis = isset($args->optionis) == true ? $args->optionis : 1;

			// 추출대상 입력
            $source_input = $args->source_input;

			// 가상사이트(카페)명 입력
			$vid_input = $args->vid_input;

			// MediaRSS 주소 생성
			if($optionis == 1) { 
				$data = Context::get('request_uri').'/?rssType=piclens&mid='.$source_input.'&order_type=desc&list_count=100&piclens_mid='.$source_input;
				if($vid_input) $data .= '&vid='.$vid_input;
			}
			else if ($optionis == 2) $data = $source_input;

			$rsscode = urlencode($data);
			
			// 다양한 옵션
			$option_1 = isset($args->option_1) == true ? $args->option_1 : 'dark'; //스타일
			$option_2 = isset($args->option_2) == true ? $args->option_2 : 2; //세로목록수
			$option_3 = isset($args->option_3) == true ? $args->option_3 : 3; //벽면 기울임
			$option_4 = $args->option_4; //배경색
			$option_5 = $args->option_5; //배경이미지 경로
			$option_6 = $args->option_6; //이미지 노을색상
			$option_7 = isset($args->option_7) == true ? $args->option_7 : 'true'; //하단 도구모임
			$option_8 = isset($args->option_8) == true ? $args->option_8 : 'true'; //반사이미지
			$option_9 = isset($args->option_9) == true ? $args->option_9 : 'true'; //소스코드
			$option_10 = isset($args->option_10) == true ? $args->option_10 : 'true'; //검색버튼
			$option_11 = isset($args->option_11) == true ? $args->option_11 : 'true'; //튜토리얼 메시지
			$option_12 = isset($args->option_12) == true ? $args->option_12 : 'true'; //탐색화살표
			$option_13 = isset($args->option_13) == true ? $args->option_13 : 'true'; //설명표시

			// 옵션정리
			if($option_1) $option .='&style='.$option_1;
			if($option_2) $option .='&numRows='.$option_2;
			if($option_3) $option .='&tilt='.$option_3;
			if($option_4) $option .='&backgroundColor='.$option_4;
			if($option_5) $option .='&backgroundImage='.$option_5;
			if($option_6) $option .='&glowColor='.$option_6;
			if($option_7) $option .='&showChrome='.$option_7;
			if($option_8) $option .='&showReflections='.$option_8;
			if($option_9) $option .='&showEmbed='.$option_9;
			if($option_10) $option .='&showSearch='.$option_10;
			if($option_11) $option .='&showTutorial='.$option_11;
			if($option_12) $option .='&showNavArrows='.$option_12;
			if($option_13) $option .='&showDescription='.$option_13;

			// 플레이어 가로, 세로크기
			$width = isset($args->f_width) == true ? $args->f_width : '.100';
			$height = isset($args->f_height) == true ? $args->f_height : '450';
			$width = ereg('\.',$width) == true ? str_replace('.','',$width).'%' : $width;
			$height = ereg('\.',$height) == true ? str_replace('.','',$height).'%' : $height;

            // 템플릿의 스킨 경로를 지정 (skin)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            
            // 템플릿 파일을 지정
            $tpl_file = 'list';

			$widget_info->rsscode = $rsscode;
            $widget_info->option = $option;
            $widget_info->f_width = $width;
            $widget_info->f_height = $height;

            Context::set('widget_info', $widget_info);

			// 템플릿 컴파일
			$oTemplate = &TemplateHandler::getInstance();
			return $oTemplate->compile($tpl_path, $tpl_file);
        }
    }
?>