<?php
    if (!defined("__ZBXE__")) exit();

    /**
     * @file statistics.addon.php
     * @author mooo (hhyoon@gmail.com, http://mooo.org)
     * @brief 접속 통계 애드온
     * @license GPL2
     **/

    if (Context::getResponseMethod() == 'XMLRPC' or $this->module == 'admin') return;
    if (preg_match("/\.(jpg|gif|png|php|js|css)$/", $_SERVER['REQUEST_URI'])) return;

     // block access request
    if ($called_position == 'before_module_init') {

        // check for enable blocking
        $oStatisticsModel = &getModel('statistics');
        if (!$oStatisticsModel->checkValidAccess()) $oStatisticsModel->sendHttpHeader();
        if (!$oStatisticsModel->checkEnableBlocking()) return;

        $statistics = &getController('statistics');
        $statistics->procStatisticsBlock();
    }

    // log access request
    else if ($called_position == 'after_module_proc') {

        // check for enable logging
        $oStatisticsModel = &getModel('statistics');
        if (!$oStatisticsModel->checkEnableLogging()) return;

        // set arguments
        // page info
        $site_module_info = Context::get('site_module_info');
        $args->site_srl = (int) $site_module_info->site_srl;

        $args->today = date('Ymd');
        $args->hour = (int) (date("G")) + 1;

        $args->mid = Context::get('mid');
        if (!$args->mid and $this->mid) $args->mid = $this->mid;

        $args->module = Context::get('module');
        if (!$args->module and $this->module) $args->module = $this->module;

        $args->act = Context::get('act');
        if (!$args->act and $this->act) $args->act = $this->act;


        $args->document_srl = Context::get('document_srl') ? Context::get('document_srl') : 0;
        if (!$args->document_srl and $this->document_srl) $args->document_srl = $this->document_srl;
        if (!$args->document_srl) {
            $document_list = Context::get('document_list');
            if ($document_list and count($document_list) == 1) {
                foreach ($document_list as $oDocument);
                if ($oDocument) $args->document_srl = $oDocument->document_srl;
            }
        }

        $args->message = Context::get('message');
        if (!$args->message and $this->message) $args->message = $this->message;

        // internal search keyword
        if (Context::get('search_keyword')) {
            $args->search_keyword = Context::get('search_keyword');
        } else if ($this->act == 'IS' and Context::get('is_keyword')) {
            $args->search_keyword = Context::get('is_keyword');
        }
        $args->search_keyword = $args->search_keyword ? $oStatisticsModel->_urldecode($args->search_keyword) : '';

        // user info
        $args->ipaddress = $_SERVER['REMOTE_ADDR'];
        $args->user_agent = removeHackTag($_SERVER['HTTP_USER_AGENT']);
        $args->request_method = $_SERVER['REQUEST_METHOD'];
        $args->server_protocol = $_SERVER['SERVER_PROTOCOL'];
        $args->request_uri = removeHackTag($_SERVER['REQUEST_URI']);

        $logged_info = Context::get('logged_info');
        if ($logged_info) $args->member_srl = $logged_info->member_srl;
        else $args->member_srl = 0;

        // referer
        $referer = @parse_url($_SERVER["HTTP_REFERER"]);
        $args->referer_url = removeHackTag($_SERVER['HTTP_REFERER']);
        $args->referer_host = $referer['host'] ? $referer['host'] : '';
        $args->referer_keyword = $oStatisticsModel->getRefererKeyword($referer);

        // robot or tool
        $agent = $oStatisticsModel->getAgentValue($args->user_agent);
        $args->browser = $agent->browser ? $agent->browser : 'Unknown';
        $args->agent_type = $agent->agent_type ? $agent->agent_type : 'U';

        // country code
        $args->country_code = $oStatisticsModel->getCountryCode($args->ipaddress);


        $statistics = &getController('statistics');
        $statistics->procStatisticsExecute($args);
    }

?>
