<?php
    /**
     * @class  statisticsAdminView
     * @author mooo (hhyoon@gmail.com)
     * @brief  statistics 모듈의 Admin view class
     **/


    class statisticsAdminView extends statistics {

        /**
         * @brief 초기화
         **/
        function init() {

            // 템플릿 경로 지정
            $this->setTemplatePath($this->module_path .'tpl');
        }


        /**
         * @brief main page for admin
         **/
        function dispStatisticsAdminIndex() {

            $site_module_info = Context::get('site_module_info');
            $site_srl = $site_module_info ? (int) $site_module_info->site_srl : 0;

            $oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('statistics');

            $oStatisticsModel = &getModel('statistics');
            Context::set('oModel', $oStatisticsModel);


            if ($config->summary_view == 'T') {

                // total statistics
                unset($args);
                $args->site_srl = $site_srl;
                $total = $oStatisticsModel->getListStatisticsTotal($args);
                Context::set('total_statistics', $total->data);

                // daily statistics
                $args->list_count = 10;

                $statistics = $oStatisticsModel->getListStatisticsDay($args);
                Context::set('list_statistics', $statistics->data);

                // total count for visitors
                unset($args);
                $args->site_srl = $site_srl;
                $args->agent_type = 'U';
                $output = $oStatisticsModel->getTotalCountVisitors($args);
                Context::set('sum_visitors', $output->data->sum_visitors);

                // list of visitors
                $args->sort_index = 'count';
                $args->list_count = 5;
                $output = $oStatisticsModel->getListVisitors($args);
                Context::set('list_visitors', $output->data);

                // total count for referers
                unset($args);
                $args->site_srl = $site_srl;
                $output = $oStatisticsModel->getTotalCountReferers($args);
                Context::set('sum_referers', $output->data->sum_referers);

                // list of referers
                $args->sort_index = 'count';
                $args->list_count = 5;
                $output = $oStatisticsModel->getListReferers($args);
                Context::set('list_referers', $output->data);


                // for a chart of mids
                // total count for mids
                unset($args);
                $args->site_srl = $site_srl;

                $output = $oStatisticsModel->getTotalCountMidPageviews($args);
                Context::set('sum_mid_pageviews', $output->data->sum_pageviews);

                // set args for list
                $args->page = 1;
                $args->sort_index = 'count';
                $args->list_count = 5;
                $output = $oStatisticsModel->getListMidPageviews($args);
                Context::set('list_mid_pageviews', $output->data);


                // for a chart of browsers
                // total count for browsers
                unset($args);
                $args->site_srl = $site_srl;
                $args->agent_type = 'U';

                $output = $oStatisticsModel->getTotalCountAgents($args);
                Context::set('sum_browser_visitors', $output->data->sum_agent_visitors);
                Context::set('sum_browser_pageviews', $output->data->sum_agent_pageviews);

                // set args for list
                $args->page = 1;
                $args->sort_index = 'visitors';
                $args->sort_index2 = 'pageviews';
                $args->list_count = 5;
                $output = $oStatisticsModel->getListBrowsers($args);
                Context::set('list_browser_visitors', $output->data);


                // set template file
                $this->setTemplateFile('summary_table');
            }
            else {
                // total statistics
                unset($args);
                $args->site_srl = $site_srl;
                $total = $oStatisticsModel->getListStatisticsTotal($args);
                Context::set('total_statistics', $total->data);

                // daily statistics
                $view_days = $config->summary_daily ? $config->summary_daily : 7;
                $args->list_count = $view_days;

                $statistics = $oStatisticsModel->getListStatisticsDay($args);
                Context::set('list_statistics', $statistics->data);

                $categories = array();
                $pageviews = array();
                $visitors = array();
                $new_visitors = array();
                $max_pageviews = 0;

                foreach ($statistics->data as $val) {
                    array_unshift($categories, zdate($val->regdate, "m-d"));
                    array_unshift($pageviews, $val->pageviews);
                    array_unshift($visitors, $val->visitors);
                    array_unshift($new_visitors, $val->new_visitors);
                    $max_pageviews = ($max_pageviews > $val->pageviews) ? $max_pageviews : $val->pageviews;
                }


                // get max value of Y axis
                $max_axis = round(($max_pageviews + $max_pageviews / 10) / 100) * 100;
                $precision = (int) log10($max_pageviews);
                $base = pow(10, $precision - 1);
                for ($i = 1; $i < 10; $i++) {
                    $num_div = ($max_axis / ($base * $i)) - 1;
                    if ($num_div < 10) break;
                }

                $last_time = ztime($val->regdate);
                for ($i = 0; $i < $view_days - count($statistics->data); $i++) {
                    array_unshift($categories, date("m-d", strtotime("-". ($i + 1) ." days", $last_time)));
                    array_unshift($pageviews, 0);
                    array_unshift($visitors, 0);
                    array_unshift($new_visitors, 0);
                }


                for ($i = 0; $i < $view_days; $i++) {
                    $set_categories .= sprintf("<category name='%s' />", $categories[$i]);
                    $set_pageviews .= sprintf("<set value='%s' />", $pageviews[$i]);
                    $set_visitors .= sprintf("<set value='%s' />", $visitors[$i]);
                    $set_new_visitors .= sprintf("<set value='%s' />", $new_visitors[$i]);
                }

                $statistics_param = sprintf(
                    "<graph xAxisName='Date' yAxisName='Number' showColumnShadow='1' yAxisMaxValue='%d' ".
                    "rotateNames='0' animation='1' numDivLines='%d' ".
                    "divLineColor='CCCCCC' divLineAlpha='80' decimalPrecision='0' ".
                    "showAlternateHGridColor='1' alternateHGridAlpha='30' alternateHGridColor='CCCCCC' ".
                    "formatNumber='1' formatNumberScale='0' thousandSeparator=',' baseFontSize='11' valueFontSite='10' outCnvBaseFontSze='12' ".
                    "caption='Daily Statistics' >".
                    "<categories>%s</categories>".
                    //"<dataset seriesName='Pageviews' color='CC9999' areaBorderColor='660000'showAreaBorder='1' areaBorderThickness='2' showValues='0' alpha='90' areaAlpha='50'>%s</dataset>".
                    //"<dataset seriesName='Visitors' color='99CC99' areaBorderColor='006600'showAreaBorder='1' areaBorderThickness='2' showValues='0' alpha='90' areaAlpha='50'>%s</dataset>".
                    //"<dataset seriesName='New Visitors' color='9999CC' areaBorderColor='000066'showAreaBorder='1' areaBorderThickness='2' showValues='0' alpha='90' areaAlpha='50'>%s</dataset>".
                    "<dataset seriesName='Pageviews' color='FDC12E' showValues='1' fontSize='10' alpha='90'>%s</dataset>".
                    "<dataset seriesName='Visitors' color='56B9F9' showValues='1' fontSize='10' alpha='90'>%s</dataset>".
                    "<dataset seriesName='New Visitors' color='C9198D' showValues='1' fontSize='10' alpha='90'>%s</dataset>".
                    "</graph>",
                    $max_axis, $num_div, $set_categories, $set_pageviews, $set_visitors, $set_new_visitors
                );
                Context::set('statistics_param', $statistics_param);



                // total count for referers
                unset($args);
                $args->site_srl = $site_srl;
                $output = $oStatisticsModel->getTotalCountReferers($args);
                $sum_referers = $output->data->sum_referers;

                // list of referers
                $args->sort_index = 'count';
                $args->list_count = 5;
                $output = $oStatisticsModel->getListReferers($args);

                if ($output->toBool() and count($output->data)) {

                    $i = 0;
                    $current_sum_referers = 0;
                    $referer_param = '';
                    $colors = array('0000FF', '00FF00', 'FF0000', 'FFFF00', 'FF00FF', '56B9F9');
                    foreach ($output->data as $val) {
                        $referer_param .= $oStatisticsModel->getChartXmlParam($val->referer_host, $val->count, $colors[$i++]);
                        $current_sum_referers += $val->count;
                    }

                    if ($sum_referers > $current_sum_referers) {
                        $others = $sum_referers - $current_sum_referers;
                        $referer_param .= $oStatisticsModel->getChartXmlParam('Others', $others, 'CCCCCC');
                    }

                    $referer_param = $oStatisticsModel->getChartXmlPie('Referer', $referer_param, 100);
                    Context::set('referer_param', $referer_param);
                }


                // for a chart of agents
                // total count for agents
                unset($args);
                $args->site_srl = $site_srl;
                $args->agent_type = 'U';

                $output = $oStatisticsModel->getTotalCountAgents($args);
                $sum_browser_users = $output->data->sum_agent_visitors;

                // set args for list
                $args->page = 1;
                $args->sort_index = 'visitors';
                $args->sort_index2 = 'pageviews';
                $args->list_count = 5;
                $output = $oStatisticsModel->getListBrowsers($args);

                if ($output->toBool() and count($output->data)) {

                    $i = 0;
                    $current_sum_browsers = 0;
                    $browser_param = '';
                    $colors = array('0000FF', '00FF00', 'FF0000', 'FFFF00', 'FF00FF', '56B9F9');
                    foreach ($output->data as $val) {
                        $browser_param .= $oStatisticsModel->getChartXmlParam($val->browser, $val->visitors, $colors[$i++]);
                        $current_sum_browsers += $val->visitors;
                    }

                    if ($sum_browser_users > $current_sum_browsers) {
                        $others = $sum_browser_users - $current_sum_browsers;
                        $browser_param .= $oStatisticsModel->getChartXmlParam('Others', $others, 'CCCCCC');
                    }

                    $browser_param = $oStatisticsModel->getChartXmlPie('Browser', $browser_param, 100);
                    Context::set('browser_param', $browser_param);
                }



                // for a chart of mids
                // total count for mids
                unset($args);
                $args->site_srl = $site_srl;

                $output = $oStatisticsModel->getTotalCountMidPageviews($args);
                //debugPrint(print_r($output, true)); ///< DEBUG
                $sum_pageviews = $output->data->sum_pageviews;

                // set args for list
                $args->page = 1;
                $args->sort_index = 'count';
                $args->list_count = 5;
                $output = $oStatisticsModel->getListMidPageviews($args);
                //debugPrint(print_r($output, true)); ///< DEBUG

                if ($output->toBool() and count($output->data)) {

                    $i = 0;
                    $current_sum_pageviews = 0;
                    $mid_param = '';
                    $colors = array('0000FF', '00FF00', 'FF0000', 'FFFF00', 'FF00FF', '56B9F9');
                    foreach ($output->data as $val) {
                        if (!$val->mid) continue;
                        $mid_param .= $oStatisticsModel->getChartXmlParam($val->mid, $val->count, $colors[$i++]);
                        $current_sum_pageviews += $val->count;
                    }

                    if ($sum_pageviews > $current_sum_pageviews) {
                        $others = $sum_pageviews - $current_sum_pageviews;
                        if ($others > ($sum_pageviews / 100))
                            $mid_param .= $oStatisticsModel->getChartXmlParam('Others', $others, 'CCCCCC');
                    }

                    $mid_param = $oStatisticsModel->getChartXmlPie('Pageviews of Module IDs', $mid_param, 100);
                    Context::set('mid_param', $mid_param);
                }


                // for a chart of countries
                // total count for countries
                unset($args);
                $args->site_srl = $site_srl;
                $args->agent_type = 'U';

                $output = $oStatisticsModel->getTotalCountCountryVisitors($args);
                $sum_visitors = $output->data->sum_visitors;

                // set args for list
                $args->page = 1;
                $args->sort_index = 'count';
                $args->list_count = 5;
                $output = $oStatisticsModel->getListCountryVisitors($args);

                if ($output->toBool() and count($output->data)) {

                    $i = 0;
                    $current_sum_visitors = 0;
                    $country_param = '';
                    $colors = array('0000FF', '00FF00', 'FF0000', 'FFFF00', 'FF00FF', '56B9F9');
                    foreach ($output->data as $val) {
                        $country_param .= $oStatisticsModel->getChartXmlParam($oStatisticsModel->getCountryNameFromCode($val->country_code), $val->count, $colors[$i++]);
                        $current_sum_visitors += $val->count;
                    }

                    if ($sum_visitors > $current_sum_visitors) {
                        $others = $sum_visitors - $current_sum_visitors;
                        $country_param .= $oStatisticsModel->getChartXmlParam('Others', $others, 'CCCCCC');
                    }

                    $country_param = $oStatisticsModel->getChartXmlPie('Countries', $country_param, 100);
                    Context::set('country_param', $country_param);


                }

                // set template file
                $this->setTemplateFile('summary_chart');
            }


        }

        /**
         * @brief main page for admin
         **/
        function dispStatisticsAdminStatistics() {

            $site_module_info = Context::get('site_module_info');
            $site_srl = $site_module_info ? (int) $site_module_info->site_srl : 0;

            $oStatisticsModel = &getModel('statistics');

            // set unit
            $view_unit = Context::get('view_unit');

            // total statistics
            unset($args);
            $args->site_srl = $site_srl;
            $total = $oStatisticsModel->getListStatisticsTotal($args);
            Context::set('total_statistics', $total->data);

            // statistics list
            if ($view_unit == 'month')
                $statistics = $oStatisticsModel->getListStatisticsMonth($args);
            else if ($view_unit == 'year')
                $statistics = $oStatisticsModel->getListStatisticsYear($args);
            else
                $statistics = $oStatisticsModel->getListStatisticsDay($args);

            Context::set('list_statistics', $statistics->data);

            Context::set('total_count', $statistics->total_count);
            Context::set('total_page', $statistics->total_page);
            Context::set('page', $statistics->page);
            Context::set('page_navigation', $statistics->page_navigation);
            Context::set('oModel', $oStatisticsModel);

            // 템플릿 파일 지정
            $this->setTemplateFile('statistics');
        }

        /**
         * @brief view statistics log
         **/
        function dispStatisticsAdminLog() {

            $site_module_info = Context::get('site_module_info');
            $site_srl = $site_module_info ? (int) $site_module_info->site_srl : 0;

            $agent_type = Context::get('agent_type');
            if (!in_array($agent_type, array('A', 'U', 'R'))) $agent_type = 'U';

            // 목록을 구하기 위한 옵션
            $args->site_srl = $site_srl;
            $args->agent_type = $agent_type;
            $args->page = Context::get('page'); ///< 페이지

            $args->sort_index = 'regdate'; ///< 소팅 값

            $oStatisticsModel = &getModel('statistics');
            $output = $oStatisticsModel->getLogList($args);

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('statistics_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            Context::set('oModel', $oStatisticsModel);

            $this->setTemplateFile('log');
        }

        /**
         * @brief view statistics of agents
         **/
        function dispStatisticsAdminAgents() {

            $oStatisticsModel = &getModel('statistics');

            $site_module_info = Context::get('site_module_info');
            $site_srl = $site_module_info ? (int) $site_module_info->site_srl : 0;

            $agent_type = Context::get('agent_type');
            if (!in_array($agent_type, array('A', 'U', 'R'))) $agent_type = 'U';

            $view_period = Context::get('view_period');
            if (!in_array($view_period, array('total', 'today', 'yesterday', 'this_week', 'this_month', 'this_year'))) $view_period = 'total';

            switch ($view_period) {
                case 'today':
                    $args->regdate = date("Ymd");
                    break;
                case 'yesterday':
                    $args->regdate = date("Ymd", strtotime("-1 days"));
                    break;
                case 'this_week':
                    $args->from_date = date("Ymd", strtotime("-1 weeks"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_month':
                    $args->from_date = date("Ymd", strtotime("-1 months"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_year':
                    $args->from_date = date("Ymd", strtotime("-1 years"));
                    $args->to_date = date("Ymd");
                    break;
                default:
                    $args->regdate = 0;
                    break;
            }

            // total count for agents
            $args->site_srl = $site_srl;
            $args->agent_type = $agent_type;

            $output = $oStatisticsModel->getTotalCountAgents($args);
            Context::set('sum_agent_pageviews', $output->data->sum_agent_pageviews);
            Context::set('sum_agent_visitors', $output->data->sum_agent_visitors);

            // 목록을 구하기 위한 옵션
            $args->page = Context::get('page');
            $args->sort_index = 'visitors';
            $args->sort_index2 = 'pageviews';
            $output = $oStatisticsModel->getListAgents($args);

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('statistics_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            Context::set('oModel', $oStatisticsModel);

            $this->setTemplateFile('agents');
        }

        /**
         * @brief view statistics of referers
         **/
        function dispStatisticsAdminReferers() {

            $site_module_info = Context::get('site_module_info');
            $site_srl = $site_module_info ? (int) $site_module_info->site_srl : 0;

            $oStatisticsModel = &getModel('statistics');

            $view_period = Context::get('view_period');
            if (!in_array($view_period, array('total', 'today', 'yesterday', 'this_week', 'this_month', 'this_year'))) $view_period = 'total';

            switch ($view_period) {
                case 'today':
                    $args->regdate = date("Ymd");
                    break;
                case 'yesterday':
                    $args->regdate = date("Ymd", strtotime("-1 days"));
                    break;
                case 'this_week':
                    $args->from_date = date("Ymd", strtotime("-1 weeks"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_month':
                    $args->from_date = date("Ymd", strtotime("-1 months"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_year':
                    $args->from_date = date("Ymd", strtotime("-1 years"));
                    $args->to_date = date("Ymd");
                    break;
                default:
                    $args->regdate = 0;
                    break;
            }

            // total count for referers
            $args->site_srl = $site_srl;
            $output = $oStatisticsModel->getTotalCountReferers($args);
            Context::set('sum_referers', $output->data->sum_referers);

            // 목록을 구하기 위한 옵션
            $args->page = Context::get('page');
            $args->sort_index = 'count';
            $output = $oStatisticsModel->getListReferers($args);
            //debugPrint(print_r($output, true));

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('statistics_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            Context::set('oModel', $oStatisticsModel);

            // set template file
            $this->setTemplateFile('referers');
        }

        /**
         * @brief view statistics of visitors
         **/
        function dispStatisticsAdminVisitors() {

            $site_module_info = Context::get('site_module_info');
            $site_srl = $site_module_info ? (int) $site_module_info->site_srl : 0;

            $agent_type = Context::get('agent_type');
            if (!in_array($agent_type, array('A', 'U', 'R'))) $agent_type = 'U';

            $oStatisticsModel = &getModel('statistics');

            $view_period = Context::get('view_period');
            if (!in_array($view_period, array('total', 'today', 'yesterday', 'this_week', 'this_month', 'this_year'))) $view_period = 'total';

            switch ($view_period) {
                case 'today':
                    $args->regdate = date("Ymd");
                    break;
                case 'yesterday':
                    $args->regdate = date("Ymd", strtotime("-1 days"));
                    break;
                case 'this_week':
                    $args->from_date = date("Ymd", strtotime("-1 weeks"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_month':
                    $args->from_date = date("Ymd", strtotime("-1 months"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_year':
                    $args->from_date = date("Ymd", strtotime("-1 years"));
                    $args->to_date = date("Ymd");
                    break;
                default:
                    $args->regdate = 0;
                    break;
            }

            // total count for referers
            $args->site_srl = $site_srl;
            $args->agent_type = $agent_type;
            $output = $oStatisticsModel->getTotalCountVisitors($args);
            Context::set('sum_visitors', $output->data->sum_visitors);

            // option for listing
            $args->page = Context::get('page');
            $args->sort_index = 'count';
            $output = $oStatisticsModel->getListVisitors($args);

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('statistics_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            Context::set('oModel', $oStatisticsModel);

            // set template file
            $this->setTemplateFile('visitors');
        }

        /**
         * @brief view statistics of keywords
         **/
        function dispStatisticsAdminKeywords() {

            $site_module_info = Context::get('site_module_info');
            $site_srl = $site_module_info ? (int) $site_module_info->site_srl : 0;

            $oStatisticsModel = &getModel('statistics');

            $view_period = Context::get('view_period');
            if (!in_array($view_period, array('total', 'today', 'yesterday', 'this_week', 'this_month', 'this_year'))) $view_period = 'total';

            switch ($view_period) {
                case 'today':
                    $args->regdate = date("Ymd");
                    break;
                case 'yesterday':
                    $args->regdate = date("Ymd", strtotime("-1 days"));
                    break;
                case 'this_week':
                    $args->from_date = date("Ymd", strtotime("-1 weeks"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_month':
                    $args->from_date = date("Ymd", strtotime("-1 months"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_year':
                    $args->from_date = date("Ymd", strtotime("-1 years"));
                    $args->to_date = date("Ymd");
                    break;
                default:
                    $args->regdate = 0;
                    break;
            }

            // total count for referers
            $args->site_srl = $site_srl;
            $args->type = 'O';
            $output = $oStatisticsModel->getTotalCountKeywords($args);
            Context::set('sum_keywords', $output->data->sum_keywords);

            // option for listing
            $args->page = Context::get('page');
            $args->sort_index = 'count';
            $output = $oStatisticsModel->getListKeywords($args);

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('statistics_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            Context::set('oModel', $oStatisticsModel);

            // set template file
            $this->setTemplateFile('keywords');
        }


        /**
         * @brief view statistics of pages
         **/
        function dispStatisticsAdminPages() {

            $site_module_info = Context::get('site_module_info');
            $site_srl = $site_module_info ? (int) $site_module_info->site_srl : 0;

            $oStatisticsModel = &getModel('statistics');

            $view_period = Context::get('view_period');
            if (!in_array($view_period, array('total', 'today', 'yesterday', 'this_week', 'this_month', 'this_year'))) $view_period = 'total';

            switch ($view_period) {
                case 'today':
                    $args->regdate = date("Ymd");
                    break;
                case 'yesterday':
                    $args->regdate = date("Ymd", strtotime("-1 days"));
                    break;
                case 'this_week':
                    $args->from_date = date("Ymd", strtotime("-1 weeks"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_month':
                    $args->from_date = date("Ymd", strtotime("-1 months"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_year':
                    $args->from_date = date("Ymd", strtotime("-1 years"));
                    $args->to_date = date("Ymd");
                    break;
                default:
                    $args->regdate = 0;
                    break;
            }

            // total count for referers
            $args->site_srl = $site_srl;
            $output = $oStatisticsModel->getTotalCountPages($args);
            Context::set('sum_pages', $output->data->sum_pages);

            // option for listing
            $args->page = Context::get('page');
            $args->sort_index = 'count';
            $output = $oStatisticsModel->getListPages($args);

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('statistics_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            Context::set('oModel', $oStatisticsModel);

            // set template file
            $this->setTemplateFile('pages');
        }


        /**
         * @brief view statistics of pages
         **/
        function dispStatisticsAdminMids() {

            $site_module_info = Context::get('site_module_info');
            $site_srl = $site_module_info ? (int) $site_module_info->site_srl : 0;

            $oStatisticsModel = &getModel('statistics');

            $view_period = Context::get('view_period');
            if (!in_array($view_period, array('total', 'today', 'yesterday', 'this_week', 'this_month', 'this_year'))) $view_period = 'total';

            switch ($view_period) {
                case 'today':
                    $args->regdate = date("Ymd");
                    break;
                case 'yesterday':
                    $args->regdate = date("Ymd", strtotime("-1 days"));
                    break;
                case 'this_week':
                    $args->from_date = date("Ymd", strtotime("-1 weeks"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_month':
                    $args->from_date = date("Ymd", strtotime("-1 months"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_year':
                    $args->from_date = date("Ymd", strtotime("-1 years"));
                    $args->to_date = date("Ymd");
                    break;
                default:
                    $args->regdate = 0;
                    break;
            }

            // total count for referers
            $args->site_srl = $site_srl;
            $output = $oStatisticsModel->getTotalCountMidPageviews($args);
            Context::set('sum_pageviews', $output->data->sum_pageviews);

            // option for listing
            $args->page = Context::get('page');
            $args->sort_index = 'count';
            $output = $oStatisticsModel->getListMidPageviews($args);

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('statistics_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            Context::set('oModel', $oStatisticsModel);

            // set template file
            $this->setTemplateFile('mids');
        }

        /**
         * @brief view statistics of blocks
         **/
        function dispStatisticsAdminBlocks() {

            $site_module_info = Context::get('site_module_info');
            $site_srl = $site_module_info ? (int) $site_module_info->site_srl : 0;

            $oStatisticsModel = &getModel('statistics');

            $view_period = Context::get('view_period');
            if (!in_array($view_period, array('total', 'today', 'yesterday', 'this_week', 'this_month', 'this_year'))) $view_period = 'total';

            switch ($view_period) {
                case 'today':
                    $args->regdate = date("Ymd");
                    break;
                case 'yesterday':
                    $args->regdate = date("Ymd", strtotime("-1 days"));
                    break;
                case 'this_week':
                    $args->from_date = date("Ymd", strtotime("-1 weeks"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_month':
                    $args->from_date = date("Ymd", strtotime("-1 months"));
                    $args->to_date = date("Ymd");
                    break;
                case 'this_year':
                    $args->from_date = date("Ymd", strtotime("-1 years"));
                    $args->to_date = date("Ymd");
                    break;
                default:
                    $args->regdate = 0;
                    break;
            }

            // total count for referers
            $args->site_srl = $site_srl;
            $output = $oStatisticsModel->getTotalCountBlocks($args);
            Context::set('sum_blocks', $output->data->sum_blocks);

            // option for listing
            $args->page = Context::get('page');
            $args->sort_index = 'count';
            $args->sort_index2 = 'last_access';
            $output = $oStatisticsModel->getListBlocks($args);

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('statistics_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            Context::set('oModel', $oStatisticsModel);

            // set template file
            $this->setTemplateFile('blocks');
        }

        /**
         * @brief configurate this module
         **/
        function dispStatisticsAdminConfig() {

            // get module configuration by using the object of module model
            $oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('statistics');

            // set default value
            if (!$config->summary_view) $config->summary_daily = 'C';
            if (!$config->summary_daily) $config->summary_daily = '7';
            if (!$config->log_expire) $config->log_expire = '14';
            if (!$config->allow_log_admin) $config->allow_log_admin = 'N';
            if (!$config->allow_log_robot) $config->allow_log_robot = 'Y';
            if (!$config->filter_agent) $config->filter_agent = 'N';
            if (!$config->filter_agents) $config->filter_agents = '';
            if (!$config->filter_ipaddress) $config->filter_ipaddress = 'N';
            if (!$config->filter_ipaddresses) $config->filter_ipaddresses = '';
            if (!$config->use_block) $config->use_block = 'N';
            if (!$config->block_interval) $config->block_interval = '1';
            if (!$config->block_requests) $config->block_requests = '10';
            if (!$config->block_period) $config->block_period = '10';

            $config->filter_agents = str_replace(',', "\n", $config->filter_agents);
            $config->filter_ipaddresses = str_replace(',', "\n", $config->filter_ipaddresses);

            Context::set('config', $config);

            // set template file
            $this->setTemplateFile('config');
        }

    }

?>
