<?php
    /**
     * @class  statisticsAdminController
     * @author mooo (hhyoon@gmail.com)
     * @brief  statistics module의 admin controller class
     **/

    class statisticsAdminController extends statistics {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 접속 통계 모듈의 기본 정보 추가
         **/
        function procStatisticsAdminInsertConfig() {

            // 기본 정보를 받음
            $args = Context::gets(
                'summary_view', 'summary_daily', 'log_expire', 'allow_log_admin', 'allow_log_robot',
                'filter_agent', 'block_agent', 'filter_agents',
                'filter_ipaddress', 'block_ipaddress', 'filter_ipaddresses',
                'use_block', 'block_interval', 'block_requests', 'block_period'
            );

            if (!$args->summary_view) $args->summary_view = 'C';
            if (!$args->summary_daily) $args->summary_daily = 7;
            if (!$args->log_expire) $args->log_expire = 14;
            if (!$args->allow_log_admin) $args->allow_log_admin = 'N';
            if (!$args->allow_log_robot) $args->allow_log_robot = 'N';
            if (!$args->filter_agent) $args->filter_agent = 'N';
            if (!$args->block_agent) $args->block_agent = 'N';
            if (!$args->filter_agents) $args->filter_agents = '';
            if (!$args->filter_ipaddress) $args->filter_ipaddress = 'N';
            if (!$args->block_ipaddress) $args->block_ipaddress = 'N';
            if (!$args->filter_ipaddresses) $args->filter_ipaddresses = '';
            if (!$args->use_block) $args->use_block = 'N';
            if (!$args->block_interval) $args->block_interval = '1';
            if (!$args->block_requests) $args->block_requests = '10';
            if (!$args->block_period) $args->block_period = '10';

            $args->log_expire = (int) $args->log_expire;
            $args->filter_agents = str_replace("\r", '', $args->filter_agents);
            $args->filter_agents = str_replace("\n", ',', $args->filter_agents);
            $args->filter_ipaddresses = str_replace("\r", '', $args->filter_ipaddresses);
            $args->filter_ipaddresses = str_replace("\n", ',', $args->filter_ipaddresses);

            // sort filter_agents
            $filter_agents = explode(',', $args->filter_agents);
            sort($filter_agents);
            $args->filter_agents = implode(',', $filter_agents);

            // sort filter_ipaddresses
            $filter_ipaddresses = explode(',', $args->filter_ipaddresses);
            sort($filter_ipaddresses);
            $args->filter_ipaddresses = implode(',', $filter_ipaddresses);

            // module Controller 객체 생성하여 입력
            $oModuleController = &getController('module');
            $output = $oModuleController->insertModuleConfig('statistics', $args);
            return $output;
        }

    }

?>
