<?php
    /**
     * @class  statisticsController
     * @author mooo (hhyoon@gmail.com)
     * @brief  statistics 모듈의 controller class
     **/

    class statisticsController extends statistics {

        /**
         * @brief initialization
         **/
        function init() {
        }

        /**
         * @brief arrange data and insert log
         **/
        function procStatisticsExecute($args) {

            if (!$args or !isset($args->today)) return;

            // prepare db connection
            $oDB = &DB::getInstance();
            $oDB->begin();

            // update statistics
            $this->updateStatistics($args);

            // update agent
            $this->updateAgentPageview($args);

            // update visitor
            $this->updateVisitor($args);

            if ($args->agent_type == 'U') {
                // update page
                $this->updatePage($args);

                // update referer
                $this->updateReferer($args);

                // update keyword
                $this->updateKeyword($args);
            }

            // delete expired logs
            $this->deleteExpiredLogs();

            // insert access log
            $this->insertLog($args);

            // commit queries
            $oDB->commit();
        }

        /**
         * @brief update statistics
         **/
        function updateStatistics($obj) {

            // get module configuration by using the object of module model
            $oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('statistics');

            $oModel = &getModel('statistics');

            $args->regdate = "0, ". $obj->today;
            $args->site_srl = $site_srl;

            // insert statistics
            $output = executeQuery('statistics.getStatusStatistics', $args);
            if (!$output->toBool()) return;

            if ($output->data->count == 0) {
                $args->regdate = 0;
                $output = executeQuery('statistics.insertStatisticsStatistics', $args);

                for ($i = 1; $i <= 24; $i++) {
                    $args->regdate = $i;
                    $output = executeQuery('statistics.insertStatisticsStatistics', $args);
                }

                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsStatistics', $args);
            }
            else if ($output->data->count == 1) {
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsStatistics', $args);
            }

            $args->regdate = sprintf("0, %d, %s", $obj->hour, $obj->today);

            // block access
            if ($obj->message == 'BlockAccess') {
                // update the counter for block visitors
                if (!$oModel->isUniqueBlock($args->site_srl))
                    $output = executeQuery('statistics.updateCounterBlock', $args);

                // update the counter for block pageviews
                $output = executeQuery('statistics.updateCounterBlockPageview', $args);
            }
            // normal user browser
            else if ($obj->agent_type == 'U') {

                // update the counter for visitors
                if (!$oModel->isUniqueVisitor($args->site_srl))
                    $output = executeQuery('statistics.updateCounterVisitor', $args);

                // update the counter for new visitors
                if (!$oModel->isNewVisitor($args->site_srl))
                    $output = executeQuery('statistics.updateCounterNewVisitor', $args);

                // update the counter for pageviews
                $output = executeQuery('statistics.updateCounterPageview', $args);

                // update the counter for referers
                if ($obj->referer_host and $obj->referer_url and strpos($obj->referer_host, $_SERVER['HTTP_HOST']) === false)
                    $output = executeQuery('statistics.updateCounterReferer', $args);

                // update the counter for referer keywords
                if ($obj->referer_keyword)
                    $output = executeQuery('statistics.updateCounterKeyword', $args);

                // update the counter for in-site-search
                if ($obj->search_keyword)
                    $output = executeQuery('statistics.updateCounterInSearch', $args);

            }
            // robot or tool
            else {
                // update the counter for robot visitors
                if (!$oModel->isUniqueVisitor($args->site_srl))
                    $output = executeQuery('statistics.updateCounterRobot', $args);

                // update the counter for robot pageviews
                $output = executeQuery('statistics.updateCounterRobotPageview', $args);
            }

        }

        /**
         * @brief update agent pageview
         **/
        function updateAgentPageview($obj) {

            $args->regdate = "0, ". $obj->today;
            $args->site_srl = $obj->site_srl;
            $args->browser = $obj->browser;
            $args->user_agent = $obj->user_agent;
            $args->agent_type = $obj->agent_type;

            $output = executeQuery('statistics.getStatusAgent', $args);
            if (!$output->toBool()) return;

            if ($output->data->count == 0) {
                $args->regdate = 0;
                $output = executeQuery('statistics.insertStatisticsAgent', $args);
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsAgent', $args);
            }
            else if ($output->data->count == 1) {
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsAgent', $args);
            }
            else {
                $output = executeQuery('statistics.updateStatisticsAgentPageview', $args);
            }
        }

        /**
         * @brief update visitor
         **/
        function updateVisitor($obj) {

            $args->regdate = "0, ". $obj->today;
            $args->site_srl = $obj->site_srl;
            $args->ipaddress = $obj->ipaddress;
            $args->country_code = $obj->country_code;
            $args->browser = $obj->browser;
            $args->user_agent = $obj->user_agent;
            $args->agent_type = $obj->agent_type;

            $output = executeQuery('statistics.getStatusVisitor', $args);
            if (!$output->toBool()) return;

            if ($output->data->count == 0) {
                $args->regdate = 0;
                $output = executeQuery('statistics.insertStatisticsVisitor', $args);
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsVisitor', $args);

                $args->regdate = "0, ". $obj->today;
                $output = executeQuery('statistics.updateStatisticsAgentVisitor', $args);
            }
            else if ($output->data->count == 1) {
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsVisitor', $args);
                $output = executeQuery('statistics.updateStatisticsAgentVisitor', $args);
            }
            else {
                $output = executeQuery('statistics.updateStatisticsVisitor', $args);
            }
        }

        /**
         * @brief update page
         **/
        function updatePage($obj) {

            if (!$obj->module and !$obj->mid and !$obj->document_srl and !$obj->act) return;

            $args->regdate = "0, ". $obj->today;
            $args->site_srl = $obj->site_srl;
            $args->module = $obj->module;
            $args->mid = $obj->mid;
            $args->document_srl = $obj->document_srl;
            $args->act = $obj->act;

            $output = executeQuery('statistics.getStatusPage', $args);
            if (!$output->toBool()) return;

            if ($output->data->count == 0) {
                $args->regdate = 0;
                $output = executeQuery('statistics.insertStatisticsPage', $args);
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsPage', $args);
            }
            else if ($output->data->count == 1) {
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsPage', $args);
            }
            else {
                $output = executeQuery('statistics.updateStatisticsPage', $args);
            }
        }

        /**
         * @brief update referer
         **/
        function updateReferer($obj) {

            if (strpos($obj->referer_host, $_SERVER['HTTP_HOST']) !== false) return;
            if (!$obj->referer_url or !$obj->referer_host) return;

            $args->regdate = "0, ". $obj->today;
            $args->site_srl = $obj->site_srl;
            $args->referer_host = $obj->referer_host;
            $args->referer_url = $obj->referer_url;

            $output = executeQuery('statistics.getStatusReferer', $args);
            if (!$output->toBool()) return;

            if ($output->data->count == 0) {
                $args->regdate = 0;
                $output = executeQuery('statistics.insertStatisticsReferer', $args);
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsReferer', $args);
            }
            else if ($output->data->count == 1) {
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsReferer', $args);
            }
            else {
                $output = executeQuery('statistics.updateStatisticsReferer', $args);
            }
        }

        /**
         * @brief update keyword
         **/
        function updateKeyword($obj) {

            if (!$obj->search_keyword and !$obj->referer_keyword) return;

            $args->regdate = "0, ". $obj->today;
            $args->site_srl = $obj->site_srl;
            if ($obj->search_keyword) {
                $args->type = 'I';
                $args->keyword = $obj->search_keyword;
                $args->host = 'localhost';
            }
            else if ($obj->referer_keyword) {
                $args->type = 'O';
                $args->keyword = $obj->referer_keyword;
                $args->host = $obj->referer_host;
            }

            $output = executeQuery('statistics.getStatusKeyword', $args);
            if (!$output->toBool()) return;

            if ($output->data->count == 0) {
                $args->regdate = 0;
                $output = executeQuery('statistics.insertStatisticsKeyword', $args);
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsKeyword', $args);
            }
            else if ($output->data->count == 1) {
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsKeyword', $args);
            }
            else {
                $output = executeQuery('statistics.updateStatisticsKeyword', $args);
            }
        }

        /**
         * @brief delete expired logs
         **/
        function deleteExpiredLogs() {

            $oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('statistics');

            if (!$config->log_expire or (is_numeric($config->log_expire) and $config->log_expire > 0)) {
                $log_expire = $config->log_expire ? $config->log_expire : 14;
                $log_expire = sprintf("-%d day", $log_expire);

                $args->regdate = date("YmdHis", strtotime($log_expire));
                return executeQuery('statistics.deleteExpiredLogs', $args);
            }
        }

        /**
         * @brief insert access log
         **/
        function insertLog($args) {
            if ($args->agent_type == 'U' or ($config->allow_log_robot == 'Y' and $args->agent_type != 'U'))
                $output = executeQuery('statistics.insertStatisticsLog', $args);
        }

        /**
         * @brief make a cache file of agents
         **/
        function makeCacheAgents() {

            if (!is_dir('./files/cache/statistics')) FileHandler::makeDir('./files/cache/statistics');

            $cache_file = "./files/cache/statistics/agents.php";
            $xml_file = './modules/statistics/libs/agents.xml';

            $oXmlParser = new XmlParser();
            $xml_obj = $oXmlParser->loadXmlFile($xml_file);

            if (!$xml_obj) {
                FileHandler::removeFile($cache_file);
                return false;
            }

            /*
            // using ordinary associative array
            $buff = '';
            foreach ($xml_obj->agents->item as $item) {
                if (!$item->attrs->browser or !$item->attrs->user_agent or !$item->attrs->agent_type) continue;
                if (!in_array($item->attrs->agent_type, array('U', 'R', 'T'))) continue;

                $buff .= sprintf(
                    'array("browser" => "%s", "user_agent" => "%s", "agent_type" => "%s"),',
                    $item->attrs->browser, $item->attrs->user_agent, $item->attrs->agent_type
                );
            }
            */

            // using object cast
            $buff = '';
            foreach ($xml_obj->agents->item as $item) {
                if (!$item->attrs->browser or !$item->attrs->user_agent or !$item->attrs->agent_type) continue;
                if (!in_array($item->attrs->agent_type, array('U', 'R', 'T'))) continue;

                $buff .= sprintf(
                    '(object) array("browser" => "%s", "user_agent" => "%s", "agent_type" => "%s"),',
                    $item->attrs->browser, $item->attrs->user_agent, $item->attrs->agent_type
                );
            }

            if ($buff) {
                $buff = sprintf('<?php if(!defined("__ZBXE__")) exit(); $array_agents = array(%s); ?>%s', $buff, "\n");
                FileHandler::writeFile($cache_file, $buff);
                return true;
            }

            return false;
        }


        /**
         * @brief make a cache file of agents
         **/
        function makeCacheCountries() {

            if (!is_dir('./files/cache/statistics')) FileHandler::makeDir('./files/cache/statistics');

            $cache_file = "./files/cache/statistics/countries.php";
            $xml_file = './modules/statistics/libs/countries.xml';

            $oXmlParser = new XmlParser();
            $xml_obj = $oXmlParser->loadXmlFile($xml_file);

            if (!$xml_obj) {
                FileHandler::removeFile($cache_file);
                return false;
            }

            // using object cast
            $buff = '';
            foreach ($xml_obj->countries->item as $item) {
                if (!$item->attrs->code or !$item->attrs->name) continue;

                $buff .= sprintf(
                    '(object) array("code" => "%s", "name" => "%s"),',
                    $item->attrs->code, $item->attrs->name
                );
            }

            if ($buff) {
                $buff = sprintf('<?php if(!defined("__ZBXE__")) exit(); $array_countries = array(%s); ?>%s', $buff, "\n");
                FileHandler::writeFile($cache_file, $buff);
                return true;
            }

            return false;
        }



        /**
         * @brief check previous access and block
         **/
        function procStatisticsBlock($args) {

            $oStatisticsModel = &getModel('statistics');
            if (!$oStatisticsModel->checkEnableBlocking()) return;

            // get module configuration by using the object of module model
            $oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('statistics');

            $block_interval = $config->block_interval ? $config->block_interval : 1;
            $block_requests = $config->block_requests ? $config->block_requests : 10;
            $block_period = $config->block_period ? $config->block_period : 10;

            // check block period
            $block_period = sprintf("-%d minutes", $block_period);

            $args->ipaddress = $_SERVER["REMOTE_ADDR"];
            $args->last_access = date("YmdHis", strtotime($block_period));
            $output = executeQuery('statistics.getStatusBlock', $args);

            if ($output->toBool() and $output->data->count) {
                $oStatisticsModel->sendHttpHeader();
            }

            // check access counter during block interval
            $block_interval = sprintf("-%d minutes", $block_interval);

            $args->ipaddress = $_SERVER["REMOTE_ADDR"];
            $args->regdate = date("YmdHis", strtotime($block_interval));
            $output = executeQuery('statistics.getCountAccess', $args);

            if (!$output->toBool() or ($output->data->count < $block_requests)) return;

            unset($args);

            // set arguments
            $site_module_info = Context::get('site_module_info');
            $args->site_srl = (int) $site_module_info->site_srl;

            $args->today = date('Ymd');
            $args->hour = (int) (date("G")) + 1;

            $args->mid = Context::get('mid') ? Context::get('mid') : '';
            $args->module = Context::get('module') ? Context::get('module') : '';
            $args->act = Context::get('act') ? Context::get('act') : '';
            $args->document_srl = Context::get('document_srl') ? Context::get('document_srl') : 0;
            $args->message = 'BlockAccess';

            // user info
            $args->ipaddress = $_SERVER['REMOTE_ADDR'];
            $args->user_agent = removeHackTag($_SERVER['HTTP_USER_AGENT']);
            $args->request_method = $_SERVER['REQUEST_METHOD'];
            $args->server_protocol = $_SERVER['SERVER_PROTOCOL'];
            $args->request_uri = removeHackTag($_SERVER['REQUEST_URI']);

            $logged_info = Context::get('logged_info');
            if ($logged_info) $args->member_srl = $logged_info->member_srl;
            else $args->member_srl = 0;

            // referer
            $referer = @parse_url($_SERVER["HTTP_REFERER"]);
            $args->referer_url = removeHackTag($_SERVER['HTTP_REFERER']);
            $args->referer_host = $referer['host'] ? $referer['host'] : '';
            $args->referer_keyword = $oStatisticsModel->getRefererKeyword($referer);

            // robot or tool
            $agent = $oStatisticsModel->getAgentValue($args->user_agent);
            $args->browser = $agent->browser ? $agent->browser : 'Unknown';
            $args->agent_type = $agent->agent_type ? $agent->agent_type : 'U';

            // country code
            $args->country_code = $oStatisticsModel->getCountryCode($args->ipaddress);


            // prepare db connection
            $oDB = &DB::getInstance();
            $oDB->begin();

            // update statistics
            $this->updateStatistics($args);

            // update block access
            $this->updateBlock($args);

            // insert access log
            $this->insertLog($args);

            // commit queries
            $oDB->commit();

            $oStatisticsModel->sendHttpHeader();

        }

        /**
         * @brief update block access
         **/
        function updateBlock($obj) {

            $args->regdate = "0, ". $obj->today;
            $args->site_srl = $obj->site_srl;
            $args->ipaddress = $obj->ipaddress;
            $args->country_code = $obj->country_code;
            $args->browser = $obj->browser;
            $args->user_agent = $obj->user_agent;
            $args->agent_type = $obj->agent_type;

            $output = executeQuery('statistics.getStatusBlock', $args);
            if (!$output->toBool()) return;

            if ($output->data->count == 0) {
                $args->regdate = 0;
                $output = executeQuery('statistics.insertStatisticsBlock', $args);
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsBlock', $args);
            }
            else if ($output->data->count == 1) {
                $args->regdate = $obj->today;
                $output = executeQuery('statistics.insertStatisticsBlock', $args);
            }
            else {
                $output = executeQuery('statistics.updateStatisticsBlock', $args);
            }
        }

    }

?>
