<?php
    /**
     * @class  statistics
     * @author mooo (hhyoon@gmail.com)
     * @brief  statistics 모듈의 high class
     **/

    class statistics extends ModuleObject {

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {

            // 설정 정보를 받아옴 (module model 객체를 이용)
            $oModuleModel = &getModel('module');
            $args = $oModuleModel->getModuleConfig('statistics');

            // 기본 정보를 세팅
            if (!$args->summary_view) $args->summary_view = 'C';
            if (!$args->summary_daily) $args->summary_daily = 7;
            if (!$args->log_expire) $args->log_expire = '14';
            if (!$args->allow_log_admin) $args->allow_log_admin = 'N';
            if (!$args->allow_log_robot) $args->allow_log_robot = 'Y';
            if (!$args->filter_agent) $args->filter_agent = 'N';
            if (!$args->block_agent) $args->block_agent = 'N';
            if (!$args->filter_agents) $args->filter_agents = 'libcurl-agent';
            if (!$args->filter_ipaddress) $args->filter_ipaddress = 'N';
            if (!$args->block_ipaddress) $args->block_ipaddress = 'N';
            if (!$args->filter_ipaddresses) $args->filter_ipaddresses = '';
            if (!$args->use_block) $args->use_block = 'N';
            if (!$args->block_interval) $args->block_interval = '1';
            if (!$args->block_requests) $args->block_requests = '10';
            if (!$args->block_period) $args->block_period = '10';

            // action forward에 등록 (관리자 모드에서 사용하기 위함)
            $oModuleController = &getController('module');
            $oModuleController->insertModuleConfig('statistics', $args);

            // action forward에 등록 (관리자 모드에서 사용하기 위함)
            $oModuleController = &getController('module');
            $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminIndex');
            $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminLog');
            $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminReferers');
            $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminAgents');
            $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminVisitors');
            $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminKeywords');
            $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminMids');
            $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminPages');
            $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminBlocks');
            $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminConfig');

            // 멀티 인덱스 설정
            $oDB = &DB::getInstance();
            $oDB->addIndex("statistics_agents", "idx_site_agent", array("regdate", "site_srl", "user_agent", "agent_type"), true);
            $oDB->addIndex("statistics_keywords", "idx_site_keyword_host", array("regdate", "site_srl", "keyword", "host"), true);
            $oDB->addIndex("statistics_pages", "idx_site_mid_act", array("regdate", "site_srl", "mid", "module", "document_srl", "act"), true);
            $oDB->addIndex("statistics_referers", "idx_site_host_url", array("regdate", "site_srl", "referer_host", "referer_url"), true);
            $oDB->addIndex("statistics_statistics", "idx_site_regdate", array("regdate", "site_srl", "regdate"), true);
            $oDB->addIndex("statistics_visitors", "idx_site_ipaddress_agent", array("regdate", "site_srl", "ipaddress", "user_agent", "agent_type"), true);
            $oDB->addIndex("statistics_blocks", "idx_site_ipaddress_agent", array("regdate", "site_srl", "ipaddress", "user_agent", "agent_type"), true);
            $oDB->addIndex("statistics_log", "idx_site_agent", array("regdate", "site_srl", "user_agent", "agent_type"), false);

            return new Object();
        }


        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
            FileHandler::removeFilesInDir(_XE_PATH_ ."files/cache/statistics");

            $oModuleModel = &getModel('module');
            if (!$oModuleModel->getActionForward('dispStatisticsAdminMids')) return true;

            return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');

            if (!$oModuleModel->getActionForward('dispStatisticsAdminMids'))
                $oModuleController->insertActionForward('statistics', 'view', 'dispStatisticsAdminMids');

            return new Object();
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
            FileHandler::removeFilesInDir(_XE_PATH_ ."files/cache/statistics");
        }

    }

?>
